<?php
namespace Shop\Services;

use Project\Models\Person\PersonQuery;
use Project\Models\Person\Person;
use Symfony\Component\HttpFoundation\Request;

/**
 * Description of Auth
 *
 * @author Dmitriy
 */
class Auth extends \Diamond\Services\Auth{

    protected $customerRepo;

    const PERSON_KEY = 'customer_id';

    public function __construct(\Aura\Auth\AuthFactory $authFactory,\Shop\Repositories\Customer $customerRepo) {
        parent::__construct($authFactory);
        $this->customerRepo = $customerRepo;
    }

    
    public function authCustomer($login, $password, $remeber = false) {

	if(!$User = $this->customerRepo->buildQuery()
		->filterByEmail($login)
		->filterByPassword($password)
		->findOne()){

	    return false;
	}
        
        $userdata	 = array(
		'customer_name'		=> $User->getName(),
		self::PERSON_KEY          => $User->getId(),
		'customer_email'	=> $User->getEmail()
	    );
        
        $userName = md5(serialize($userdata));

	//авторизующий серсис
	$login_service = $this->authFactory->newLoginService();

	//объект авторизации
	$auth = $this->authFactory->newInstance();
        
        
//        
//dump($auth->isAnon());
//dump(get_class_methods($auth));
//dump($auth->getUserName());
//dump($auth->getUserData());
//dump($userdata);
//dump($userName);

	if($auth->isAnon() || $auth->getUserName() != $userName){
	    
	    $login_service->forceLogin($auth, $userName , $userdata);
	}
        
       // exit("test");
	return true;
    }

    

    /**
     * Get Auth Person
     * @return boolean|Shop\Models\Customer\Customer
     */
    public function getAuthCustomer(){

	if($auth = $this->getAuth()){
	    
	     $userdata = $auth->getUserData();
	    
	    if(isset($userdata[self::PERSON_KEY])){

		if($Person = $this->customerRepo->findById($userdata[self::PERSON_KEY])){
		    return $Person;
		}		
		
	    }
	    
	}

	return false;
    }


}
