<?

namespace Shop\Repositories;

use Core\Repository\CrudInterface;
use Core\Repository\PropelQueryAbstract;
use Propel\Runtime\Collection\ObjectCollection;
use Shop\Models\Manager\Manager as ManagerEntity;
use Shop\Models\Manager\ManagerQuery;


/**
 * Description of Shop
 *
 * @author Admin
 */
class ShopManager extends PropelQueryAbstract implements CrudInterface{

    public function buildQuery(){
	return ManagerQuery ::create();
    }

    public function buildEntity(){
	return new ManagerEntity;
    }
   
    /**
     * Выбрать одного менеджера по офису
     * @param type $id
     * @return ManagerEntity
     */
    public function findByShopId($id)
    {
        return $this->buildQuery()
                ->filterByShopId($id)
                ->findOne()
                ;
    }
}
