<?php
namespace Shop\Repositories;

use Core\Repository\CrudInterface;
use Core\Repository\PropelQueryAbstract;
use Shop\Models\Customer\CustomerQuery;
use Shop\Models\Customer\Customer as CustomerEntity;
/**
 * Description of Brand
 *
 * @author Dmitriy
 */
class Customer extends PropelQueryAbstract implements CrudInterface, \Core\Repository\DropdownInreface{

    public function buildEntity(){
	return new CustomerEntity;
    }

    public function buildQuery(){
	return CustomerQuery::create();
    }
    
    /**
     * 
     * @param type $email
     * @return CustomerEntity
     */
    public function findByEmail($email) {
        return $this->buildQuery()->findOneByEmail($email);
    }
    
    /**
     * 
     * @param type $email
     * @param type $pass
     * @return CustomerEntity
     */
    public function findByEmailPassword($email,$pass) {
        return $this->buildQuery()->filterByEmail($email)->filterByPassword($pass)->findOne();
    }
    
    public function getDropdownList() {
        return $this->buildQuery()
		->orderByName()
		->find()
		->toKeyValue('id','name');
    }    
}
