<?php
namespace Shop\Repositories;

use Core\Repository\CrudInterface;
use Core\Repository\DropdownInreface;
use Core\Repository\PropelQueryAbstract;
use Shop\Models\City\CityQuery;
use Shop\Models\City\City as CityEntity;
/**
 * Description of Brand
 *
 * @author Dmitriy
 */
class City extends PropelQueryAbstract implements CrudInterface, DropdownInreface{

    /**
     * 
     * @return CityEntity
     */
    public function buildEntity():CityEntity{
	return new CityEntity;
    }

    /**
     * 
     * @return CityQuery
     */
    public function buildQuery():CityQuery{
	return CityQuery::create();
    }
    
    public function getDropdownList(){
	return $this->buildQuery()
		->orderByName()
		->find()
		->toKeyValue('id','name');
    }
    
    public function getDropdownListByregion($region) {
        return $this->buildQuery()
                ->findByRegionId($region)
                ->toKeyValue('id','name');
    }
    
    /**
     * 
     * @param string $name
     * @return CityEntity
     */
    public function findByName($name) {
        return $this->buildQuery()
                ->filterByName($name)
                ->findOne();
    }
    
}
