<?php
namespace Shop\Repositories;

use Core\Repository\CrudInterface;
use Core\Repository\PropelQueryAbstract;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\Collection\ObjectCollection;
use Shop\Models\Category\Category as CategoryEntity;
use Shop\Models\Category\CategoryQuery;

/**
 * Description of Category
 *
 * @author Dmitriy
 */
class Category extends PropelQueryAbstract implements CrudInterface, \Core\Repository\DropdownInreface{

    public function buildEntity(): CategoryEntity{
	return new CategoryEntity;
    }

    public function buildQuery(): CategoryQuery{
	return CategoryQuery::create();
    }
    
    /**
     * получение списка
     * @return type
     */
    public function getDropdownList(){
	return $this->buildQuery()
		->orderByTitle()
		->find()
		->toKeyValue('id', 'title');
    }
    
    /**
     * получение списка
     * @return type
     */
    public function getDropdownListWithParent(){
	return $this->buildQuery()
		->orderByParentId()
                ->orderByTitle()
                ->filterByParentId(0, Criteria::GREATER_THAN)
		->find()
		->toKeyValue('id', 'nameWithParent');
    }  
    
    /**
     * получение списка
     * @return type
     */
    public function getDropdownListAllWithParent(){
	return $this->buildQuery()
		->orderByParentId()
                ->orderByTitle()
                //->filterByParentId(0, Criteria::GREATER_THAN)
		->find()
		->toKeyValue('id', 'nameWithParent');
    }     
    
    /**
     * 
     * @param type $parent
     * @return ObjectCollection
     */
    public function findByParentId($parent = null) : ObjectCollection {
        return $this->buildQuery()
		->orderByTitle()
                ->filterByParentId($parent)
		->find();
    }
    
    /**
     * Получение разделов только с товаров который имеет фото
     * @param type $shopId магазин к которому принадлежат товары
     * @param type $parent
     * @return ObjectCollection
     */
    public function findByParentIdWithImage($shopId, $parent = null) : ObjectCollection {
        return $this->buildQuery()
		->orderByTitle()
                ->filterByParentId($parent)
                ->useProductQuery()
                    ->filterByImg('', Criteria::GREATER_THAN)
                    ->usePositionQuery()
                           ->filterByShopId($shopId)
                           ->filterByRemain(0,Criteria::GREATER_THAN)
                    ->endUse()
                ->endUse()
                ->groupById()
		->find();
    }
    
    /**
     * @todo перевсти на корректный запрос по скидкам
     * Получение разделов с скидочными товарами
     * @param type $parent
     * @return ObjectCollection
     */
    public function findByParentIdWithImageAndSale($shopId, $parent = null) : ObjectCollection {
        return $this->buildQuery()
		->orderByTitle()
                ->filterByParentId($parent)
                ->useProductQuery()
                    ->filterByImg('', Criteria::GREATER_THAN)
                    ->usePositionQuery()
                           ->filterByShopId($shopId)
                           ->filterByRemain(0,Criteria::GREATER_THAN)
                           ->filterBySaleId(1)
                    ->endUse()                
                ->endUse()
                ->groupById()
		->find();        
    }
    
    /**
     * Поиск раздела по всевдониму
     * @param type $param
     */
    public function findOneByAlias($alias) {
        return $this->buildQuery()
		->filterByAlias($alias)
		->findOne();
    }
}
