<?

namespace Shop\Modules\AdminShopManagers;

use Core\Registry\Column;
use Core\Registry\Field;

/**
* Description of AdminShopManagers
*
* @author Diamond Code Generator
*/
class AdminShopManagers extends \Core\ModuleController{

    protected $repo;
    protected $tableFactory;
    protected $cBuilder;
    protected $shopRepo;

    function __construct(\Diamond\Factory\Table $tableFactory, \Core\Form\ControlBuilder $cBuilder,
                         \Shop\Repositories\ShopManager $repo, \Shop\Repositories\Shop $shopRepo)
    {
        $this->tableFactory = $tableFactory;
        $this->repo = $repo;
        $this->cBuilder = $cBuilder;
        $this->shopRepo  = $shopRepo;
    }

    
    public function process() {
        
        $table = $this->tableFactory->buildAdminTable("managers", $this->repo);
        
        $table
                ->addColumn(new Column("id", "№", 20, false, true))
                ->addColumn(new Column("name", "ФИО", 120))
                ->addColumn(new Column("email", "Электронная почта", 70))
                ->addColumn(new Column("phone", "Телефон", 70))
                ->addColumn((new Column("comment", "Комментарий", 120))->setFn([$this, "formatComment"]))
                ->addColumn((new Column("shop_id", "Торг.точка", 120))->setFn([$this, "formatShop"]))
        ;        
        
        $table
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildInput("name"), null, "required"
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildInput("email"), null, "required"
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildInput("phone")
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildTextArea("comment")
                ))
                ->addField(new Field(
                        $this->cBuilder
                        ->buildDropdownUniform("shop_id", \Shop\Helpers\Form::prepareDropdown($this->shopRepo,"торг.точку")), null, "required"
                ))                
                ;
                
                
        return $table->render();
    }
    
    /**
     * 
     * @param \Shop\Models\Manager\Manager $manager
     * @return type
     */
    public function formatComment(\Shop\Models\Manager\Manager $manager)
    {
        return \Shop\Helpers\Text::clearText($manager->getComment(), 120);
    }
    
    /**
     * 
     * @param \Shop\Models\Manager\Manager $manager
     * @return type
     */
    public function formatShop(\Shop\Models\Manager\Manager $manager)
    {
        $shop = $manager->getShop();
        return sprintf(
                "%s (%s)", $shop->getTitle(), \Shop\Helpers\Shop::getShopType($shop)
                );
    }    

}               