<?

namespace Shop\Modules\AdminProductGroups;

use Core\Registry\Column;
use Core\Registry\Field;

/**
 * Description of AdminProductGroups
 *
 * @author Diamond Code Generator
 */
class AdminProductGroups extends \Core\ModuleController
{

    protected $repo;
    protected $tableFactory;
    protected $cBuilder;

    function __construct(\Diamond\Factory\Table $tableFactory, \Core\Form\ControlBuilder $cBuilder,
                         \Shop\Repositories\ProductGroup $repo)
    {
        $this->tableFactory = $tableFactory;
        $this->repo = $repo;
        $this->cBuilder = $cBuilder;
    }

    public function process()
    {

        $table = $this->tableFactory->buildAdminTable("groups", $this->repo);

        $table
                ->addColumn(new Column("id", "№", 20, false, true))
                ->addColumn(new Column("name", "Название", 320))
        ;

        $table
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildInput("name"), null, "required"
                ))

        ;

        return $table->render();
    }

}