<?

namespace Shop\Modules\AdminClients;

use Core\Registry\Column;
use Core\Registry\Field;

/**
 * Description of AdminClients
 *
 * @author Diamond Code Generator
 */
class AdminClients extends \Core\ModuleController
{

    protected $customerRepo;
    protected $tableFactory;
    protected $cBuilder;
    protected $shopRepo;
    protected $confMain;
    protected $customerCervice;
    protected $customerGroup;
    protected $regionRepo;
    protected $cityRepo;

    function __construct(\Diamond\Factory\Table $tableFactory, \Core\Form\ControlBuilder $cBuilder,
                         \Shop\Repositories\Customer $customerRepo, \Shop\Repositories\Shop $shopRepo,
                         \Shop\Config\Main $confMain, \Shop\Services\Customer $customerCervice,
                         \Shop\Repositories\CustomerGroup $customerGroup, \Shop\Repositories\Region $regionRepo,
                         \Shop\Repositories\City $cityRepo
    )
    {
        $this->tableFactory = $tableFactory;
        $this->customerRepo = $customerRepo;
        $this->cBuilder = $cBuilder;
        $this->shopRepo = $shopRepo;
        $this->confMain = $confMain;
        $this->customerCervice = $customerCervice;
        $this->customerGroup = $customerGroup;
        $this->regionRepo = $regionRepo;
        $this->cityRepo = $cityRepo;
    }

    public function process()
    {
        $table = $this->tableFactory->buildAdminTable("clients", $this->getRepo());

        $table
                ->addColumn(new Column("id", "№", 20, false, true))
                ->addColumn(new Column("name", "ФИО", 160))
                ->addColumn(new Column("email", "E-mail", 120))
                ->addColumn(new Column("phone", "Телефон", 80))
                ->addColumn((new Column("registred", "Дата регистрации", 80))->setFn([$this, "formatcDate"]))
                ->addColumn((new Column("notify_type", "Уведомления", 70))->setFn([$this, "formatSmsNotify"]))
                ->addColumn((new Column("group_id", "Группа", 80))->setFn([$this, "formatGroup"]))
                ->addColumn((new Column("address", "Адрес", 120))->setFn([$this, "formatAddress"]))
                ->addColumn((new Column("office", "Офис", 100))->setFn([$this, "formatOffice"]))


        ;

        if (input_get('id')) {
            $table
                    ->addField(new Field(
                            $this->cBuilder
                            ->buildTextLabel("number")
                            ->setFn(function(\Shop\Models\Customer\Customer $customer) {
                                return $customer->getId();
                            }), "№"
                    ))
                    ->addField(new Field(
                            $this->cBuilder
                            ->buildTextLabel("registred")
                            ->setFn([$this, "formatcDate"])
                    ))
                    ->addField(new Field(
                            $this->cBuilder
                            ->buildTextLabel("lastauth")
                            ->setFn([$this, "formatLastAuth"]), "Дата последнего входа"
                    ))
            ;
        }
        $regionId = $cityId = null;
        if (input_get("id") && ! input_post("regionId")) {
            $regionId = $this->customerRepo->findById(input_get("id"))->getCustomerCity()->getRegionId();
            $cityId = $this->customerRepo->findById(input_get("id"))->getCityId();
            $cities = $this->cityRepo->getDropdownListByregion(
                    $regionId
            );
        } elseif ( ! $regionId = input_post("regionId")) {
            $cities = [null => 'город не выбран'];
        } else {
            $cities = $this->cityRepo->getDropdownListByregion($regionId);
        }

        $regions = $this->regionRepo->getDropdownList();
        $selectClass = "form-control unicase-form-control selectpicker";

        $table
                ->addHeader("Контактная информация")
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildInput("name"), "ФИО", "required"
                ))
                ->addField(new Field(
                        $this->cBuilder
                        ->buildInputSmall("email"), null, "required"
                ))
                ->addField(new Field(
                        $this->cBuilder
                        ->buildInputSmall("phone")->setId("phoneMask"), null, "required"
                ))
                ->addField(new Field(
                        $this->cBuilder
                        ->buildDropdownUniform("group_id", \Shop\Helpers\Form::prepareDropdown($this->customerGroup)
                        ), null, "required"
                ))
                ->addHeader("Уведомления")
                ->addField(new Field(
                        $this->cBuilder
                        ->buildDropdownUniform("notify_type", $this->customerCervice->getNotifyTypes()
                        ), null, "required", "Режим отправки уведомлений"
                ))
                ->addField(new Field(
                        $this->cBuilder
                        ->buildDropdownYNUniform("notify_order"), "Уведомления о заказах", "required",
                                                 "Продивжение заказов"
                ))
                ->addField(new Field(
                        $this->cBuilder
                        ->buildDropdownYNUniform("notify_news"), "Уведомления о новостях", "required",
                                                 "Новости, акции компании"
                ))
                ->addField(new Field(
                        $this->cBuilder
                        ->buildDropdownYNUniform("notify_product"), "Уведомления о товарах", "required",
                                                 "Новые поступления товаров"
                ))
                ->addHeader("Адрес")
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildDropdownUniform('regionId', $regions)
                        ->setValue($regionId)
                        ->onChange("select_city(this,'cityId')")
                        ->setId("regionId"), "Выберите область"
                        )
                )
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildDropdownUniform('city_id', $cities)
                        ->setValue($cityId)
                        ->setId("cityId")
                        , "Выберите город")
                )
                ->addHeader("Прочее")
                ->addField(new Field(
                        $this->cBuilder
                        ->buildDropdownYNUniform("blocked"), "Заблокирован", "required"
                ))
                ->addField(new Field(
                        $this->cBuilder
                        ->buildInputSmall("inn"), "ИНН"
                ))
                ->addField(new Field(
                        $this->cBuilder
                        ->buildInputLittle("discount"), "Скидка", null, "Персональная скидка, %"
                ))

        ;

        $this->cBuilder->buildJmask("phoneMask", $this->confMain->getMobileMask())->Render();

        return $table->render();
    }

    /**
     * 
     * @param \Shop\Models\Customer\Customer $customer
     * @return type
     */
    public function formatOffice(\Shop\Models\Customer\Customer $customer)
    {
        return $customer->getManager()->getShop()->getTitle();
    }

    /**
     * 
     * @param \Shop\Models\Customer\Customer $customer
     * @return type
     */
    public function formatAddress(\Shop\Models\Customer\Customer $customer)
    {
        $city = $customer->getCustomerCity();
        $region = $city->getCityRegion();

        return sprintf(
                "%s, г.%s", $region->getName(), $city->getName()
        );
    }

    /**
     * 
     * @param \Shop\Models\Customer\Customer $customer
     */
    public function formatSmsNotify(\Shop\Models\Customer\Customer $customer)
    {
        return $this->customerCervice->getNotifyTypes()[$customer->getNotifyType()];
    }

    /**
     * 
     * @param \Shop\Models\Customer\Customer $customer
     * @return type
     */
    public function formatcDate(\Shop\Models\Customer\Customer $customer)
    {
        return $customer->getRegistred() ? $customer->getRegistred()->format(\Diamond\Helpers\Date::formatDisplay()) : " - ";
    }

    public function formatLastAuth(\Shop\Models\Customer\Customer $customer)
    {
        return $customer->getLastauth() ? $customer->getLastauth()->format(\Diamond\Helpers\Date::formatDisplay()) : " не входил ";
    }

    /**
     * 
     * @param \Shop\Models\Customer\Customer $customer
     * @return type
     */
    public function formatGroup(\Shop\Models\Customer\Customer $customer)
    {
        return $customer->getCustomerGroup()->getName();
    }

    /**
     * 
     */
    protected function getRepo()
    {
        $conf = $this->confMain;
        return $this->customerRepo->setSelectFilter(function(\Shop\Models\Customer\CustomerQuery $query) use ($conf) {

                    return $query
                                    ->_if($conf->getDefaultGuestGroup())
                                    ->filterByGroupId($conf->getDefaultGuestGroup(),
                                                      \Propel\Runtime\ActiveQuery\Criteria::NOT_IN)
                                    ->_endif()
                                    ->orderById(\Propel\Runtime\ActiveQuery\Criteria::DESC);
                });
    }

}