<?php

namespace Shop\Modules\AdminBrands;

use Core\Form\Control as ControlForm;
use Core\Form\ControlBuilder;
use Core\ModuleController;
use Core\Registry\Column;
use Core\Registry\Control;
use Core\Registry\Factory\RepoRegistry;
use Core\Registry\Field;
use Shop\Helpers\Text;
use Shop\Models\Brand\Brand;
use Shop\Repositories\Brand as BrandRepo;

/**
 * Description of AdminBrands
 *
 * @author Dmitriy
 */
class AdminBrands extends ModuleController
{

    protected $controlBuilder;
    protected $brandRepo;
    protected $tableFactory;

    function __construct(\Diamond\Factory\Table $tableFactory, BrandRepo $brandRepo, ControlBuilder $controlBuilder)
    {


        $this->tableFactory = $tableFactory;

        $this->brandRepo = $brandRepo;
        $this->controlBuilder = $controlBuilder;
    }

    //put your code here
    public function process()
    {

        $registry = $this->tableFactory->buildAdminTable("brands", $this->brandRepo);

        $registry->setColumns([
            new Column("id", "№", 20, false, true),
            new Column("name", "Наименование", 70),
            new Column("alias", "Псевдоним", 70),
                    (new Column("desc", "Описание", 170))
                    ->setFn(function(Brand $brand) {
                                return Text::clearText($brand->getDesc());
                            }),
                    (new Column("img", "Логотип", 60))
                    ->setFn(function(Brand $brand) {
                                return Text::createImgFromText($brand->getDesc());
                            })
        ]);

        $registry->addField(
                        new Field(
                        $this->controlBuilder
                        ->buildInput("name"), 'Наименование', "required"
                ))
                ->addField(
                        new Field(
                        $this->controlBuilder
                        ->buildInput("alias"), 'Псевдоним', "required", "для использования в ЧПУ"
                ))
                ->addField(
                        new Field(
                        $this->controlBuilder
                        ->buildTextEditor("desc")
                        ->setHeight(200)
                        ->setCompact(true), 'Описание', NULL,
                                     "Первая картинка в описании будет использоваться в фильтре как логотип"
                ))
        ;



        return $registry->render();
    }

}