<?php

namespace Shop\Models\Shop;

use Shop\Models\Shop\Base\Shop as BaseShop;

/**
 * Skeleton subclass for representing a row from the 'shop_shops' table.
 *
 *
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 */
class Shop extends BaseShop
{

    const MSG_SHOP_MAIN = "Головной офис";
    const MSG_SHOP_DEALER = "Дилер/Представитель";
    const MSG_SHOP_STOCK = "Торговая точка";
    const MSG_SHOP_PROVIDER = "Поставщик";
    
    /**
     * Полный адресс
     * @return type
     */
    public function getFullAddress(): string
    {

        $address = $this->getAddress();

        $city = $address->getCity();
        $region = $city->getCityRegion();
        return trim(sprintf(
                "%s, %s, г.%s, ул. %s %s", $address->getPostCode(), $region->getName(), $city->getName(),
                     $address->getStreet(), $address->getHouse(), $address->getRoom() ? ", кв. " . $address->getRoom() : ""
        ),",");
    }
    
    public function getFullAddressCompact(): string
    {

        $address = $this->getAddress();

        $city = $address->getCity();
        $region = $city->getCityRegion();
        return trim(sprintf(
                "г.%s, ул. %s %s", $city->getName(),
                     $address->getStreet(), $address->getHouse(), $address->getRoom() ? ", кв. " . $address->getRoom() : ""
        ),",");
    }

    /**
     * Тип точки для отображения
     * @return string
     */
    public function getTypeDisplay():string
    {
        switch ($this->getType()) {
            case "main":

                return self::MSG_SHOP_MAIN;

                break;

            case "dealer":

                return self::MSG_SHOP_DEALER;

                break;

            default:

                return self::MSG_SHOP_STOCK . " офиса №" . $this->getParentId();

                break;
        }
    }
    
    /**
     * Title + type
     * @return string
     */
    public function getTitleWithType():string
    {
        return sprintf(
                "%s (%s)",
                $this->getTitle(),
                $this->getTypeDisplay()
                );
    }

}