<?php

namespace Shop\Models\Product;

use Shop\Models\Product\Base\Product as BaseProduct;
use Propel\Runtime\ActiveQuery\Criteria;

/**
 * Skeleton subclass for representing a row from the 'shop_products' table.
 *
 *
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 */
class Product extends BaseProduct
{

    const FAKE_PERCENT = 20;

    public function getOldPrice()
    {
        return ceil((self::FAKE_PERCENT / 100 + 1) * $this->getPrice());
    }

    /**
     * Получние цен товара
     * @return array
     */
    public function getPrices($shopId,$complex_rate = 0): array
    {
        $positions = $this->getPositions();
        $prices = [
            $this->getPrice()
        ];
        foreach ($positions as $position) {
            if($position->getShopId()!=$shopId){
                continue;
            }            
            $prices[] = $position->getPriceFinal($complex_rate);
        }
        asort($prices);
        return $prices;
    }
    
    /**
     * 
     * @param type $complex_rate
     * @return array
     */
    public function getPricesOld($shopId,$complex_rate = 0): array
    {
        
        $positions = $this->getPositions();
        $prices = [
            $this->getOldPrice()
        ];
        foreach ($positions as $position) {
            if($position->getShopId()!=$shopId){
                continue;
            }
            $prices[] = $position->getPriceOldFinal($complex_rate);
        }
        asort($prices);
        return $prices;
    }    

    /**
     * Получение позиций с ценами и колвом на равным 0
     * @return type
     */
    public function getCurrentPositions($shopId)
    {
        $criteria = new Criteria;
        $criteria
                ->add("remain", 0, Criteria::GREATER_THAN)
                ->add("price", 0, Criteria::GREATER_THAN)
                ->add("shop_id", $shopId)
                ;

        return $this->getPositions($criteria);
    }
    
    /**
     * 
     * @param type $type
     * @return type
     */
    public function getSalePositions($type, $shopId)
    {
        $criteria = new Criteria;
        $criteria->add("remain", 0, Criteria::GREATER_THAN);
        $criteria->add("price", 0, Criteria::GREATER_THAN);
        $criteria->add("sale_id", $type);
        $criteria->add("shop_id",$shopId);
        //$criteria->setLimit(1);

        $pos = $this->getPositions($criteria);

        return $pos;
    }    
    
    
    /**
     * 
     * @param type $type
     * @return type
     */
    public function getSalePositionsDiff($type, $shopId)
    {

        $pos = $this->getSalePositions($type, $shopId);
        $m = [];
        foreach ($pos as $p){
            $m []=  round($p->getPriceOld() - $p->getPrice());
        }
        
        return count($m) ? max($m) : 0;
    }  
    
    /**
     * 
     * @param type $type
     * @return type
     */
    public function getPricePositionsDiff($shopId,$complexRate)
    {

        $pos = $this->getPositions();
        $m = [];
        foreach ($pos as $p){
            if($p->getShopId()!=$shopId){
                continue;
            }
            $m []=  round($p->getPriceOldFinal($complexRate) - $p->getPriceFinal($complexRate));
        }
        
        return count($m) ? max($m) : 0;
    }        
    
    /**
     * является ли товар новинкой
     * @param type $days
     * @return type
     */
    public function isNewDate($days)
    {
        $date = date_create();
        date_sub($date, date_interval_create_from_date_string(sprintf('%s days', $days )));
        
        return $this->getDateCreate()->getTimestamp() >= $date->getTimestamp() ;
    }
    
    /**
     * 
     * @return type
     */
    public function getGroupListArray()
    {
        $list = [];
        foreach($this->getProductGroups() as $group){
            $list []= $group->getname();
        }
        return $list;
    }


}