<?php

namespace Shop\Models\Position;

use Shop\Models\Position\Base\Position as BasePosition;

/**
 * Skeleton subclass for representing a row from the 'shop_positions' table.
 *
 *
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 */
class Position extends BasePosition
{

    /**
     * округленная цена
     * @return type
     */
    public function getPriceFinal($complex_rate = 0)
    {
        return ceil($this->getPrice() * ($complex_rate/100+1));//ROUND( @price * (@complex_rate/100+1) , 2 )
    }
    
    /**
     * 
     * @param type $complex_rate
     * @return type
     */
    public function getPriceOldFinal($complex_rate = 0)
    {
        return ceil($this->getPriceOld() * ($complex_rate/100+1));
    }

    /**
     * Получение реальных размеров
     * @return type
     */
    public function getRealSizes():string
    {
        $desc = "";
        $sizes = $this->getShopPositionSizeTypeValues();
        foreach ($sizes as $size) {
            $desc .= sprintf("%s: %s; ", $size[0]->getName(), $size[1]);
        }
        return rtrim($desc, "; ");
    }

    /**
     * 
     */    
    public function getSaleDisplay():string
    {
        
    }

}