<?php

namespace Shop\Models\Customer\Base;

use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Shop\Models\Basket\Basket;
use Shop\Models\City\City;
use Shop\Models\Customer\Customer as ChildCustomer;
use Shop\Models\Customer\CustomerQuery as ChildCustomerQuery;
use Shop\Models\CustomerGroup\CustomerGroup;
use Shop\Models\Customer\Map\CustomerTableMap;
use Shop\Models\FastLink\FastLink;
use Shop\Models\Manager\Manager;
use Shop\Models\Order\Order;
use Shop\Models\SocialLogin\SocialLogin;

/**
 * Base class that represents a query for the 'shop_customer' table.
 *
 *
 *
 * @method     ChildCustomerQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildCustomerQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method     ChildCustomerQuery orderByEmail($order = Criteria::ASC) Order by the email column
 * @method     ChildCustomerQuery orderByPassword($order = Criteria::ASC) Order by the password column
 * @method     ChildCustomerQuery orderByPhone($order = Criteria::ASC) Order by the phone column
 * @method     ChildCustomerQuery orderByRegistred($order = Criteria::ASC) Order by the registred column
 * @method     ChildCustomerQuery orderByLastauth($order = Criteria::ASC) Order by the lastauth column
 * @method     ChildCustomerQuery orderByBlocked($order = Criteria::ASC) Order by the blocked column
 * @method     ChildCustomerQuery orderByNotifyType($order = Criteria::ASC) Order by the notify_type column
 * @method     ChildCustomerQuery orderByDelete($order = Criteria::ASC) Order by the delete column
 * @method     ChildCustomerQuery orderByDiscount($order = Criteria::ASC) Order by the discount column
 * @method     ChildCustomerQuery orderByInn($order = Criteria::ASC) Order by the inn column
 * @method     ChildCustomerQuery orderByInfoHidden($order = Criteria::ASC) Order by the info_hidden column
 * @method     ChildCustomerQuery orderByGroupId($order = Criteria::ASC) Order by the group_id column
 * @method     ChildCustomerQuery orderByCityId($order = Criteria::ASC) Order by the city_id column
 * @method     ChildCustomerQuery orderByManagerId($order = Criteria::ASC) Order by the manager_id column
 * @method     ChildCustomerQuery orderByNotifyOrder($order = Criteria::ASC) Order by the notify_order column
 * @method     ChildCustomerQuery orderByNotifyNews($order = Criteria::ASC) Order by the notify_news column
 * @method     ChildCustomerQuery orderByNotifyProducts($order = Criteria::ASC) Order by the notify_products column
 *
 * @method     ChildCustomerQuery groupById() Group by the id column
 * @method     ChildCustomerQuery groupByName() Group by the name column
 * @method     ChildCustomerQuery groupByEmail() Group by the email column
 * @method     ChildCustomerQuery groupByPassword() Group by the password column
 * @method     ChildCustomerQuery groupByPhone() Group by the phone column
 * @method     ChildCustomerQuery groupByRegistred() Group by the registred column
 * @method     ChildCustomerQuery groupByLastauth() Group by the lastauth column
 * @method     ChildCustomerQuery groupByBlocked() Group by the blocked column
 * @method     ChildCustomerQuery groupByNotifyType() Group by the notify_type column
 * @method     ChildCustomerQuery groupByDelete() Group by the delete column
 * @method     ChildCustomerQuery groupByDiscount() Group by the discount column
 * @method     ChildCustomerQuery groupByInn() Group by the inn column
 * @method     ChildCustomerQuery groupByInfoHidden() Group by the info_hidden column
 * @method     ChildCustomerQuery groupByGroupId() Group by the group_id column
 * @method     ChildCustomerQuery groupByCityId() Group by the city_id column
 * @method     ChildCustomerQuery groupByManagerId() Group by the manager_id column
 * @method     ChildCustomerQuery groupByNotifyOrder() Group by the notify_order column
 * @method     ChildCustomerQuery groupByNotifyNews() Group by the notify_news column
 * @method     ChildCustomerQuery groupByNotifyProducts() Group by the notify_products column
 *
 * @method     ChildCustomerQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildCustomerQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildCustomerQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildCustomerQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildCustomerQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildCustomerQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildCustomerQuery leftJoinCustomerGroup($relationAlias = null) Adds a LEFT JOIN clause to the query using the CustomerGroup relation
 * @method     ChildCustomerQuery rightJoinCustomerGroup($relationAlias = null) Adds a RIGHT JOIN clause to the query using the CustomerGroup relation
 * @method     ChildCustomerQuery innerJoinCustomerGroup($relationAlias = null) Adds a INNER JOIN clause to the query using the CustomerGroup relation
 *
 * @method     ChildCustomerQuery joinWithCustomerGroup($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the CustomerGroup relation
 *
 * @method     ChildCustomerQuery leftJoinWithCustomerGroup() Adds a LEFT JOIN clause and with to the query using the CustomerGroup relation
 * @method     ChildCustomerQuery rightJoinWithCustomerGroup() Adds a RIGHT JOIN clause and with to the query using the CustomerGroup relation
 * @method     ChildCustomerQuery innerJoinWithCustomerGroup() Adds a INNER JOIN clause and with to the query using the CustomerGroup relation
 *
 * @method     ChildCustomerQuery leftJoinCustomerCity($relationAlias = null) Adds a LEFT JOIN clause to the query using the CustomerCity relation
 * @method     ChildCustomerQuery rightJoinCustomerCity($relationAlias = null) Adds a RIGHT JOIN clause to the query using the CustomerCity relation
 * @method     ChildCustomerQuery innerJoinCustomerCity($relationAlias = null) Adds a INNER JOIN clause to the query using the CustomerCity relation
 *
 * @method     ChildCustomerQuery joinWithCustomerCity($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the CustomerCity relation
 *
 * @method     ChildCustomerQuery leftJoinWithCustomerCity() Adds a LEFT JOIN clause and with to the query using the CustomerCity relation
 * @method     ChildCustomerQuery rightJoinWithCustomerCity() Adds a RIGHT JOIN clause and with to the query using the CustomerCity relation
 * @method     ChildCustomerQuery innerJoinWithCustomerCity() Adds a INNER JOIN clause and with to the query using the CustomerCity relation
 *
 * @method     ChildCustomerQuery leftJoinManager($relationAlias = null) Adds a LEFT JOIN clause to the query using the Manager relation
 * @method     ChildCustomerQuery rightJoinManager($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Manager relation
 * @method     ChildCustomerQuery innerJoinManager($relationAlias = null) Adds a INNER JOIN clause to the query using the Manager relation
 *
 * @method     ChildCustomerQuery joinWithManager($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Manager relation
 *
 * @method     ChildCustomerQuery leftJoinWithManager() Adds a LEFT JOIN clause and with to the query using the Manager relation
 * @method     ChildCustomerQuery rightJoinWithManager() Adds a RIGHT JOIN clause and with to the query using the Manager relation
 * @method     ChildCustomerQuery innerJoinWithManager() Adds a INNER JOIN clause and with to the query using the Manager relation
 *
 * @method     ChildCustomerQuery leftJoinSocialLogin($relationAlias = null) Adds a LEFT JOIN clause to the query using the SocialLogin relation
 * @method     ChildCustomerQuery rightJoinSocialLogin($relationAlias = null) Adds a RIGHT JOIN clause to the query using the SocialLogin relation
 * @method     ChildCustomerQuery innerJoinSocialLogin($relationAlias = null) Adds a INNER JOIN clause to the query using the SocialLogin relation
 *
 * @method     ChildCustomerQuery joinWithSocialLogin($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the SocialLogin relation
 *
 * @method     ChildCustomerQuery leftJoinWithSocialLogin() Adds a LEFT JOIN clause and with to the query using the SocialLogin relation
 * @method     ChildCustomerQuery rightJoinWithSocialLogin() Adds a RIGHT JOIN clause and with to the query using the SocialLogin relation
 * @method     ChildCustomerQuery innerJoinWithSocialLogin() Adds a INNER JOIN clause and with to the query using the SocialLogin relation
 *
 * @method     ChildCustomerQuery leftJoinBasket($relationAlias = null) Adds a LEFT JOIN clause to the query using the Basket relation
 * @method     ChildCustomerQuery rightJoinBasket($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Basket relation
 * @method     ChildCustomerQuery innerJoinBasket($relationAlias = null) Adds a INNER JOIN clause to the query using the Basket relation
 *
 * @method     ChildCustomerQuery joinWithBasket($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Basket relation
 *
 * @method     ChildCustomerQuery leftJoinWithBasket() Adds a LEFT JOIN clause and with to the query using the Basket relation
 * @method     ChildCustomerQuery rightJoinWithBasket() Adds a RIGHT JOIN clause and with to the query using the Basket relation
 * @method     ChildCustomerQuery innerJoinWithBasket() Adds a INNER JOIN clause and with to the query using the Basket relation
 *
 * @method     ChildCustomerQuery leftJoinOrder($relationAlias = null) Adds a LEFT JOIN clause to the query using the Order relation
 * @method     ChildCustomerQuery rightJoinOrder($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Order relation
 * @method     ChildCustomerQuery innerJoinOrder($relationAlias = null) Adds a INNER JOIN clause to the query using the Order relation
 *
 * @method     ChildCustomerQuery joinWithOrder($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Order relation
 *
 * @method     ChildCustomerQuery leftJoinWithOrder() Adds a LEFT JOIN clause and with to the query using the Order relation
 * @method     ChildCustomerQuery rightJoinWithOrder() Adds a RIGHT JOIN clause and with to the query using the Order relation
 * @method     ChildCustomerQuery innerJoinWithOrder() Adds a INNER JOIN clause and with to the query using the Order relation
 *
 * @method     ChildCustomerQuery leftJoinFastLinkRelatedByOwnerCustomerId($relationAlias = null) Adds a LEFT JOIN clause to the query using the FastLinkRelatedByOwnerCustomerId relation
 * @method     ChildCustomerQuery rightJoinFastLinkRelatedByOwnerCustomerId($relationAlias = null) Adds a RIGHT JOIN clause to the query using the FastLinkRelatedByOwnerCustomerId relation
 * @method     ChildCustomerQuery innerJoinFastLinkRelatedByOwnerCustomerId($relationAlias = null) Adds a INNER JOIN clause to the query using the FastLinkRelatedByOwnerCustomerId relation
 *
 * @method     ChildCustomerQuery joinWithFastLinkRelatedByOwnerCustomerId($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the FastLinkRelatedByOwnerCustomerId relation
 *
 * @method     ChildCustomerQuery leftJoinWithFastLinkRelatedByOwnerCustomerId() Adds a LEFT JOIN clause and with to the query using the FastLinkRelatedByOwnerCustomerId relation
 * @method     ChildCustomerQuery rightJoinWithFastLinkRelatedByOwnerCustomerId() Adds a RIGHT JOIN clause and with to the query using the FastLinkRelatedByOwnerCustomerId relation
 * @method     ChildCustomerQuery innerJoinWithFastLinkRelatedByOwnerCustomerId() Adds a INNER JOIN clause and with to the query using the FastLinkRelatedByOwnerCustomerId relation
 *
 * @method     ChildCustomerQuery leftJoinFastLinkRelatedByCode($relationAlias = null) Adds a LEFT JOIN clause to the query using the FastLinkRelatedByCode relation
 * @method     ChildCustomerQuery rightJoinFastLinkRelatedByCode($relationAlias = null) Adds a RIGHT JOIN clause to the query using the FastLinkRelatedByCode relation
 * @method     ChildCustomerQuery innerJoinFastLinkRelatedByCode($relationAlias = null) Adds a INNER JOIN clause to the query using the FastLinkRelatedByCode relation
 *
 * @method     ChildCustomerQuery joinWithFastLinkRelatedByCode($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the FastLinkRelatedByCode relation
 *
 * @method     ChildCustomerQuery leftJoinWithFastLinkRelatedByCode() Adds a LEFT JOIN clause and with to the query using the FastLinkRelatedByCode relation
 * @method     ChildCustomerQuery rightJoinWithFastLinkRelatedByCode() Adds a RIGHT JOIN clause and with to the query using the FastLinkRelatedByCode relation
 * @method     ChildCustomerQuery innerJoinWithFastLinkRelatedByCode() Adds a INNER JOIN clause and with to the query using the FastLinkRelatedByCode relation
 *
 * @method     \Shop\Models\CustomerGroup\CustomerGroupQuery|\Shop\Models\City\CityQuery|\Shop\Models\Manager\ManagerQuery|\Shop\Models\SocialLogin\SocialLoginQuery|\Shop\Models\Basket\BasketQuery|\Shop\Models\Order\OrderQuery|\Shop\Models\FastLink\FastLinkQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildCustomer findOne(ConnectionInterface $con = null) Return the first ChildCustomer matching the query
 * @method     ChildCustomer findOneOrCreate(ConnectionInterface $con = null) Return the first ChildCustomer matching the query, or a new ChildCustomer object populated from the query conditions when no match is found
 *
 * @method     ChildCustomer findOneById(int $id) Return the first ChildCustomer filtered by the id column
 * @method     ChildCustomer findOneByName(string $name) Return the first ChildCustomer filtered by the name column
 * @method     ChildCustomer findOneByEmail(string $email) Return the first ChildCustomer filtered by the email column
 * @method     ChildCustomer findOneByPassword(string $password) Return the first ChildCustomer filtered by the password column
 * @method     ChildCustomer findOneByPhone(string $phone) Return the first ChildCustomer filtered by the phone column
 * @method     ChildCustomer findOneByRegistred(string $registred) Return the first ChildCustomer filtered by the registred column
 * @method     ChildCustomer findOneByLastauth(string $lastauth) Return the first ChildCustomer filtered by the lastauth column
 * @method     ChildCustomer findOneByBlocked(string $blocked) Return the first ChildCustomer filtered by the blocked column
 * @method     ChildCustomer findOneByNotifyType(string $notify_type) Return the first ChildCustomer filtered by the notify_type column
 * @method     ChildCustomer findOneByDelete(int $delete) Return the first ChildCustomer filtered by the delete column
 * @method     ChildCustomer findOneByDiscount(string $discount) Return the first ChildCustomer filtered by the discount column
 * @method     ChildCustomer findOneByInn(string $inn) Return the first ChildCustomer filtered by the inn column
 * @method     ChildCustomer findOneByInfoHidden(string $info_hidden) Return the first ChildCustomer filtered by the info_hidden column
 * @method     ChildCustomer findOneByGroupId(int $group_id) Return the first ChildCustomer filtered by the group_id column
 * @method     ChildCustomer findOneByCityId(int $city_id) Return the first ChildCustomer filtered by the city_id column
 * @method     ChildCustomer findOneByManagerId(int $manager_id) Return the first ChildCustomer filtered by the manager_id column
 * @method     ChildCustomer findOneByNotifyOrder(string $notify_order) Return the first ChildCustomer filtered by the notify_order column
 * @method     ChildCustomer findOneByNotifyNews(string $notify_news) Return the first ChildCustomer filtered by the notify_news column
 * @method     ChildCustomer findOneByNotifyProducts(string $notify_products) Return the first ChildCustomer filtered by the notify_products column *

 * @method     ChildCustomer requirePk($key, ConnectionInterface $con = null) Return the ChildCustomer by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOne(ConnectionInterface $con = null) Return the first ChildCustomer matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildCustomer requireOneById(int $id) Return the first ChildCustomer filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOneByName(string $name) Return the first ChildCustomer filtered by the name column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOneByEmail(string $email) Return the first ChildCustomer filtered by the email column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOneByPassword(string $password) Return the first ChildCustomer filtered by the password column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOneByPhone(string $phone) Return the first ChildCustomer filtered by the phone column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOneByRegistred(string $registred) Return the first ChildCustomer filtered by the registred column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOneByLastauth(string $lastauth) Return the first ChildCustomer filtered by the lastauth column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOneByBlocked(string $blocked) Return the first ChildCustomer filtered by the blocked column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOneByNotifyType(string $notify_type) Return the first ChildCustomer filtered by the notify_type column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOneByDelete(int $delete) Return the first ChildCustomer filtered by the delete column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOneByDiscount(string $discount) Return the first ChildCustomer filtered by the discount column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOneByInn(string $inn) Return the first ChildCustomer filtered by the inn column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOneByInfoHidden(string $info_hidden) Return the first ChildCustomer filtered by the info_hidden column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOneByGroupId(int $group_id) Return the first ChildCustomer filtered by the group_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOneByCityId(int $city_id) Return the first ChildCustomer filtered by the city_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOneByManagerId(int $manager_id) Return the first ChildCustomer filtered by the manager_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOneByNotifyOrder(string $notify_order) Return the first ChildCustomer filtered by the notify_order column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOneByNotifyNews(string $notify_news) Return the first ChildCustomer filtered by the notify_news column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOneByNotifyProducts(string $notify_products) Return the first ChildCustomer filtered by the notify_products column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildCustomer[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildCustomer objects based on current ModelCriteria
 * @method     ChildCustomer[]|ObjectCollection findById(int $id) Return ChildCustomer objects filtered by the id column
 * @method     ChildCustomer[]|ObjectCollection findByName(string $name) Return ChildCustomer objects filtered by the name column
 * @method     ChildCustomer[]|ObjectCollection findByEmail(string $email) Return ChildCustomer objects filtered by the email column
 * @method     ChildCustomer[]|ObjectCollection findByPassword(string $password) Return ChildCustomer objects filtered by the password column
 * @method     ChildCustomer[]|ObjectCollection findByPhone(string $phone) Return ChildCustomer objects filtered by the phone column
 * @method     ChildCustomer[]|ObjectCollection findByRegistred(string $registred) Return ChildCustomer objects filtered by the registred column
 * @method     ChildCustomer[]|ObjectCollection findByLastauth(string $lastauth) Return ChildCustomer objects filtered by the lastauth column
 * @method     ChildCustomer[]|ObjectCollection findByBlocked(string $blocked) Return ChildCustomer objects filtered by the blocked column
 * @method     ChildCustomer[]|ObjectCollection findByNotifyType(string $notify_type) Return ChildCustomer objects filtered by the notify_type column
 * @method     ChildCustomer[]|ObjectCollection findByDelete(int $delete) Return ChildCustomer objects filtered by the delete column
 * @method     ChildCustomer[]|ObjectCollection findByDiscount(string $discount) Return ChildCustomer objects filtered by the discount column
 * @method     ChildCustomer[]|ObjectCollection findByInn(string $inn) Return ChildCustomer objects filtered by the inn column
 * @method     ChildCustomer[]|ObjectCollection findByInfoHidden(string $info_hidden) Return ChildCustomer objects filtered by the info_hidden column
 * @method     ChildCustomer[]|ObjectCollection findByGroupId(int $group_id) Return ChildCustomer objects filtered by the group_id column
 * @method     ChildCustomer[]|ObjectCollection findByCityId(int $city_id) Return ChildCustomer objects filtered by the city_id column
 * @method     ChildCustomer[]|ObjectCollection findByManagerId(int $manager_id) Return ChildCustomer objects filtered by the manager_id column
 * @method     ChildCustomer[]|ObjectCollection findByNotifyOrder(string $notify_order) Return ChildCustomer objects filtered by the notify_order column
 * @method     ChildCustomer[]|ObjectCollection findByNotifyNews(string $notify_news) Return ChildCustomer objects filtered by the notify_news column
 * @method     ChildCustomer[]|ObjectCollection findByNotifyProducts(string $notify_products) Return ChildCustomer objects filtered by the notify_products column
 * @method     ChildCustomer[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class CustomerQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Shop\Models\Customer\Base\CustomerQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Shop\\Models\\Customer\\Customer', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildCustomerQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildCustomerQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildCustomerQuery) {
            return $criteria;
        }
        $query = new ChildCustomerQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildCustomer|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(CustomerTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = CustomerTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildCustomer A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `name`, `email`, `password`, `phone`, `registred`, `lastauth`, `blocked`, `notify_type`, `delete`, `discount`, `inn`, `info_hidden`, `group_id`, `city_id`, `manager_id`, `notify_order`, `notify_news`, `notify_products` FROM `shop_customer` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildCustomer $obj */
            $obj = new ChildCustomer();
            $obj->hydrate($row);
            CustomerTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildCustomer|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildCustomerQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(CustomerTableMap::COL_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildCustomerQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(CustomerTableMap::COL_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildCustomerQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(CustomerTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(CustomerTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CustomerTableMap::COL_ID, $id, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%', Criteria::LIKE); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildCustomerQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CustomerTableMap::COL_NAME, $name, $comparison);
    }

    /**
     * Filter the query on the email column
     *
     * Example usage:
     * <code>
     * $query->filterByEmail('fooValue');   // WHERE email = 'fooValue'
     * $query->filterByEmail('%fooValue%', Criteria::LIKE); // WHERE email LIKE '%fooValue%'
     * </code>
     *
     * @param     string $email The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildCustomerQuery The current query, for fluid interface
     */
    public function filterByEmail($email = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($email)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CustomerTableMap::COL_EMAIL, $email, $comparison);
    }

    /**
     * Filter the query on the password column
     *
     * Example usage:
     * <code>
     * $query->filterByPassword('fooValue');   // WHERE password = 'fooValue'
     * $query->filterByPassword('%fooValue%', Criteria::LIKE); // WHERE password LIKE '%fooValue%'
     * </code>
     *
     * @param     string $password The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildCustomerQuery The current query, for fluid interface
     */
    public function filterByPassword($password = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($password)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CustomerTableMap::COL_PASSWORD, $password, $comparison);
    }

    /**
     * Filter the query on the phone column
     *
     * Example usage:
     * <code>
     * $query->filterByPhone('fooValue');   // WHERE phone = 'fooValue'
     * $query->filterByPhone('%fooValue%', Criteria::LIKE); // WHERE phone LIKE '%fooValue%'
     * </code>
     *
     * @param     string $phone The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildCustomerQuery The current query, for fluid interface
     */
    public function filterByPhone($phone = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($phone)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CustomerTableMap::COL_PHONE, $phone, $comparison);
    }

    /**
     * Filter the query on the registred column
     *
     * Example usage:
     * <code>
     * $query->filterByRegistred('2011-03-14'); // WHERE registred = '2011-03-14'
     * $query->filterByRegistred('now'); // WHERE registred = '2011-03-14'
     * $query->filterByRegistred(array('max' => 'yesterday')); // WHERE registred > '2011-03-13'
     * </code>
     *
     * @param     mixed $registred The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildCustomerQuery The current query, for fluid interface
     */
    public function filterByRegistred($registred = null, $comparison = null)
    {
        if (is_array($registred)) {
            $useMinMax = false;
            if (isset($registred['min'])) {
                $this->addUsingAlias(CustomerTableMap::COL_REGISTRED, $registred['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($registred['max'])) {
                $this->addUsingAlias(CustomerTableMap::COL_REGISTRED, $registred['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CustomerTableMap::COL_REGISTRED, $registred, $comparison);
    }

    /**
     * Filter the query on the lastauth column
     *
     * Example usage:
     * <code>
     * $query->filterByLastauth('2011-03-14'); // WHERE lastauth = '2011-03-14'
     * $query->filterByLastauth('now'); // WHERE lastauth = '2011-03-14'
     * $query->filterByLastauth(array('max' => 'yesterday')); // WHERE lastauth > '2011-03-13'
     * </code>
     *
     * @param     mixed $lastauth The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildCustomerQuery The current query, for fluid interface
     */
    public function filterByLastauth($lastauth = null, $comparison = null)
    {
        if (is_array($lastauth)) {
            $useMinMax = false;
            if (isset($lastauth['min'])) {
                $this->addUsingAlias(CustomerTableMap::COL_LASTAUTH, $lastauth['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($lastauth['max'])) {
                $this->addUsingAlias(CustomerTableMap::COL_LASTAUTH, $lastauth['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CustomerTableMap::COL_LASTAUTH, $lastauth, $comparison);
    }

    /**
     * Filter the query on the blocked column
     *
     * Example usage:
     * <code>
     * $query->filterByBlocked('fooValue');   // WHERE blocked = 'fooValue'
     * $query->filterByBlocked('%fooValue%', Criteria::LIKE); // WHERE blocked LIKE '%fooValue%'
     * </code>
     *
     * @param     string $blocked The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildCustomerQuery The current query, for fluid interface
     */
    public function filterByBlocked($blocked = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($blocked)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CustomerTableMap::COL_BLOCKED, $blocked, $comparison);
    }

    /**
     * Filter the query on the notify_type column
     *
     * Example usage:
     * <code>
     * $query->filterByNotifyType('fooValue');   // WHERE notify_type = 'fooValue'
     * $query->filterByNotifyType('%fooValue%', Criteria::LIKE); // WHERE notify_type LIKE '%fooValue%'
     * </code>
     *
     * @param     string $notifyType The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildCustomerQuery The current query, for fluid interface
     */
    public function filterByNotifyType($notifyType = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($notifyType)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CustomerTableMap::COL_NOTIFY_TYPE, $notifyType, $comparison);
    }

    /**
     * Filter the query on the delete column
     *
     * Example usage:
     * <code>
     * $query->filterByDelete(1234); // WHERE delete = 1234
     * $query->filterByDelete(array(12, 34)); // WHERE delete IN (12, 34)
     * $query->filterByDelete(array('min' => 12)); // WHERE delete > 12
     * </code>
     *
     * @param     mixed $delete The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildCustomerQuery The current query, for fluid interface
     */
    public function filterByDelete($delete = null, $comparison = null)
    {
        if (is_array($delete)) {
            $useMinMax = false;
            if (isset($delete['min'])) {
                $this->addUsingAlias(CustomerTableMap::COL_DELETE, $delete['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($delete['max'])) {
                $this->addUsingAlias(CustomerTableMap::COL_DELETE, $delete['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CustomerTableMap::COL_DELETE, $delete, $comparison);
    }

    /**
     * Filter the query on the discount column
     *
     * Example usage:
     * <code>
     * $query->filterByDiscount(1234); // WHERE discount = 1234
     * $query->filterByDiscount(array(12, 34)); // WHERE discount IN (12, 34)
     * $query->filterByDiscount(array('min' => 12)); // WHERE discount > 12
     * </code>
     *
     * @param     mixed $discount The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildCustomerQuery The current query, for fluid interface
     */
    public function filterByDiscount($discount = null, $comparison = null)
    {
        if (is_array($discount)) {
            $useMinMax = false;
            if (isset($discount['min'])) {
                $this->addUsingAlias(CustomerTableMap::COL_DISCOUNT, $discount['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($discount['max'])) {
                $this->addUsingAlias(CustomerTableMap::COL_DISCOUNT, $discount['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CustomerTableMap::COL_DISCOUNT, $discount, $comparison);
    }

    /**
     * Filter the query on the inn column
     *
     * Example usage:
     * <code>
     * $query->filterByInn('fooValue');   // WHERE inn = 'fooValue'
     * $query->filterByInn('%fooValue%', Criteria::LIKE); // WHERE inn LIKE '%fooValue%'
     * </code>
     *
     * @param     string $inn The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildCustomerQuery The current query, for fluid interface
     */
    public function filterByInn($inn = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($inn)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CustomerTableMap::COL_INN, $inn, $comparison);
    }

    /**
     * Filter the query on the info_hidden column
     *
     * Example usage:
     * <code>
     * $query->filterByInfoHidden('fooValue');   // WHERE info_hidden = 'fooValue'
     * $query->filterByInfoHidden('%fooValue%', Criteria::LIKE); // WHERE info_hidden LIKE '%fooValue%'
     * </code>
     *
     * @param     string $infoHidden The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildCustomerQuery The current query, for fluid interface
     */
    public function filterByInfoHidden($infoHidden = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($infoHidden)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CustomerTableMap::COL_INFO_HIDDEN, $infoHidden, $comparison);
    }

    /**
     * Filter the query on the group_id column
     *
     * Example usage:
     * <code>
     * $query->filterByGroupId(1234); // WHERE group_id = 1234
     * $query->filterByGroupId(array(12, 34)); // WHERE group_id IN (12, 34)
     * $query->filterByGroupId(array('min' => 12)); // WHERE group_id > 12
     * </code>
     *
     * @see       filterByCustomerGroup()
     *
     * @param     mixed $groupId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildCustomerQuery The current query, for fluid interface
     */
    public function filterByGroupId($groupId = null, $comparison = null)
    {
        if (is_array($groupId)) {
            $useMinMax = false;
            if (isset($groupId['min'])) {
                $this->addUsingAlias(CustomerTableMap::COL_GROUP_ID, $groupId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($groupId['max'])) {
                $this->addUsingAlias(CustomerTableMap::COL_GROUP_ID, $groupId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CustomerTableMap::COL_GROUP_ID, $groupId, $comparison);
    }

    /**
     * Filter the query on the city_id column
     *
     * Example usage:
     * <code>
     * $query->filterByCityId(1234); // WHERE city_id = 1234
     * $query->filterByCityId(array(12, 34)); // WHERE city_id IN (12, 34)
     * $query->filterByCityId(array('min' => 12)); // WHERE city_id > 12
     * </code>
     *
     * @see       filterByCustomerCity()
     *
     * @param     mixed $cityId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildCustomerQuery The current query, for fluid interface
     */
    public function filterByCityId($cityId = null, $comparison = null)
    {
        if (is_array($cityId)) {
            $useMinMax = false;
            if (isset($cityId['min'])) {
                $this->addUsingAlias(CustomerTableMap::COL_CITY_ID, $cityId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($cityId['max'])) {
                $this->addUsingAlias(CustomerTableMap::COL_CITY_ID, $cityId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CustomerTableMap::COL_CITY_ID, $cityId, $comparison);
    }

    /**
     * Filter the query on the manager_id column
     *
     * Example usage:
     * <code>
     * $query->filterByManagerId(1234); // WHERE manager_id = 1234
     * $query->filterByManagerId(array(12, 34)); // WHERE manager_id IN (12, 34)
     * $query->filterByManagerId(array('min' => 12)); // WHERE manager_id > 12
     * </code>
     *
     * @see       filterByManager()
     *
     * @param     mixed $managerId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildCustomerQuery The current query, for fluid interface
     */
    public function filterByManagerId($managerId = null, $comparison = null)
    {
        if (is_array($managerId)) {
            $useMinMax = false;
            if (isset($managerId['min'])) {
                $this->addUsingAlias(CustomerTableMap::COL_MANAGER_ID, $managerId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($managerId['max'])) {
                $this->addUsingAlias(CustomerTableMap::COL_MANAGER_ID, $managerId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CustomerTableMap::COL_MANAGER_ID, $managerId, $comparison);
    }

    /**
     * Filter the query on the notify_order column
     *
     * Example usage:
     * <code>
     * $query->filterByNotifyOrder('fooValue');   // WHERE notify_order = 'fooValue'
     * $query->filterByNotifyOrder('%fooValue%', Criteria::LIKE); // WHERE notify_order LIKE '%fooValue%'
     * </code>
     *
     * @param     string $notifyOrder The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildCustomerQuery The current query, for fluid interface
     */
    public function filterByNotifyOrder($notifyOrder = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($notifyOrder)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CustomerTableMap::COL_NOTIFY_ORDER, $notifyOrder, $comparison);
    }

    /**
     * Filter the query on the notify_news column
     *
     * Example usage:
     * <code>
     * $query->filterByNotifyNews('fooValue');   // WHERE notify_news = 'fooValue'
     * $query->filterByNotifyNews('%fooValue%', Criteria::LIKE); // WHERE notify_news LIKE '%fooValue%'
     * </code>
     *
     * @param     string $notifyNews The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildCustomerQuery The current query, for fluid interface
     */
    public function filterByNotifyNews($notifyNews = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($notifyNews)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CustomerTableMap::COL_NOTIFY_NEWS, $notifyNews, $comparison);
    }

    /**
     * Filter the query on the notify_products column
     *
     * Example usage:
     * <code>
     * $query->filterByNotifyProducts('fooValue');   // WHERE notify_products = 'fooValue'
     * $query->filterByNotifyProducts('%fooValue%', Criteria::LIKE); // WHERE notify_products LIKE '%fooValue%'
     * </code>
     *
     * @param     string $notifyProducts The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildCustomerQuery The current query, for fluid interface
     */
    public function filterByNotifyProducts($notifyProducts = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($notifyProducts)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CustomerTableMap::COL_NOTIFY_PRODUCTS, $notifyProducts, $comparison);
    }

    /**
     * Filter the query by a related \Shop\Models\CustomerGroup\CustomerGroup object
     *
     * @param \Shop\Models\CustomerGroup\CustomerGroup|ObjectCollection $customerGroup The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildCustomerQuery The current query, for fluid interface
     */
    public function filterByCustomerGroup($customerGroup, $comparison = null)
    {
        if ($customerGroup instanceof \Shop\Models\CustomerGroup\CustomerGroup) {
            return $this
                ->addUsingAlias(CustomerTableMap::COL_GROUP_ID, $customerGroup->getId(), $comparison);
        } elseif ($customerGroup instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(CustomerTableMap::COL_GROUP_ID, $customerGroup->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByCustomerGroup() only accepts arguments of type \Shop\Models\CustomerGroup\CustomerGroup or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the CustomerGroup relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildCustomerQuery The current query, for fluid interface
     */
    public function joinCustomerGroup($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('CustomerGroup');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'CustomerGroup');
        }

        return $this;
    }

    /**
     * Use the CustomerGroup relation CustomerGroup object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\CustomerGroup\CustomerGroupQuery A secondary query class using the current class as primary query
     */
    public function useCustomerGroupQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinCustomerGroup($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'CustomerGroup', '\Shop\Models\CustomerGroup\CustomerGroupQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\City\City object
     *
     * @param \Shop\Models\City\City|ObjectCollection $city The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildCustomerQuery The current query, for fluid interface
     */
    public function filterByCustomerCity($city, $comparison = null)
    {
        if ($city instanceof \Shop\Models\City\City) {
            return $this
                ->addUsingAlias(CustomerTableMap::COL_CITY_ID, $city->getId(), $comparison);
        } elseif ($city instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(CustomerTableMap::COL_CITY_ID, $city->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByCustomerCity() only accepts arguments of type \Shop\Models\City\City or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the CustomerCity relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildCustomerQuery The current query, for fluid interface
     */
    public function joinCustomerCity($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('CustomerCity');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'CustomerCity');
        }

        return $this;
    }

    /**
     * Use the CustomerCity relation City object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\City\CityQuery A secondary query class using the current class as primary query
     */
    public function useCustomerCityQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinCustomerCity($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'CustomerCity', '\Shop\Models\City\CityQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\Manager\Manager object
     *
     * @param \Shop\Models\Manager\Manager|ObjectCollection $manager The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildCustomerQuery The current query, for fluid interface
     */
    public function filterByManager($manager, $comparison = null)
    {
        if ($manager instanceof \Shop\Models\Manager\Manager) {
            return $this
                ->addUsingAlias(CustomerTableMap::COL_MANAGER_ID, $manager->getId(), $comparison);
        } elseif ($manager instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(CustomerTableMap::COL_MANAGER_ID, $manager->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByManager() only accepts arguments of type \Shop\Models\Manager\Manager or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Manager relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildCustomerQuery The current query, for fluid interface
     */
    public function joinManager($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Manager');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Manager');
        }

        return $this;
    }

    /**
     * Use the Manager relation Manager object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\Manager\ManagerQuery A secondary query class using the current class as primary query
     */
    public function useManagerQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinManager($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Manager', '\Shop\Models\Manager\ManagerQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\SocialLogin\SocialLogin object
     *
     * @param \Shop\Models\SocialLogin\SocialLogin|ObjectCollection $socialLogin the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildCustomerQuery The current query, for fluid interface
     */
    public function filterBySocialLogin($socialLogin, $comparison = null)
    {
        if ($socialLogin instanceof \Shop\Models\SocialLogin\SocialLogin) {
            return $this
                ->addUsingAlias(CustomerTableMap::COL_ID, $socialLogin->getcustomerId(), $comparison);
        } elseif ($socialLogin instanceof ObjectCollection) {
            return $this
                ->useSocialLoginQuery()
                ->filterByPrimaryKeys($socialLogin->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterBySocialLogin() only accepts arguments of type \Shop\Models\SocialLogin\SocialLogin or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the SocialLogin relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildCustomerQuery The current query, for fluid interface
     */
    public function joinSocialLogin($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('SocialLogin');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'SocialLogin');
        }

        return $this;
    }

    /**
     * Use the SocialLogin relation SocialLogin object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\SocialLogin\SocialLoginQuery A secondary query class using the current class as primary query
     */
    public function useSocialLoginQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinSocialLogin($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'SocialLogin', '\Shop\Models\SocialLogin\SocialLoginQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\Basket\Basket object
     *
     * @param \Shop\Models\Basket\Basket|ObjectCollection $basket the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildCustomerQuery The current query, for fluid interface
     */
    public function filterByBasket($basket, $comparison = null)
    {
        if ($basket instanceof \Shop\Models\Basket\Basket) {
            return $this
                ->addUsingAlias(CustomerTableMap::COL_ID, $basket->getcustomerId(), $comparison);
        } elseif ($basket instanceof ObjectCollection) {
            return $this
                ->useBasketQuery()
                ->filterByPrimaryKeys($basket->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByBasket() only accepts arguments of type \Shop\Models\Basket\Basket or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Basket relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildCustomerQuery The current query, for fluid interface
     */
    public function joinBasket($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Basket');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Basket');
        }

        return $this;
    }

    /**
     * Use the Basket relation Basket object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\Basket\BasketQuery A secondary query class using the current class as primary query
     */
    public function useBasketQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinBasket($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Basket', '\Shop\Models\Basket\BasketQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\Order\Order object
     *
     * @param \Shop\Models\Order\Order|ObjectCollection $order the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildCustomerQuery The current query, for fluid interface
     */
    public function filterByOrder($order, $comparison = null)
    {
        if ($order instanceof \Shop\Models\Order\Order) {
            return $this
                ->addUsingAlias(CustomerTableMap::COL_ID, $order->getCustomerId(), $comparison);
        } elseif ($order instanceof ObjectCollection) {
            return $this
                ->useOrderQuery()
                ->filterByPrimaryKeys($order->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByOrder() only accepts arguments of type \Shop\Models\Order\Order or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Order relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildCustomerQuery The current query, for fluid interface
     */
    public function joinOrder($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Order');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Order');
        }

        return $this;
    }

    /**
     * Use the Order relation Order object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\Order\OrderQuery A secondary query class using the current class as primary query
     */
    public function useOrderQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinOrder($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Order', '\Shop\Models\Order\OrderQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\FastLink\FastLink object
     *
     * @param \Shop\Models\FastLink\FastLink|ObjectCollection $fastLink the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildCustomerQuery The current query, for fluid interface
     */
    public function filterByFastLinkRelatedByOwnerCustomerId($fastLink, $comparison = null)
    {
        if ($fastLink instanceof \Shop\Models\FastLink\FastLink) {
            return $this
                ->addUsingAlias(CustomerTableMap::COL_ID, $fastLink->getOwnerCustomerId(), $comparison);
        } elseif ($fastLink instanceof ObjectCollection) {
            return $this
                ->useFastLinkRelatedByOwnerCustomerIdQuery()
                ->filterByPrimaryKeys($fastLink->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByFastLinkRelatedByOwnerCustomerId() only accepts arguments of type \Shop\Models\FastLink\FastLink or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the FastLinkRelatedByOwnerCustomerId relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildCustomerQuery The current query, for fluid interface
     */
    public function joinFastLinkRelatedByOwnerCustomerId($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('FastLinkRelatedByOwnerCustomerId');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'FastLinkRelatedByOwnerCustomerId');
        }

        return $this;
    }

    /**
     * Use the FastLinkRelatedByOwnerCustomerId relation FastLink object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\FastLink\FastLinkQuery A secondary query class using the current class as primary query
     */
    public function useFastLinkRelatedByOwnerCustomerIdQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinFastLinkRelatedByOwnerCustomerId($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'FastLinkRelatedByOwnerCustomerId', '\Shop\Models\FastLink\FastLinkQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\FastLink\FastLink object
     *
     * @param \Shop\Models\FastLink\FastLink|ObjectCollection $fastLink the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildCustomerQuery The current query, for fluid interface
     */
    public function filterByFastLinkRelatedByCode($fastLink, $comparison = null)
    {
        if ($fastLink instanceof \Shop\Models\FastLink\FastLink) {
            return $this
                ->addUsingAlias(CustomerTableMap::COL_PASSWORD, $fastLink->getCode(), $comparison);
        } elseif ($fastLink instanceof ObjectCollection) {
            return $this
                ->useFastLinkRelatedByCodeQuery()
                ->filterByPrimaryKeys($fastLink->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByFastLinkRelatedByCode() only accepts arguments of type \Shop\Models\FastLink\FastLink or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the FastLinkRelatedByCode relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildCustomerQuery The current query, for fluid interface
     */
    public function joinFastLinkRelatedByCode($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('FastLinkRelatedByCode');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'FastLinkRelatedByCode');
        }

        return $this;
    }

    /**
     * Use the FastLinkRelatedByCode relation FastLink object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\FastLink\FastLinkQuery A secondary query class using the current class as primary query
     */
    public function useFastLinkRelatedByCodeQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinFastLinkRelatedByCode($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'FastLinkRelatedByCode', '\Shop\Models\FastLink\FastLinkQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ChildCustomer $customer Object to remove from the list of results
     *
     * @return $this|ChildCustomerQuery The current query, for fluid interface
     */
    public function prune($customer = null)
    {
        if ($customer) {
            $this->addUsingAlias(CustomerTableMap::COL_ID, $customer->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the shop_customer table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(CustomerTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            CustomerTableMap::clearInstancePool();
            CustomerTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(CustomerTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(CustomerTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            CustomerTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            CustomerTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

} // CustomerQuery
