<?

namespace Shop\Config;

/**
 * Конфиг магазина
 *
 * @author Admin
 */
class Main extends \Core\IniConfig
{

    protected $default_customer_category = 1; //for new registrated client
    protected $defaultGuestGroup = 1; //for guest from fast links
    protected $googleMapApiKey = "AIzaSyBZOrWKLNr0GRuMzVOOhh2g3DniojU-gcg"; //api key
    protected $daysNewGoods = 230; //new products days
    protected $curencyDisplay = "руб"; //currency full
    protected $curencyDisplayShort = "р."; //currency short
    protected $defaultCity = 1339; //def city
    protected $defaultRegion; //def region
    protected $managerEmail = "manager@mail.ru";
    protected $stateDefault = 1; //state new order
    protected $statePayment = 1; //state payment order
    protected $mobileMask = "(+7) 999-999-9999"; //phone mask
    protected $fakePersent; //fake persent
    protected $minOrderSumm; //min summ for order
    protected $russianPostUrl; //link for see post state
    protected $imagesServer = "https://img.komod43.ru"; //image server
    protected $paginationRows = [15, 30, 60, 120]; //pagination rows
    protected $thumbPath = '/image/product/resize/'; //путь к миниэскизам на сервере изображений
    protected $stockImagePath = "/assets/upload/shops/"; //каталог сайта для изображений точек
    protected $customersBlockedInterval = 360;//customer limit for blocked

    function getCustomersBlockedInterval()
    {
        return $this->customersBlockedInterval;
    }

    function getStockImagePath()
    {
        return $this->stockImagePath;
    }

    function getThumbPath()
    {
        return $this->thumbPath;
    }

    function getPaginationRows()
    {
        return $this->paginationRows;
    }

    function getDefaultRegion()
    {
        return $this->defaultRegion;
    }

    function getStatePayment()
    {
        return $this->statePayment;
    }

    function getImages_server()
    {
        return $this->getImagesServer();
    }

    function getImagesServer()
    {
        return $this->imagesServer;
    }

    function getRussianPostUrl()
    {
        return $this->russianPostUrl;
    }

    function getMinOrderSumm()
    {
        return $this->minOrderSumm;
    }

    function getFakePersent()
    {
        return $this->fakePersent;
    }

    function getDefaultGuestGroup()
    {
        return $this->defaultGuestGroup;
    }

    function getMobileMask()
    {
        return $this->mobileMask;
    }

    public function getStateDefault()
    {
        return $this->stateDefault;
    }

    public function getManagerEmail()
    {
        return $this->managerEmail;
    }

    public function getDefaultCity()
    {
        return $this->defaultCity;
    }

    /**
     * Кол-во дней в течении которых товар считается новинкой
     * @return type
     */
    public function getDaysNewGoods(): int
    {
        return (int) $this->daysNewGoods;
    }

    /**
     * Ключ апи карты
     * @return string
     */
    public function getGoogleMapApiKey(): string
    {
        return $this->googleMapApiKey;
    }

    //put your code here
    protected function getFileName()
    {
        return 'shop.main.ini';
    }

    public function getDefault_customer_category()
    {
        return $this->default_customer_category;
    }

    public function getCurencyDisplay()
    {
        return $this->curencyDisplay;
    }

    public function getCurencyDisplayShort()
    {
        return $this->curencyDisplayShort;
    }

}