<?

namespace Shop\Services;

/**
 * Класс работы с уведомлениями
 *
 * @author Admin
 */
class Notify extends \Diamond\Services\Notify
{

    protected $confSms;
    protected $smsLogRepo;

    public function __construct(\Diamond\Config\Mail $mailConfig, 
            \Nette\Mail\SendmailMailer $mailer, 
            \Shop\Config\Sms $confSms, \Shop\Repositories\SmsLog $smsLogRepo
            )
    {
        parent::__construct($mailConfig, $mailer);
        $this->confSms = $confSms;
        $this->smsLogRepo = $smsLogRepo;
    }

    /**
     * Отправка сообщения на смс
     * @param type $phone
     * @param \Diamond\DTO\Message $message
     */
    public function sendToSms($phone, \Diamond\DTO\Message $message):int
    {
        
        if($this->confSms->getDebug()=="sendToSmsDISSABLED"){
            return 0;
        }
        
        if($this->confSms->getDebug()=="DEBUG_PHONE" && $this->confSms->getDebugPhone()>""){
            $phone = $this->confSms->getDebugPhone();
        }
        elseif($this->confSms->getDebug()=="DEBUG_PHONE"){
            throw new \Shop\Exceptions\NotifySendError("Номер для отладки смс сообщений не задан.");
        }
        
        if($this->confSms->getDebug()=="DEBUG_DISPLAY"){
            throw new \Shop\Exceptions\NotifySend('Отправка смс на номер ' . $phone . ' Текст: ' . $message->getContent() );
        }
        
        if(!$this->confSms->getLogin() || !$this->confSms->getPassword() ){
            throw new \Shop\Exceptions\NotifySendError("Логин или пароль от сервиса смс сообщений не заданны.");
        }
        
        $config = new \SmsSender\Drivers\Smsc\Config;
        $config
                ->setLogin($this->confSms->getLogin())
                ->setPassword($this->confSms->getPassword())
                ->setFrom($this->confSms->getFrom())
                ;
        
        $smsSender = new \SmsSender\Sender(new \SmsSender\Drivers\Smsc\Smsc($config));
        
        try{
            
            $result = $smsSender->send($phone, $message->getContent() );
            
            $this->smsLogRepo
                    ->buildEntity()
                    ->setPhone($phone)
                    ->setStatus($result->getMessage())
                    ->setContent($message->getContent())
                    ->save()
                    ;
        } catch (\Exception $ex) {
            $smsLog = $this->smsLogRepo
                    ->buildEntity()
                    ->setPhone($phone)
                    ->setStatus($ex->getMessage())
                    ->setContent($message->getContent())
                    ->save();
            
            throw $ex;
        }
        
        return $result->getId();
    }

}