<?

namespace Shop\Services;

/**
 * Description of ComplexRate
 *
 * @author Admin
 */
class ComplexRate
{
    
    protected $customerService;
            
    function __construct(Customer $customerService)
    {
        $this->customerService = $customerService;
    }

    /**
     * 
     */
    public function getComplexRate($brandId): float
    {

        if(!$customer = $this->customerService->getCurrentCustomer()){
            $customerId = "%";
            $customerGroupId = "%";
        }
        else{
            $customerId = $customer->getId();
            $customerGroupId = $customer->getCustomerGroup()->getId();            
        }

        
        $shopId = $this->customerService->getCurrentShopId();
        
        $complex =
        \Shop\Models\ComplexRate\ComplexRateQuery::create()
                ->add("##brand_id", sprintf("'%s' LIKE `brand_id`", $brandId) , \Propel\Runtime\ActiveQuery\Criteria::CUSTOM)
                ->add("##shop_id", sprintf("'%s' LIKE `shop_id`", $shopId) , \Propel\Runtime\ActiveQuery\Criteria::CUSTOM)
                ->add("##customer_id", sprintf("'%s' LIKE `customer_id`", $customerId) , \Propel\Runtime\ActiveQuery\Criteria::CUSTOM)
                ->add("##customer_group_id", sprintf("'%s' LIKE `customer_group_id`", $customerGroupId) , \Propel\Runtime\ActiveQuery\Criteria::CUSTOM)
                ->orderByPriority(\Propel\Runtime\ActiveQuery\Criteria::DESC)
                ->findOne()
                ;
        
        if(!$complex){
            return (float)0;
        }
        
        return (float)$complex->getRate();
    }
}