<?

namespace Shop\Repositories;

use Core\Repository\CrudInterface;
use Core\Repository\PropelQueryAbstract;
use Propel\Runtime\Collection\ObjectCollection;
use Shop\Models\Shop\Shop as ShopEntity;
use Shop\Models\Shop\ShopQuery;


/**
 * Description of Shop
 *
 * @author Admin
 */
class Shop extends PropelQueryAbstract implements CrudInterface, \Core\Repository\DropdownInreface{

    public function buildQuery(){
	return ShopQuery ::create();
    }

    public function buildEntity(){
	return new ShopEntity;
    }
    
    /**
     * Получение главного магазина
     * @return ObjectCollection
     */
    public function findOneMain(){
        return $this->buildQuery()
                ->findOneByType("main");
    }
    
    /**
     * Получение дилеров
     * @return ObjectCollection
     */
    public function findDealers(): ObjectCollection {
        return $this->buildQuery()
                ->findByType("dealer");
    }
    
    /**
     * 
     * @param type $id
     * @return ObjectCollection
     */
    public function findStocksByMainId($id): ObjectCollection {
        return $this->buildQuery()
                ->filterByType("stock")
                ->filterByParentId($id)
                //->useParentShopQuery()
                 //   ->filterByType("main")
                //->endUse()
                ->find();
    }
    
    /**
     * 
     * @return array
     */
    public function getDropdownList():array
    {
        return $this->buildQuery()
		->orderByTitle()
		->find()
		->toKeyValue('id','title');
    }

}
