<?

namespace Shop\Modules\AdminStates;

use Core\Registry\Column;
use Core\Registry\Field;

/**
 * Description of AdminStates
 *
 * @author Diamond Code Generator
 */
class AdminStates extends \Core\ModuleController
{

    protected $stateRepo;
    protected $tableFactory;
    protected $cBuilder;

    function __construct(\Diamond\Factory\Table $tableFactory, \Core\Form\ControlBuilder $cBuilder,
                         \Shop\Repositories\State $stateRepo)
    {
        $this->tableFactory = $tableFactory;
        $this->stateRepo = $stateRepo;
        $this->cBuilder = $cBuilder;
    }

    public function process()
    {

        $table = $this->tableFactory->buildAdminTable("states", $this->stateRepo);

        $table
                ->addColumn(new Column("id", "№", 20, false, true))
                ->addColumn((new Column("title", "Наименование", 400))->setFn([$this, "formatColorState"]))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildInput("title"), null, "required"
                ))
                 ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildColorPicker("color"), "Цветовой код"
                ))
        ;

        return $table->render();
    }

    public function formatColorState(\Shop\Models\State\State $state)
    {
        return \Shop\Helpers\State::formatColor($state);
    }

}