<?

namespace Shop\Modules\AdminShops;

use Core\Registry\Column;
use Core\Registry\Field;

/**
 * Description of AdminShops
 * @todo передаелать на деревягу jqgrid
 * @author Diamond Code Generator
 */
class AdminShops extends \Core\ModuleController
{

    protected $repo;
    protected $tableFactory;
    protected $cBuilder;
    protected $mainConf;
    protected $shopService;
    protected $regionRepo;
    protected $cityRepo;
    protected $addressRepo;
            
    function __construct(
            \Diamond\Factory\Table $tableFactory, 
            \Core\Form\ControlBuilder $cBuilder, 
            \Shop\Repositories\Shop $repo,
            \Shop\Config\Main $mainConf, 
            \Shop\Services\Shop $shopService,
            \Shop\Repositories\Region $regionRepo,
            \Shop\Repositories\City $cityRepo,
            \Shop\Repositories\Address $addressRepo
    )
    {
        $this->tableFactory = $tableFactory;
        $this->repo = $repo;
        $this->cBuilder = $cBuilder;
        $this->mainConf = $mainConf;
        $this->shopService = $shopService;
        $this->regionRepo = $regionRepo;
        $this->cityRepo = $cityRepo;
        $this->addressRepo = $addressRepo;
    }

    public function process()
    {

        $table = $this->tableFactory->buildAdminTable("shops", $this->repo);
        $table->getForm()->addValidationPrepareEvent([$this, "saveAddress"]);
        

        
        //----------------------------------
        if(input_get("id") > 0){
            $address = $this->repo->findById(input_get("id"))->getAddress();
        }
        
        //----------------------------------
        $regionId = $cityId = null;
        if (isset( $address) && !input_post("regionId") ){
            $regionId = $address->getCity()->getRegionId();
            $cityId = $address->getCityId();
            $cities = $this->cityRepo->getDropdownListByregion(
                    $regionId
                    );
            
        }
        elseif ( ! $regionId = input_post("regionId")) {
            $cities = [null => 'город не выбран'];
        } else {
            $cities = $this->cityRepo->getDropdownListByregion($regionId);
        }        
        $regions = $this->regionRepo->getDropdownList();        
        
        
        $table
                ->addColumn(new Column("id", "№", 20, false, true))
                ->addColumn(new Column("title", "Название точки", 120))
                ->addColumn((new Column("phones", "Контактные телефоны", 120))->setFn([$this, "formatContact"]))
                ->addColumn((new Column("address", "Адрес расположения", 140))->setFn([$this, "formatAddress"]))
                ->addColumn((new Column("type", "Тип точки", 120))->setFn([$this, "formatParent"]))
        ;

        $imgUpload = $this->cBuilder
                        ->buildImgUpload("image", $this->mainConf->getStockImagePath(), true)
                        ->setPreviewImage(true)        
                        ->setPreviewImageSize(100);
        
        $stocks = \Diamond\Helpers\Form::prepareDropdown($this->repo);
        
        $table
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildInput("title"), null, "required"
                ))
                ->addField(new Field(
                        $this->cBuilder
                        ->buildDropdownUniform("type",
                           $this->shopService->getShopTypes()
                        ), null, "required"
                ))
                ->addField(new Field(
                        $this->cBuilder
                        ->buildDropdownUniform("parent_id",
                           $stocks
                        ), "Принадлежность",[],"Принадлежность к ГО или дилеру"
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildTextArea("director_contact"), "Контакты директора/компании"
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildTextArea("phones"), null
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildTextArea("emails"), "Электронные адреса для писем", NULL, "разделитель ;"
                ))
                //address
                ->addHeader("Адрес расположения")
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildHidden("address_id")
                ))
                 ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildInputLittle("post_code")->setValue(!isset($address)?null:$address->getPostCode()), "Почтовый индекс"
                ))
                ->addField(
                        new Field(
                        $this->cBuilder->buildDropdownUniform('regionId', $regions)->setValue($regionId)
                        ->onChange("select_city(this,'cityId')")
                        ->setId("regionId"), "Регион")
                )
                ->addField(
                        new Field(
                        $this->cBuilder->buildDropdownUniform('cityId', $cities)->setValue($cityId)
                        ->setId("cityId"), "Город","required")
                )
                 ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildInput("street")->setValue(!isset($address)?null:$address->getStreet()), "Улица"
                ))
                 ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildInputSmall("house")->setValue(!isset($address)?null:$address->getHouse()), "Дом"
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildInputSmall("room")->setValue(!isset($address)?null:$address->getRoom()), "Квартира"
                ))
                 ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildInputSmall("mapLng")->setValue(!isset($address)?null:$address->getMapLng()), "Координата по долготе",null,"Для карт google,yandex"
                ))
                 ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildInputSmall("mapLat")->setValue(!isset($address)?null:$address->getmapLat()), "Координата по широте",null,"Для карт google,yandex"
                ))
                ->addHeader("Изображения и описание")
                //address -> end
                ->addField(
                        new Field($imgUpload,"Изображение офиса"
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildImgUpload("logo", $this->mainConf->getStockImagePath(), true)
                        ->setPreviewImage(true)        
                        ->setPreviewImageSize(100)        
                                ,"Логотип офиса"
                ))                
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildTextEditor("desc")
                        ->setHeight(200)
                        ->setCompact(true), 'Описание', NULL
                ))
        ;

        if ($file = $imgUpload->UploadImage()) {
            $table->getForm()->addCustomMessage(sprintf("Изображение %s успешно сохранено",
                    $file));
        } elseif ($imgUpload->deleteImage()) {
            $table->getForm()->addCustomMessage("Изображение успешно удалено");
        }        

        return $table->render();
    }
    
    /**
     * 
     * @param array $data
     * @param \Core\Form\Simpleform $form
     * @return boolean
     */
    public function saveAddress(array $data, \Core\Form\Simpleform $form){
        
        if(!$data["cityId"]){
            
            $form->addCustomMessage("Город не указан","msgalert");
            
            return false;
        }
        
        if($data["address_id"] > 0){
            $address = $this->addressRepo->findById($data["address_id"]);
        }
        else{
            $address = $this->addressRepo->buildEntity();
        }
        
        $address
                ->setCityId($data["cityId"])
                ->setPostCode($data["post_code"])
                ->setStreet($data["street"])
                ->setHouse($data["house"])
                ->setRoom($data["room"])
                ->setMapLat($data["mapLat"])
                ->setMapLng($data["mapLng"])
                ;
        
        
        
        if($address->save()){
            
            $data["address_id"] =  $address->getId();
            
            return $data;
        }
        
        return $data;
    }

    /**
     * 
     * @param \Shop\Models\Shop\Shop $shop
     * @return type
     */
    public function formatContact(\Shop\Models\Shop\Shop $shop)
    {
        return \Shop\Helpers\Text::clearText($shop->getPhones(), 130);
    }

    /**
     * 
     * @param \Shop\Models\Customer\Customer $customer
     * @return type
     */
    public function formatAddress(\Shop\Models\Shop\Shop $shop)
    {
        return $shop->getFullAddress();
    }

    /**
     * 
     * @param \Shop\Models\Shop\Shop $shop
     * @return type
     */
    public function formatParent(\Shop\Models\Shop\Shop $shop)
    {
        return \Shop\Helpers\Shop::getShopType($shop);
    }

}