<?

namespace Shop\Modules\AdminSettingsMain;

use Core\Form\ControlBuilder;
use Core\Form\FormBuilder;
use Shop\Config\Main;

/**
* Description of AdminConfigMain
*
* @author Diamond Code Generator
*/
class AdminSettingsMain extends \Core\ModuleController{

    protected $formBuilder;
    protected $controlBuilder;
    protected $conf;
    protected $cGroupRepo;
    protected $stateRepo;
    protected $cityRepo;
    protected $regionRepo;
            
    function __construct(FormBuilder $form, ControlBuilder $controlBuilder, Main $conf, 
            \Shop\Repositories\CustomerGroup $cGroupRepo,
            \Shop\Repositories\State $stateRepo,
            \Shop\Repositories\City $cityRepo,
            \Shop\Repositories\Region $regionRepo
            ) {
        $this->formBuilder = $form;
        $this->controlBuilder = $controlBuilder;
        $this->conf = $conf;
        $this->cGroupRepo = $cGroupRepo;
        $this->stateRepo = $stateRepo;
        $this->cityRepo = $cityRepo;
        $this->regionRepo = $regionRepo;
    }    
    
    protected function buildForm(): \Core\Form\SettingsForm
    {
        $form = $this->formBuilder->buildSettingsForm($this->conf, "main");
        $builder = $this->controlBuilder;
        $customerGroups = \Shop\Helpers\Form::prepareDropdown($this->cGroupRepo);
        $states = \Shop\Helpers\Form::prepareDropdown($this->stateRepo);
        
        $regions = $this->regionRepo->getDropdownList();
        $regionId = null;
        $cityId = $this->conf->getDefaultCity();
        
        if (!input_post("defaultRegion") && $cityId ){
            
            $city = $this->cityRepo->findById($cityId);
            $regionId = $city->getRegionId();
            $cities = $this->cityRepo->getDropdownListByregion($regionId);
            
        }
        elseif ( ! $regionId = input_post("defaultRegion")) {
            $cities = [null => 'город не выбран'];
        } else {
            $cities = $this->cityRepo->getDropdownListByregion($regionId);
        }        
        $paginationRows
                = [15=>15, 30=>30, 60=>60, 120=>120];
        $form
                
                ->addHeader("Валюта")
                ->addField(
                        $builder->buildInputLittle("curencyDisplay"), 'Наименование валюты',"required","Например руб."
                )
                ->addField(
                        $builder->buildInputLittle("curencyDisplayShort"), 'Краткое наименование валюты',"required","Например р."
                )                
                ->addHeader("Движение позиций и заказ")
                ->addField(
                        $builder->buildInputLittle("fakePersent"), 'Фиктивная наценка, %', [], 'для акционных товаров'
                )
                ->addField(
                        $builder->buildInputLittle("minOrderSumm"), 'Минимальная сумма заказа, руб.'
                )   

                ->addField(
                        $builder->buildInputLittle("daysNewGoods"), 'Срок жизни нового товара, дней',null,"Товар помечается как новинка"
                )
                ->addField(
                        $builder->buildDropdownUniform("stateDefault",$states), "Состояние по умолчанию", "required",
                        "Для новых заказов"
                )             
                ->addField(
                        $builder->buildDropdownUniform("statePayment",$states), "Состояние для оплаченных заказов", null,
                                                  "Используется при успешной онлайн оплате"
                )    
                

                
                            
                ->addHeader("Изображения")
                ->addField(
                        $builder->buildInputSmall("imagesServer"), "Сервер изображений", null,
                                                  "По умолчанию будет использоваться текущий"
                )
                
                ->addField(
                        $builder->buildInputSmall("thumbPath"), "Url путь к миниэскизам",null,
                                                  "Относительно сервера изображений"
                )
                ->addField(
                        $builder->buildInputSmall("stockImagePath"), "Путь к каталогу изображений для торг.точек"
                )
                ->addHeader("Интеграция с сервисами")
                
                ->addField(
                        $builder->buildInputSmall("googleMapApiKey"), "Google Map Api key"
                )
                ->addField(
                        $builder->buildInputSmall("russianPostUrl"), "Адрес сайта Почта России", null,
                                                  "Для отслеживания почтовых отправлений"
                )
                ->addHeader("Регистрация и клиенты")
                ->addField(
                        $builder->buildInputLittle("customersBlockedInterval"),"Интервал блокировки пользователей, дней"
                        )
                ->addField(
                        $builder->buildDropdownUniform("default_customer_category",$customerGroups), "Группа клиентов по умолчанию", "required",
                        "Для зарегистрированных клиентов"
                )
                ->addField(
                        $builder->buildDropdownUniform("defaultGuestGroup",$customerGroups), "Группа для гостей сайта", "required",
                        "Для клиентов с исполь.-ем быстрых ссылок"
                )
                ->addField(
                        $builder->buildDropdownUniform("defaultRegion",$regions)
                        ->onChange("select_city(this,'defaultCity')")
                        ->setValue($regionId)
                        ->setId("region_id")
                        , "Регион по умолчанию", null,
                                                  "Для скрытой регистрации из соц.сетей"
                )                 
                ->addField(
                        $builder->buildDropdownUniform("defaultCity",$cities)
                        ->setValue($cityId)
                        ->setId("defaultCity")
                        , "Город по умолчанию", null,
                                                  "Для скрытой регистрации из соц.сетей"
                )  
                ->addHeader("Внешний вид и прочее")
                ->addField(
                        $builder->buildAutoDropdownMulti("paginationRows",$paginationRows), "Кол-во товаров для вывода в каталоге"
                        )  
                ->addField(
                        $builder->buildInputSmall("mobileMask"), "Маска для сотового телефона", "required",
                                                  "используется в формах регистрации, заказа"
                )
                
                

        ;

        return $form;        
    }
    
    public function process() {
        
        $form = $this->buildForm();

        return $form->render();
    }

}               