<?

namespace Shop\Modules\AdminRegions;

use Core\Registry\Column;
use Core\Registry\Field;

/**
 * Description of AdminRegions
 *
 * @author Diamond Code Generator
 */
class AdminRegions extends \Core\ModuleController
{

    protected $repo;
    protected $tableFactory;
    protected $cBuilder;
    protected $countryRepo;

    function __construct(\Diamond\Factory\Table $tableFactory, \Core\Form\ControlBuilder $cBuilder,
                         \Shop\Repositories\Region $repo,
                         \Shop\Repositories\Country $countryRepo)
    {
        $this->tableFactory = $tableFactory;
        $this->repo = $repo;
        $this->cBuilder = $cBuilder;
        $this->countryRepo = $countryRepo;
    }

    public function process()
    {

        $table = $this->tableFactory->buildAdminTable("regions", $this->repo);

        $table
                ->addColumn(new Column("id", "№", 20, false, true))
                ->addColumn(new Column("name", "Название", 120))
                ->addColumn((new Column("country_id", "Страна", 300))->setFn($this, "formatCountry"))
        ;

        $table
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildInput("name"), null, "required"
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildDropdownUniform("country_id", \Shop\Helpers\Form::prepareDropdown($this->countryRepo)), null, "required"
                ))

        ;

        return $table->render();
    }

    /**
     * 
     * @param \Shop\Models\Region\Region $region
     * @return type
     */
    public function formatCountry(\Shop\Models\Region\Region $region)
    {
        return $region->getRegionCountry()->getName();
    }

}