<?php

namespace Shop\Modules\AdminProducts;

use Core\Form\Control;
use Core\Form\ControlBuilder;
use Core\ModuleController;
use Shop\Models\Product\Product as Product2;
use Shop\Repositories\Brand;
use Shop\Repositories\Category;
use Shop\Repositories\Product;
use Core\Registry\Column;
use Core\Registry\Field;

/**
 * Description of AdminProducts
 *
 * @author Dmitriy
 */
class AdminProducts extends ModuleController
{

    protected $productRepo;
    protected $repoCategory;
    protected $brandRepo;
    protected $cBuilder;
    protected $tableFactory;

    function __construct(Product $product, Category $repoCategory, Brand $brandRepo, ControlBuilder $controlBuilder,
                         \Diamond\Factory\Table $tableFactory)
    {

        $this->productRepo = $product;
        $this->repoCategory = $repoCategory;
        $this->brandRepo = $brandRepo;
        $this->cBuilder = $controlBuilder;

        $this->tableFactory = $tableFactory;
    }

    public function process()
    {

        $registry = $this->tableFactory->buildAdminTable("products", $this->productRepo);

        $registry->setColumns([
            new Column("id", "№", 20, false, true),
            new Column("title", "Наименование", 70),
            new Column("short_desc", "Краткое описание", 110),
            new Column("price", "Цена", 50),
            (new Column("category", "Раздел", 50))->setFn(function(Product2 $product) {
                        return $product->getCategory()->getTitle();
                    }),
            (new Column("brand", "Производитель", 50))->setFn(function(Product2 $product) {
                        return $product->getBrand()->getName();
                    }),
            new Column("img", "Изображение", 70),
            new Column("active", "Опубликован", 40),
            new Column("special", "Акционный", 40),
        ]);

        $categories = \Shop\Helpers\Form::prepareDropdown($this->repoCategory,"раздел","getDropdownListWithParent");

        $brands = \Shop\Helpers\Form::prepareDropdown($this->brandRepo);

        $optionsYN = [
            "Y" => "Да",
            "N" => "Нет"];

        $imgUpload = $this->cBuilder
                ->buildImgUpload("img", "/upload/products/", true)->setPreviewImage(true);

        $registry->addField(
                        new Field(
                        $this->cBuilder
                        ->buildInput("title"), 'Наименование', "required"
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildTextArea("short_desc"), 'Краткое описание', "required"
                ))
                ->addField(
                        new Field($this->cBuilder->buildDropdownUniform("category_id", $categories),
                                                                              "Раздел каталога"))
                ->addField(
                        new Field($this->cBuilder->buildDropdownUniform("brand_id", $brands), "Производитель"))
                ->addField(
                        new Field($this->cBuilder->buildInputTiny("price"), 'Цена', "required"))
                ->addField(
                        new Field($this->cBuilder->buildDropdownUniform("active", $optionsYN), 'Опубликован',
                                                                              "required"))
                ->addField(
                        new Field($this->cBuilder->buildDropdownUniform("special", $optionsYN),
                                                                              'Специальное предложение', "required",
                                                                              "будет отображен в соответсвующем блоке"))
                ->addField(
                        new Field($this->cBuilder->buildInputTiny("min_quality"), 'Вес', null
                        , "например 50г."))
                ->addField(
                        new Field($this->cBuilder
                        ->buildTextEditor("desc")
                        ->setHeight(200)
                        ->setCompact(true), 'Описание'))
                ->addField(
                        new Field($imgUpload, "Изображение товара"))
        ;



        if ($file = $imgUpload->UploadImage()) {
            $registry->getForm()->addCustomMessage(sprintf("Изображение %s успешно сохранено", $file));
        } elseif ($imgUpload->deleteImage()) {
            $registry->getForm()->addCustomMessage("Изображение успешно удалено");
        }

        return $registry->render();
    }

}