<?

namespace Shop\Modules\AdminPositions;

use Core\Registry\Column;
use Core\Registry\Field;

/**
* Description of AdminPositions
*
* @author Diamond Code Generator
*/
class AdminPositions extends \Core\ModuleController{

    protected $repo;
    protected $tableFactory;
    protected $cBuilder;
    protected $mainConf;
            
    function __construct(
            \Diamond\Factory\Table $tableFactory, 
            \Core\Form\ControlBuilder $cBuilder, 
            \Shop\Repositories\Position $repo,
            \Shop\Config\Main $mainConf
    )
    {
        $this->tableFactory = $tableFactory;
        $this->repo = $repo;
        $this->cBuilder = $cBuilder;
        $this->mainConf = $mainConf;
    }    
    
    public function process() {
        
        $table = $this->tableFactory->buildAdminTable("positions", $this->repo);
        
        $table
                ->addColumn(new Column("id", "№", 20, false, true))
                ->addColumn(new Column("desc", "Описание", 120))
                ->addColumn(new Column("remain", "Наличие", 60))
                ->addColumn(new Column("price", "Цена поставщика", 60))
                ->addColumn(new Column("old_price", "Старая цена", 60))
                ->addColumn((new Column("sale_id", "Тип скидки", 60))->setFn([$this, "formatSale"]))
                ->addColumn((new Column("product_id", "Товар", 80))->setFn([$this, "formatProduct"]))
                ->addColumn(new Column("image", "Изображение", 60))
                ->addColumn((new Column("shop_id", "Офис/т.точка", 140))->setFn([$this, "formatShop"]))
//                ->addColumn((new Column("type", "Тип точки", 120))->setFn([$this, "formatParent"]))
        ;
        
        return $table->render();
    }
    
    /**
     * 
     * @param \Shop\Models\Position\Position $position
     * @return string
     */
    public function formatProduct(\Shop\Models\Position\Position $position)
    {
        return $position->getProduct()->getTitle();
    }
    
    /**
     * 
     * @param \Shop\Models\Position\Position $position
     * @return string
     */
    public function formatShop(\Shop\Models\Position\Position $position)
    {
        return $position->getShop()->getTitleWithType();
    }    
    /**
     * 
     * @param \Shop\Models\Position\Position $position
     * @return string
     */
    public function formatSale(\Shop\Models\Position\Position $position)
    {
        return $position->getSaleId();
    } 
}               