<?

namespace Shop\Modules\AdminClientGroups;

use Core\Registry\Column;
use Core\Registry\Field;

/**
 * Description of AdminClientGroups
 *
 * @author Diamond Code Generator
 */
class AdminClientGroups extends \Core\ModuleController
{

    protected $groupRepo;
    protected $tableFactory;
    protected $cBuilder;

    function __construct(\Diamond\Factory\Table $tableFactory, \Core\Form\ControlBuilder $cBuilder,
                         \Shop\Repositories\CustomerGroup $groupRepo)
    {
        $this->tableFactory = $tableFactory;
        $this->groupRepo = $groupRepo;
        $this->cBuilder = $cBuilder;
    }

    public function process()
    {
        $table = $this->tableFactory->buildAdminTable("groups", $this->groupRepo);

        $table
                ->addColumn(new Column("id", "№", 20, false, true))
                ->addColumn(new Column("name", "Наименование", 170))
                ->addColumn((new Column("desc", "Описание", 400))
                        ->setFn(function(\Shop\Models\CustomerGroup\CustomerGroup $group) {
                            return \Shop\Helpers\Text::clearText($group->getDesc());
                        }))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildInput("name"), null, "required"
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildTextEditor("desc")
                        ->setHeight(200)
                        ->setCompact(true), 'Описание'
                ))
        ;

        return $table->render();
    }

}