<?

namespace Shop\Modules\AdminCities;

use Core\Registry\Column;
use Core\Registry\Field;

/**
 * Description of AdminCities
 *
 * @author Diamond Code Generator
 */
class AdminCities extends \Core\ModuleController
{

    protected $repo;
    protected $tableFactory;
    protected $cBuilder;
    protected $countryRepo;
    protected $cityRepo;

    function __construct(\Diamond\Factory\Table $tableFactory, \Core\Form\ControlBuilder $cBuilder,
                         \Shop\Repositories\Region $repo, \Shop\Repositories\Country $countryRepo,
                         \Shop\Repositories\City $cityRepo)
    {
        $this->tableFactory = $tableFactory;
        $this->repo = $repo;
        $this->cBuilder = $cBuilder;
        $this->countryRepo = $countryRepo;
        $this->cityRepo = $cityRepo;
    }

    public function process()
    {
        $table = $this->tableFactory->buildAdminTable("cities", $this->cityRepo);
        
        $table
                ->addColumn(new Column("id", "№", 20, false, true))
                ->addColumn(new Column("name", "Название", 120))
                ->addColumn((new Column("region_id", "Регион", 120))->setFn($this, "formatRegion"))
                ->addColumn((new Column("city_id", "Страна", 120))->setFn($this, "formatCountry"))
        ; 
        
        $table
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildInput("name"), null, "required"
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildDropdownUniform("region_id", \Shop\Helpers\Form::prepareDropdown($this->repo)), null, "required"
                ))
                
                ;        
        
        return $table->Render();
    }

    /**
     * 
     * @param \Shop\Models\City\City $city
     * @return type
     */
    public function formatCountry(\Shop\Models\City\City $city)
    {
        return $city->getCityRegion()->getRegionCountry()->getName();
    }
    
    /**
     * 
     * @param \Shop\Models\Region\Region $region
     * @return type
     */
    public function formatRegion(\Shop\Models\City\City $city)
    {
        return $city->getCityRegion()->getName();
    }    
}