<?php

namespace Shop\Models\Product\Base;

use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Shop\Models\Brand\Brand;
use Shop\Models\Category\Category;
use Shop\Models\Position\Position;
use Shop\Models\Product\Product as ChildProduct;
use Shop\Models\Product\ProductQuery as ChildProductQuery;
use Shop\Models\ProductHitSale\ProductHitSale;
use Shop\Models\ProductSuperPrice\ProductSuperPrice;
use Shop\Models\Product\Map\ProductTableMap;
use Shop\Models\ShopProductGroupsRel\ShopProductGroupsRel;

/**
 * Base class that represents a query for the 'shop_products' table.
 *
 *
 *
 * @method     ChildProductQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildProductQuery orderByTitle($order = Criteria::ASC) Order by the title column
 * @method     ChildProductQuery orderByDesc($order = Criteria::ASC) Order by the desc column
 * @method     ChildProductQuery orderByShortDesc($order = Criteria::ASC) Order by the short_desc column
 * @method     ChildProductQuery orderByArticle($order = Criteria::ASC) Order by the article column
 * @method     ChildProductQuery orderByPrice($order = Criteria::ASC) Order by the price column
 * @method     ChildProductQuery orderByImg($order = Criteria::ASC) Order by the img column
 * @method     ChildProductQuery orderBySpecial($order = Criteria::ASC) Order by the special column
 * @method     ChildProductQuery orderByActive($order = Criteria::ASC) Order by the active column
 * @method     ChildProductQuery orderByMtTitle($order = Criteria::ASC) Order by the mt_title column
 * @method     ChildProductQuery orderByMtDescription($order = Criteria::ASC) Order by the mt_description column
 * @method     ChildProductQuery orderByMtKeywords($order = Criteria::ASC) Order by the mt_keywords column
 * @method     ChildProductQuery orderByRemains($order = Criteria::ASC) Order by the remains column
 * @method     ChildProductQuery orderBydateUpdate($order = Criteria::ASC) Order by the udate column
 * @method     ChildProductQuery orderBydateCreate($order = Criteria::ASC) Order by the cdate column
 * @method     ChildProductQuery orderBydatePublic($order = Criteria::ASC) Order by the pdate column
 * @method     ChildProductQuery orderByRef($order = Criteria::ASC) Order by the ref column
 * @method     ChildProductQuery orderByMinQualitye($order = Criteria::ASC) Order by the min_quality column
 * @method     ChildProductQuery orderBySeazon($order = Criteria::ASC) Order by the seazon column
 * @method     ChildProductQuery orderByCategoryId($order = Criteria::ASC) Order by the category_id column
 * @method     ChildProductQuery orderByBrandId($order = Criteria::ASC) Order by the brand_id column
 *
 * @method     ChildProductQuery groupById() Group by the id column
 * @method     ChildProductQuery groupByTitle() Group by the title column
 * @method     ChildProductQuery groupByDesc() Group by the desc column
 * @method     ChildProductQuery groupByShortDesc() Group by the short_desc column
 * @method     ChildProductQuery groupByArticle() Group by the article column
 * @method     ChildProductQuery groupByPrice() Group by the price column
 * @method     ChildProductQuery groupByImg() Group by the img column
 * @method     ChildProductQuery groupBySpecial() Group by the special column
 * @method     ChildProductQuery groupByActive() Group by the active column
 * @method     ChildProductQuery groupByMtTitle() Group by the mt_title column
 * @method     ChildProductQuery groupByMtDescription() Group by the mt_description column
 * @method     ChildProductQuery groupByMtKeywords() Group by the mt_keywords column
 * @method     ChildProductQuery groupByRemains() Group by the remains column
 * @method     ChildProductQuery groupBydateUpdate() Group by the udate column
 * @method     ChildProductQuery groupBydateCreate() Group by the cdate column
 * @method     ChildProductQuery groupBydatePublic() Group by the pdate column
 * @method     ChildProductQuery groupByRef() Group by the ref column
 * @method     ChildProductQuery groupByMinQualitye() Group by the min_quality column
 * @method     ChildProductQuery groupBySeazon() Group by the seazon column
 * @method     ChildProductQuery groupByCategoryId() Group by the category_id column
 * @method     ChildProductQuery groupByBrandId() Group by the brand_id column
 *
 * @method     ChildProductQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildProductQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildProductQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildProductQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildProductQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildProductQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildProductQuery leftJoinCategory($relationAlias = null) Adds a LEFT JOIN clause to the query using the Category relation
 * @method     ChildProductQuery rightJoinCategory($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Category relation
 * @method     ChildProductQuery innerJoinCategory($relationAlias = null) Adds a INNER JOIN clause to the query using the Category relation
 *
 * @method     ChildProductQuery joinWithCategory($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Category relation
 *
 * @method     ChildProductQuery leftJoinWithCategory() Adds a LEFT JOIN clause and with to the query using the Category relation
 * @method     ChildProductQuery rightJoinWithCategory() Adds a RIGHT JOIN clause and with to the query using the Category relation
 * @method     ChildProductQuery innerJoinWithCategory() Adds a INNER JOIN clause and with to the query using the Category relation
 *
 * @method     ChildProductQuery leftJoinBrand($relationAlias = null) Adds a LEFT JOIN clause to the query using the Brand relation
 * @method     ChildProductQuery rightJoinBrand($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Brand relation
 * @method     ChildProductQuery innerJoinBrand($relationAlias = null) Adds a INNER JOIN clause to the query using the Brand relation
 *
 * @method     ChildProductQuery joinWithBrand($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Brand relation
 *
 * @method     ChildProductQuery leftJoinWithBrand() Adds a LEFT JOIN clause and with to the query using the Brand relation
 * @method     ChildProductQuery rightJoinWithBrand() Adds a RIGHT JOIN clause and with to the query using the Brand relation
 * @method     ChildProductQuery innerJoinWithBrand() Adds a INNER JOIN clause and with to the query using the Brand relation
 *
 * @method     ChildProductQuery leftJoinShopProductGroupsRel($relationAlias = null) Adds a LEFT JOIN clause to the query using the ShopProductGroupsRel relation
 * @method     ChildProductQuery rightJoinShopProductGroupsRel($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ShopProductGroupsRel relation
 * @method     ChildProductQuery innerJoinShopProductGroupsRel($relationAlias = null) Adds a INNER JOIN clause to the query using the ShopProductGroupsRel relation
 *
 * @method     ChildProductQuery joinWithShopProductGroupsRel($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the ShopProductGroupsRel relation
 *
 * @method     ChildProductQuery leftJoinWithShopProductGroupsRel() Adds a LEFT JOIN clause and with to the query using the ShopProductGroupsRel relation
 * @method     ChildProductQuery rightJoinWithShopProductGroupsRel() Adds a RIGHT JOIN clause and with to the query using the ShopProductGroupsRel relation
 * @method     ChildProductQuery innerJoinWithShopProductGroupsRel() Adds a INNER JOIN clause and with to the query using the ShopProductGroupsRel relation
 *
 * @method     ChildProductQuery leftJoinPosition($relationAlias = null) Adds a LEFT JOIN clause to the query using the Position relation
 * @method     ChildProductQuery rightJoinPosition($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Position relation
 * @method     ChildProductQuery innerJoinPosition($relationAlias = null) Adds a INNER JOIN clause to the query using the Position relation
 *
 * @method     ChildProductQuery joinWithPosition($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Position relation
 *
 * @method     ChildProductQuery leftJoinWithPosition() Adds a LEFT JOIN clause and with to the query using the Position relation
 * @method     ChildProductQuery rightJoinWithPosition() Adds a RIGHT JOIN clause and with to the query using the Position relation
 * @method     ChildProductQuery innerJoinWithPosition() Adds a INNER JOIN clause and with to the query using the Position relation
 *
 * @method     ChildProductQuery leftJoinProductHitSale($relationAlias = null) Adds a LEFT JOIN clause to the query using the ProductHitSale relation
 * @method     ChildProductQuery rightJoinProductHitSale($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ProductHitSale relation
 * @method     ChildProductQuery innerJoinProductHitSale($relationAlias = null) Adds a INNER JOIN clause to the query using the ProductHitSale relation
 *
 * @method     ChildProductQuery joinWithProductHitSale($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the ProductHitSale relation
 *
 * @method     ChildProductQuery leftJoinWithProductHitSale() Adds a LEFT JOIN clause and with to the query using the ProductHitSale relation
 * @method     ChildProductQuery rightJoinWithProductHitSale() Adds a RIGHT JOIN clause and with to the query using the ProductHitSale relation
 * @method     ChildProductQuery innerJoinWithProductHitSale() Adds a INNER JOIN clause and with to the query using the ProductHitSale relation
 *
 * @method     ChildProductQuery leftJoinProductSuperPrice($relationAlias = null) Adds a LEFT JOIN clause to the query using the ProductSuperPrice relation
 * @method     ChildProductQuery rightJoinProductSuperPrice($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ProductSuperPrice relation
 * @method     ChildProductQuery innerJoinProductSuperPrice($relationAlias = null) Adds a INNER JOIN clause to the query using the ProductSuperPrice relation
 *
 * @method     ChildProductQuery joinWithProductSuperPrice($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the ProductSuperPrice relation
 *
 * @method     ChildProductQuery leftJoinWithProductSuperPrice() Adds a LEFT JOIN clause and with to the query using the ProductSuperPrice relation
 * @method     ChildProductQuery rightJoinWithProductSuperPrice() Adds a RIGHT JOIN clause and with to the query using the ProductSuperPrice relation
 * @method     ChildProductQuery innerJoinWithProductSuperPrice() Adds a INNER JOIN clause and with to the query using the ProductSuperPrice relation
 *
 * @method     \Shop\Models\Category\CategoryQuery|\Shop\Models\Brand\BrandQuery|\Shop\Models\ShopProductGroupsRel\ShopProductGroupsRelQuery|\Shop\Models\Position\PositionQuery|\Shop\Models\ProductHitSale\ProductHitSaleQuery|\Shop\Models\ProductSuperPrice\ProductSuperPriceQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildProduct findOne(ConnectionInterface $con = null) Return the first ChildProduct matching the query
 * @method     ChildProduct findOneOrCreate(ConnectionInterface $con = null) Return the first ChildProduct matching the query, or a new ChildProduct object populated from the query conditions when no match is found
 *
 * @method     ChildProduct findOneById(int $id) Return the first ChildProduct filtered by the id column
 * @method     ChildProduct findOneByTitle(string $title) Return the first ChildProduct filtered by the title column
 * @method     ChildProduct findOneByDesc(string $desc) Return the first ChildProduct filtered by the desc column
 * @method     ChildProduct findOneByShortDesc(string $short_desc) Return the first ChildProduct filtered by the short_desc column
 * @method     ChildProduct findOneByArticle(string $article) Return the first ChildProduct filtered by the article column
 * @method     ChildProduct findOneByPrice(string $price) Return the first ChildProduct filtered by the price column
 * @method     ChildProduct findOneByImg(string $img) Return the first ChildProduct filtered by the img column
 * @method     ChildProduct findOneBySpecial(string $special) Return the first ChildProduct filtered by the special column
 * @method     ChildProduct findOneByActive(string $active) Return the first ChildProduct filtered by the active column
 * @method     ChildProduct findOneByMtTitle(string $mt_title) Return the first ChildProduct filtered by the mt_title column
 * @method     ChildProduct findOneByMtDescription(string $mt_description) Return the first ChildProduct filtered by the mt_description column
 * @method     ChildProduct findOneByMtKeywords(string $mt_keywords) Return the first ChildProduct filtered by the mt_keywords column
 * @method     ChildProduct findOneByRemains(string $remains) Return the first ChildProduct filtered by the remains column
 * @method     ChildProduct findOneBydateUpdate(string $udate) Return the first ChildProduct filtered by the udate column
 * @method     ChildProduct findOneBydateCreate(string $cdate) Return the first ChildProduct filtered by the cdate column
 * @method     ChildProduct findOneBydatePublic(string $pdate) Return the first ChildProduct filtered by the pdate column
 * @method     ChildProduct findOneByRef(int $ref) Return the first ChildProduct filtered by the ref column
 * @method     ChildProduct findOneByMinQualitye(string $min_quality) Return the first ChildProduct filtered by the min_quality column
 * @method     ChildProduct findOneBySeazon(string $seazon) Return the first ChildProduct filtered by the seazon column
 * @method     ChildProduct findOneByCategoryId(int $category_id) Return the first ChildProduct filtered by the category_id column
 * @method     ChildProduct findOneByBrandId(int $brand_id) Return the first ChildProduct filtered by the brand_id column *

 * @method     ChildProduct requirePk($key, ConnectionInterface $con = null) Return the ChildProduct by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProduct requireOne(ConnectionInterface $con = null) Return the first ChildProduct matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildProduct requireOneById(int $id) Return the first ChildProduct filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProduct requireOneByTitle(string $title) Return the first ChildProduct filtered by the title column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProduct requireOneByDesc(string $desc) Return the first ChildProduct filtered by the desc column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProduct requireOneByShortDesc(string $short_desc) Return the first ChildProduct filtered by the short_desc column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProduct requireOneByArticle(string $article) Return the first ChildProduct filtered by the article column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProduct requireOneByPrice(string $price) Return the first ChildProduct filtered by the price column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProduct requireOneByImg(string $img) Return the first ChildProduct filtered by the img column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProduct requireOneBySpecial(string $special) Return the first ChildProduct filtered by the special column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProduct requireOneByActive(string $active) Return the first ChildProduct filtered by the active column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProduct requireOneByMtTitle(string $mt_title) Return the first ChildProduct filtered by the mt_title column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProduct requireOneByMtDescription(string $mt_description) Return the first ChildProduct filtered by the mt_description column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProduct requireOneByMtKeywords(string $mt_keywords) Return the first ChildProduct filtered by the mt_keywords column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProduct requireOneByRemains(string $remains) Return the first ChildProduct filtered by the remains column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProduct requireOneBydateUpdate(string $udate) Return the first ChildProduct filtered by the udate column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProduct requireOneBydateCreate(string $cdate) Return the first ChildProduct filtered by the cdate column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProduct requireOneBydatePublic(string $pdate) Return the first ChildProduct filtered by the pdate column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProduct requireOneByRef(int $ref) Return the first ChildProduct filtered by the ref column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProduct requireOneByMinQualitye(string $min_quality) Return the first ChildProduct filtered by the min_quality column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProduct requireOneBySeazon(string $seazon) Return the first ChildProduct filtered by the seazon column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProduct requireOneByCategoryId(int $category_id) Return the first ChildProduct filtered by the category_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProduct requireOneByBrandId(int $brand_id) Return the first ChildProduct filtered by the brand_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildProduct[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildProduct objects based on current ModelCriteria
 * @method     ChildProduct[]|ObjectCollection findById(int $id) Return ChildProduct objects filtered by the id column
 * @method     ChildProduct[]|ObjectCollection findByTitle(string $title) Return ChildProduct objects filtered by the title column
 * @method     ChildProduct[]|ObjectCollection findByDesc(string $desc) Return ChildProduct objects filtered by the desc column
 * @method     ChildProduct[]|ObjectCollection findByShortDesc(string $short_desc) Return ChildProduct objects filtered by the short_desc column
 * @method     ChildProduct[]|ObjectCollection findByArticle(string $article) Return ChildProduct objects filtered by the article column
 * @method     ChildProduct[]|ObjectCollection findByPrice(string $price) Return ChildProduct objects filtered by the price column
 * @method     ChildProduct[]|ObjectCollection findByImg(string $img) Return ChildProduct objects filtered by the img column
 * @method     ChildProduct[]|ObjectCollection findBySpecial(string $special) Return ChildProduct objects filtered by the special column
 * @method     ChildProduct[]|ObjectCollection findByActive(string $active) Return ChildProduct objects filtered by the active column
 * @method     ChildProduct[]|ObjectCollection findByMtTitle(string $mt_title) Return ChildProduct objects filtered by the mt_title column
 * @method     ChildProduct[]|ObjectCollection findByMtDescription(string $mt_description) Return ChildProduct objects filtered by the mt_description column
 * @method     ChildProduct[]|ObjectCollection findByMtKeywords(string $mt_keywords) Return ChildProduct objects filtered by the mt_keywords column
 * @method     ChildProduct[]|ObjectCollection findByRemains(string $remains) Return ChildProduct objects filtered by the remains column
 * @method     ChildProduct[]|ObjectCollection findBydateUpdate(string $udate) Return ChildProduct objects filtered by the udate column
 * @method     ChildProduct[]|ObjectCollection findBydateCreate(string $cdate) Return ChildProduct objects filtered by the cdate column
 * @method     ChildProduct[]|ObjectCollection findBydatePublic(string $pdate) Return ChildProduct objects filtered by the pdate column
 * @method     ChildProduct[]|ObjectCollection findByRef(int $ref) Return ChildProduct objects filtered by the ref column
 * @method     ChildProduct[]|ObjectCollection findByMinQualitye(string $min_quality) Return ChildProduct objects filtered by the min_quality column
 * @method     ChildProduct[]|ObjectCollection findBySeazon(string $seazon) Return ChildProduct objects filtered by the seazon column
 * @method     ChildProduct[]|ObjectCollection findByCategoryId(int $category_id) Return ChildProduct objects filtered by the category_id column
 * @method     ChildProduct[]|ObjectCollection findByBrandId(int $brand_id) Return ChildProduct objects filtered by the brand_id column
 * @method     ChildProduct[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class ProductQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Shop\Models\Product\Base\ProductQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Shop\\Models\\Product\\Product', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildProductQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildProductQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildProductQuery) {
            return $criteria;
        }
        $query = new ChildProductQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildProduct|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(ProductTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = ProductTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildProduct A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `title`, `desc`, `short_desc`, `article`, `price`, `img`, `special`, `active`, `mt_title`, `mt_description`, `mt_keywords`, `remains`, `udate`, `cdate`, `pdate`, `ref`, `min_quality`, `seazon`, `category_id`, `brand_id` FROM `shop_products` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildProduct $obj */
            $obj = new ChildProduct();
            $obj->hydrate($row);
            ProductTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildProduct|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildProductQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(ProductTableMap::COL_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildProductQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(ProductTableMap::COL_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProductQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(ProductTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(ProductTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProductTableMap::COL_ID, $id, $comparison);
    }

    /**
     * Filter the query on the title column
     *
     * Example usage:
     * <code>
     * $query->filterByTitle('fooValue');   // WHERE title = 'fooValue'
     * $query->filterByTitle('%fooValue%', Criteria::LIKE); // WHERE title LIKE '%fooValue%'
     * </code>
     *
     * @param     string $title The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProductQuery The current query, for fluid interface
     */
    public function filterByTitle($title = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($title)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProductTableMap::COL_TITLE, $title, $comparison);
    }

    /**
     * Filter the query on the desc column
     *
     * Example usage:
     * <code>
     * $query->filterByDesc('fooValue');   // WHERE desc = 'fooValue'
     * $query->filterByDesc('%fooValue%', Criteria::LIKE); // WHERE desc LIKE '%fooValue%'
     * </code>
     *
     * @param     string $desc The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProductQuery The current query, for fluid interface
     */
    public function filterByDesc($desc = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($desc)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProductTableMap::COL_DESC, $desc, $comparison);
    }

    /**
     * Filter the query on the short_desc column
     *
     * Example usage:
     * <code>
     * $query->filterByShortDesc('fooValue');   // WHERE short_desc = 'fooValue'
     * $query->filterByShortDesc('%fooValue%', Criteria::LIKE); // WHERE short_desc LIKE '%fooValue%'
     * </code>
     *
     * @param     string $shortDesc The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProductQuery The current query, for fluid interface
     */
    public function filterByShortDesc($shortDesc = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($shortDesc)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProductTableMap::COL_SHORT_DESC, $shortDesc, $comparison);
    }

    /**
     * Filter the query on the article column
     *
     * Example usage:
     * <code>
     * $query->filterByArticle('fooValue');   // WHERE article = 'fooValue'
     * $query->filterByArticle('%fooValue%', Criteria::LIKE); // WHERE article LIKE '%fooValue%'
     * </code>
     *
     * @param     string $article The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProductQuery The current query, for fluid interface
     */
    public function filterByArticle($article = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($article)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProductTableMap::COL_ARTICLE, $article, $comparison);
    }

    /**
     * Filter the query on the price column
     *
     * Example usage:
     * <code>
     * $query->filterByPrice(1234); // WHERE price = 1234
     * $query->filterByPrice(array(12, 34)); // WHERE price IN (12, 34)
     * $query->filterByPrice(array('min' => 12)); // WHERE price > 12
     * </code>
     *
     * @param     mixed $price The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProductQuery The current query, for fluid interface
     */
    public function filterByPrice($price = null, $comparison = null)
    {
        if (is_array($price)) {
            $useMinMax = false;
            if (isset($price['min'])) {
                $this->addUsingAlias(ProductTableMap::COL_PRICE, $price['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($price['max'])) {
                $this->addUsingAlias(ProductTableMap::COL_PRICE, $price['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProductTableMap::COL_PRICE, $price, $comparison);
    }

    /**
     * Filter the query on the img column
     *
     * Example usage:
     * <code>
     * $query->filterByImg('fooValue');   // WHERE img = 'fooValue'
     * $query->filterByImg('%fooValue%', Criteria::LIKE); // WHERE img LIKE '%fooValue%'
     * </code>
     *
     * @param     string $img The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProductQuery The current query, for fluid interface
     */
    public function filterByImg($img = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($img)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProductTableMap::COL_IMG, $img, $comparison);
    }

    /**
     * Filter the query on the special column
     *
     * Example usage:
     * <code>
     * $query->filterBySpecial('fooValue');   // WHERE special = 'fooValue'
     * $query->filterBySpecial('%fooValue%', Criteria::LIKE); // WHERE special LIKE '%fooValue%'
     * </code>
     *
     * @param     string $special The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProductQuery The current query, for fluid interface
     */
    public function filterBySpecial($special = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($special)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProductTableMap::COL_SPECIAL, $special, $comparison);
    }

    /**
     * Filter the query on the active column
     *
     * Example usage:
     * <code>
     * $query->filterByActive('fooValue');   // WHERE active = 'fooValue'
     * $query->filterByActive('%fooValue%', Criteria::LIKE); // WHERE active LIKE '%fooValue%'
     * </code>
     *
     * @param     string $active The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProductQuery The current query, for fluid interface
     */
    public function filterByActive($active = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($active)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProductTableMap::COL_ACTIVE, $active, $comparison);
    }

    /**
     * Filter the query on the mt_title column
     *
     * Example usage:
     * <code>
     * $query->filterByMtTitle('fooValue');   // WHERE mt_title = 'fooValue'
     * $query->filterByMtTitle('%fooValue%', Criteria::LIKE); // WHERE mt_title LIKE '%fooValue%'
     * </code>
     *
     * @param     string $mtTitle The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProductQuery The current query, for fluid interface
     */
    public function filterByMtTitle($mtTitle = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($mtTitle)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProductTableMap::COL_MT_TITLE, $mtTitle, $comparison);
    }

    /**
     * Filter the query on the mt_description column
     *
     * Example usage:
     * <code>
     * $query->filterByMtDescription('fooValue');   // WHERE mt_description = 'fooValue'
     * $query->filterByMtDescription('%fooValue%', Criteria::LIKE); // WHERE mt_description LIKE '%fooValue%'
     * </code>
     *
     * @param     string $mtDescription The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProductQuery The current query, for fluid interface
     */
    public function filterByMtDescription($mtDescription = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($mtDescription)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProductTableMap::COL_MT_DESCRIPTION, $mtDescription, $comparison);
    }

    /**
     * Filter the query on the mt_keywords column
     *
     * Example usage:
     * <code>
     * $query->filterByMtKeywords('fooValue');   // WHERE mt_keywords = 'fooValue'
     * $query->filterByMtKeywords('%fooValue%', Criteria::LIKE); // WHERE mt_keywords LIKE '%fooValue%'
     * </code>
     *
     * @param     string $mtKeywords The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProductQuery The current query, for fluid interface
     */
    public function filterByMtKeywords($mtKeywords = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($mtKeywords)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProductTableMap::COL_MT_KEYWORDS, $mtKeywords, $comparison);
    }

    /**
     * Filter the query on the remains column
     *
     * Example usage:
     * <code>
     * $query->filterByRemains('fooValue');   // WHERE remains = 'fooValue'
     * $query->filterByRemains('%fooValue%', Criteria::LIKE); // WHERE remains LIKE '%fooValue%'
     * </code>
     *
     * @param     string $remains The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProductQuery The current query, for fluid interface
     */
    public function filterByRemains($remains = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($remains)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProductTableMap::COL_REMAINS, $remains, $comparison);
    }

    /**
     * Filter the query on the udate column
     *
     * Example usage:
     * <code>
     * $query->filterBydateUpdate('2011-03-14'); // WHERE udate = '2011-03-14'
     * $query->filterBydateUpdate('now'); // WHERE udate = '2011-03-14'
     * $query->filterBydateUpdate(array('max' => 'yesterday')); // WHERE udate > '2011-03-13'
     * </code>
     *
     * @param     mixed $dateUpdate The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProductQuery The current query, for fluid interface
     */
    public function filterBydateUpdate($dateUpdate = null, $comparison = null)
    {
        if (is_array($dateUpdate)) {
            $useMinMax = false;
            if (isset($dateUpdate['min'])) {
                $this->addUsingAlias(ProductTableMap::COL_UDATE, $dateUpdate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($dateUpdate['max'])) {
                $this->addUsingAlias(ProductTableMap::COL_UDATE, $dateUpdate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProductTableMap::COL_UDATE, $dateUpdate, $comparison);
    }

    /**
     * Filter the query on the cdate column
     *
     * Example usage:
     * <code>
     * $query->filterBydateCreate('2011-03-14'); // WHERE cdate = '2011-03-14'
     * $query->filterBydateCreate('now'); // WHERE cdate = '2011-03-14'
     * $query->filterBydateCreate(array('max' => 'yesterday')); // WHERE cdate > '2011-03-13'
     * </code>
     *
     * @param     mixed $dateCreate The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProductQuery The current query, for fluid interface
     */
    public function filterBydateCreate($dateCreate = null, $comparison = null)
    {
        if (is_array($dateCreate)) {
            $useMinMax = false;
            if (isset($dateCreate['min'])) {
                $this->addUsingAlias(ProductTableMap::COL_CDATE, $dateCreate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($dateCreate['max'])) {
                $this->addUsingAlias(ProductTableMap::COL_CDATE, $dateCreate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProductTableMap::COL_CDATE, $dateCreate, $comparison);
    }

    /**
     * Filter the query on the pdate column
     *
     * Example usage:
     * <code>
     * $query->filterBydatePublic('2011-03-14'); // WHERE pdate = '2011-03-14'
     * $query->filterBydatePublic('now'); // WHERE pdate = '2011-03-14'
     * $query->filterBydatePublic(array('max' => 'yesterday')); // WHERE pdate > '2011-03-13'
     * </code>
     *
     * @param     mixed $datePublic The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProductQuery The current query, for fluid interface
     */
    public function filterBydatePublic($datePublic = null, $comparison = null)
    {
        if (is_array($datePublic)) {
            $useMinMax = false;
            if (isset($datePublic['min'])) {
                $this->addUsingAlias(ProductTableMap::COL_PDATE, $datePublic['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($datePublic['max'])) {
                $this->addUsingAlias(ProductTableMap::COL_PDATE, $datePublic['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProductTableMap::COL_PDATE, $datePublic, $comparison);
    }

    /**
     * Filter the query on the ref column
     *
     * Example usage:
     * <code>
     * $query->filterByRef(1234); // WHERE ref = 1234
     * $query->filterByRef(array(12, 34)); // WHERE ref IN (12, 34)
     * $query->filterByRef(array('min' => 12)); // WHERE ref > 12
     * </code>
     *
     * @param     mixed $ref The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProductQuery The current query, for fluid interface
     */
    public function filterByRef($ref = null, $comparison = null)
    {
        if (is_array($ref)) {
            $useMinMax = false;
            if (isset($ref['min'])) {
                $this->addUsingAlias(ProductTableMap::COL_REF, $ref['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($ref['max'])) {
                $this->addUsingAlias(ProductTableMap::COL_REF, $ref['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProductTableMap::COL_REF, $ref, $comparison);
    }

    /**
     * Filter the query on the min_quality column
     *
     * Example usage:
     * <code>
     * $query->filterByMinQualitye('fooValue');   // WHERE min_quality = 'fooValue'
     * $query->filterByMinQualitye('%fooValue%', Criteria::LIKE); // WHERE min_quality LIKE '%fooValue%'
     * </code>
     *
     * @param     string $minQualitye The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProductQuery The current query, for fluid interface
     */
    public function filterByMinQualitye($minQualitye = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($minQualitye)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProductTableMap::COL_MIN_QUALITY, $minQualitye, $comparison);
    }

    /**
     * Filter the query on the seazon column
     *
     * Example usage:
     * <code>
     * $query->filterBySeazon('fooValue');   // WHERE seazon = 'fooValue'
     * $query->filterBySeazon('%fooValue%', Criteria::LIKE); // WHERE seazon LIKE '%fooValue%'
     * </code>
     *
     * @param     string $seazon The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProductQuery The current query, for fluid interface
     */
    public function filterBySeazon($seazon = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($seazon)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProductTableMap::COL_SEAZON, $seazon, $comparison);
    }

    /**
     * Filter the query on the category_id column
     *
     * Example usage:
     * <code>
     * $query->filterByCategoryId(1234); // WHERE category_id = 1234
     * $query->filterByCategoryId(array(12, 34)); // WHERE category_id IN (12, 34)
     * $query->filterByCategoryId(array('min' => 12)); // WHERE category_id > 12
     * </code>
     *
     * @see       filterByCategory()
     *
     * @param     mixed $categoryId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProductQuery The current query, for fluid interface
     */
    public function filterByCategoryId($categoryId = null, $comparison = null)
    {
        if (is_array($categoryId)) {
            $useMinMax = false;
            if (isset($categoryId['min'])) {
                $this->addUsingAlias(ProductTableMap::COL_CATEGORY_ID, $categoryId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($categoryId['max'])) {
                $this->addUsingAlias(ProductTableMap::COL_CATEGORY_ID, $categoryId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProductTableMap::COL_CATEGORY_ID, $categoryId, $comparison);
    }

    /**
     * Filter the query on the brand_id column
     *
     * Example usage:
     * <code>
     * $query->filterByBrandId(1234); // WHERE brand_id = 1234
     * $query->filterByBrandId(array(12, 34)); // WHERE brand_id IN (12, 34)
     * $query->filterByBrandId(array('min' => 12)); // WHERE brand_id > 12
     * </code>
     *
     * @see       filterByBrand()
     *
     * @param     mixed $brandId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProductQuery The current query, for fluid interface
     */
    public function filterByBrandId($brandId = null, $comparison = null)
    {
        if (is_array($brandId)) {
            $useMinMax = false;
            if (isset($brandId['min'])) {
                $this->addUsingAlias(ProductTableMap::COL_BRAND_ID, $brandId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($brandId['max'])) {
                $this->addUsingAlias(ProductTableMap::COL_BRAND_ID, $brandId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProductTableMap::COL_BRAND_ID, $brandId, $comparison);
    }

    /**
     * Filter the query by a related \Shop\Models\Category\Category object
     *
     * @param \Shop\Models\Category\Category|ObjectCollection $category The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildProductQuery The current query, for fluid interface
     */
    public function filterByCategory($category, $comparison = null)
    {
        if ($category instanceof \Shop\Models\Category\Category) {
            return $this
                ->addUsingAlias(ProductTableMap::COL_CATEGORY_ID, $category->getId(), $comparison);
        } elseif ($category instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ProductTableMap::COL_CATEGORY_ID, $category->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByCategory() only accepts arguments of type \Shop\Models\Category\Category or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Category relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildProductQuery The current query, for fluid interface
     */
    public function joinCategory($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Category');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Category');
        }

        return $this;
    }

    /**
     * Use the Category relation Category object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\Category\CategoryQuery A secondary query class using the current class as primary query
     */
    public function useCategoryQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinCategory($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Category', '\Shop\Models\Category\CategoryQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\Brand\Brand object
     *
     * @param \Shop\Models\Brand\Brand|ObjectCollection $brand The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildProductQuery The current query, for fluid interface
     */
    public function filterByBrand($brand, $comparison = null)
    {
        if ($brand instanceof \Shop\Models\Brand\Brand) {
            return $this
                ->addUsingAlias(ProductTableMap::COL_BRAND_ID, $brand->getId(), $comparison);
        } elseif ($brand instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ProductTableMap::COL_BRAND_ID, $brand->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByBrand() only accepts arguments of type \Shop\Models\Brand\Brand or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Brand relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildProductQuery The current query, for fluid interface
     */
    public function joinBrand($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Brand');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Brand');
        }

        return $this;
    }

    /**
     * Use the Brand relation Brand object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\Brand\BrandQuery A secondary query class using the current class as primary query
     */
    public function useBrandQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinBrand($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Brand', '\Shop\Models\Brand\BrandQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\ShopProductGroupsRel\ShopProductGroupsRel object
     *
     * @param \Shop\Models\ShopProductGroupsRel\ShopProductGroupsRel|ObjectCollection $shopProductGroupsRel the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildProductQuery The current query, for fluid interface
     */
    public function filterByShopProductGroupsRel($shopProductGroupsRel, $comparison = null)
    {
        if ($shopProductGroupsRel instanceof \Shop\Models\ShopProductGroupsRel\ShopProductGroupsRel) {
            return $this
                ->addUsingAlias(ProductTableMap::COL_ID, $shopProductGroupsRel->getProductId(), $comparison);
        } elseif ($shopProductGroupsRel instanceof ObjectCollection) {
            return $this
                ->useShopProductGroupsRelQuery()
                ->filterByPrimaryKeys($shopProductGroupsRel->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByShopProductGroupsRel() only accepts arguments of type \Shop\Models\ShopProductGroupsRel\ShopProductGroupsRel or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ShopProductGroupsRel relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildProductQuery The current query, for fluid interface
     */
    public function joinShopProductGroupsRel($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ShopProductGroupsRel');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ShopProductGroupsRel');
        }

        return $this;
    }

    /**
     * Use the ShopProductGroupsRel relation ShopProductGroupsRel object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\ShopProductGroupsRel\ShopProductGroupsRelQuery A secondary query class using the current class as primary query
     */
    public function useShopProductGroupsRelQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinShopProductGroupsRel($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ShopProductGroupsRel', '\Shop\Models\ShopProductGroupsRel\ShopProductGroupsRelQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\Position\Position object
     *
     * @param \Shop\Models\Position\Position|ObjectCollection $position the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildProductQuery The current query, for fluid interface
     */
    public function filterByPosition($position, $comparison = null)
    {
        if ($position instanceof \Shop\Models\Position\Position) {
            return $this
                ->addUsingAlias(ProductTableMap::COL_ID, $position->getProductId(), $comparison);
        } elseif ($position instanceof ObjectCollection) {
            return $this
                ->usePositionQuery()
                ->filterByPrimaryKeys($position->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByPosition() only accepts arguments of type \Shop\Models\Position\Position or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Position relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildProductQuery The current query, for fluid interface
     */
    public function joinPosition($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Position');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Position');
        }

        return $this;
    }

    /**
     * Use the Position relation Position object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\Position\PositionQuery A secondary query class using the current class as primary query
     */
    public function usePositionQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinPosition($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Position', '\Shop\Models\Position\PositionQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\ProductHitSale\ProductHitSale object
     *
     * @param \Shop\Models\ProductHitSale\ProductHitSale|ObjectCollection $productHitSale the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildProductQuery The current query, for fluid interface
     */
    public function filterByProductHitSale($productHitSale, $comparison = null)
    {
        if ($productHitSale instanceof \Shop\Models\ProductHitSale\ProductHitSale) {
            return $this
                ->addUsingAlias(ProductTableMap::COL_ID, $productHitSale->getProductId(), $comparison);
        } elseif ($productHitSale instanceof ObjectCollection) {
            return $this
                ->useProductHitSaleQuery()
                ->filterByPrimaryKeys($productHitSale->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByProductHitSale() only accepts arguments of type \Shop\Models\ProductHitSale\ProductHitSale or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ProductHitSale relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildProductQuery The current query, for fluid interface
     */
    public function joinProductHitSale($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ProductHitSale');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ProductHitSale');
        }

        return $this;
    }

    /**
     * Use the ProductHitSale relation ProductHitSale object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\ProductHitSale\ProductHitSaleQuery A secondary query class using the current class as primary query
     */
    public function useProductHitSaleQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProductHitSale($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ProductHitSale', '\Shop\Models\ProductHitSale\ProductHitSaleQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\ProductSuperPrice\ProductSuperPrice object
     *
     * @param \Shop\Models\ProductSuperPrice\ProductSuperPrice|ObjectCollection $productSuperPrice the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildProductQuery The current query, for fluid interface
     */
    public function filterByProductSuperPrice($productSuperPrice, $comparison = null)
    {
        if ($productSuperPrice instanceof \Shop\Models\ProductSuperPrice\ProductSuperPrice) {
            return $this
                ->addUsingAlias(ProductTableMap::COL_ID, $productSuperPrice->getProductId(), $comparison);
        } elseif ($productSuperPrice instanceof ObjectCollection) {
            return $this
                ->useProductSuperPriceQuery()
                ->filterByPrimaryKeys($productSuperPrice->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByProductSuperPrice() only accepts arguments of type \Shop\Models\ProductSuperPrice\ProductSuperPrice or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ProductSuperPrice relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildProductQuery The current query, for fluid interface
     */
    public function joinProductSuperPrice($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ProductSuperPrice');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ProductSuperPrice');
        }

        return $this;
    }

    /**
     * Use the ProductSuperPrice relation ProductSuperPrice object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\ProductSuperPrice\ProductSuperPriceQuery A secondary query class using the current class as primary query
     */
    public function useProductSuperPriceQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProductSuperPrice($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ProductSuperPrice', '\Shop\Models\ProductSuperPrice\ProductSuperPriceQuery');
    }

    /**
     * Filter the query by a related ProductGroup object
     * using the shop_product_groups_rel table as cross reference
     *
     * @param ProductGroup $productGroup the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildProductQuery The current query, for fluid interface
     */
    public function filterByProductGroup($productGroup, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useShopProductGroupsRelQuery()
            ->filterByProductGroup($productGroup, $comparison)
            ->endUse();
    }

    /**
     * Exclude object from result
     *
     * @param   ChildProduct $product Object to remove from the list of results
     *
     * @return $this|ChildProductQuery The current query, for fluid interface
     */
    public function prune($product = null)
    {
        if ($product) {
            $this->addUsingAlias(ProductTableMap::COL_ID, $product->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the shop_products table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ProductTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            ProductTableMap::clearInstancePool();
            ProductTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ProductTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(ProductTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            ProductTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            ProductTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

} // ProductQuery
