<?php

namespace Shop\Models\Order;

use Shop\Models\Order\Base\Order as BaseOrder;

/**
 * Skeleton subclass for representing a row from the 'shop_orders' table.
 *
 *
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 */
class Order extends BaseOrder
{

    /**
     * summ
     * @return float
     */
    public function getSumm():float
    {
        $summ = 0;
        foreach ($this->getOrderItems() as $item) {
            $summ = $summ + $item->getPrice() * $item->getAmount();
        }

        return (float)$summ;
    }
    
    /**
     * count items
     * @return int
     */
    public function getItemsCount():int
    {
        return $this->getOrderItems()->count();
    }

    /**
     * order number
     * @return string
     */
    public function getOrderCode(): string
    {
        return sprintf("IM-%s-%s", $this->getShopId(), $this->getId());
    }
    
    /**
     * 
     * @return float
     */
    public function getOrderFinalSumm():float
    {
        $summ = $this->getSumm();
        
        return (float)$summ - (float)$this->getDiscountSumm();
    }

}