<?php

namespace Shop\Models\Order\Map;

use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;
use Shop\Models\Order\Order;
use Shop\Models\Order\OrderQuery;


/**
 * This class defines the structure of the 'shop_orders' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 */
class OrderTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'Models.Order.Map.OrderTableMap';

    /**
     * The default database name for this class
     */
    const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    const TABLE_NAME = 'shop_orders';

    /**
     * The related Propel class for this table
     */
    const OM_CLASS = '\\Shop\\Models\\Order\\Order';

    /**
     * A class that can be returned by this tableMap
     */
    const CLASS_DEFAULT = 'Models.Order.Order';

    /**
     * The total number of columns
     */
    const NUM_COLUMNS = 12;

    /**
     * The number of lazy-loaded columns
     */
    const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    const NUM_HYDRATE_COLUMNS = 12;

    /**
     * the column name for the id field
     */
    const COL_ID = 'shop_orders.id';

    /**
     * the column name for the customer_id field
     */
    const COL_CUSTOMER_ID = 'shop_orders.customer_id';

    /**
     * the column name for the datetime field
     */
    const COL_DATETIME = 'shop_orders.datetime';

    /**
     * the column name for the udatetime field
     */
    const COL_UDATETIME = 'shop_orders.udatetime';

    /**
     * the column name for the discount_summ field
     */
    const COL_DISCOUNT_SUMM = 'shop_orders.discount_summ';

    /**
     * the column name for the reload field
     */
    const COL_RELOAD = 'shop_orders.reload';

    /**
     * the column name for the delivery_address field
     */
    const COL_DELIVERY_ADDRESS = 'shop_orders.delivery_address';

    /**
     * the column name for the payment_id field
     */
    const COL_PAYMENT_ID = 'shop_orders.payment_id';

    /**
     * the column name for the state_id field
     */
    const COL_STATE_ID = 'shop_orders.state_id';

    /**
     * the column name for the comment field
     */
    const COL_COMMENT = 'shop_orders.comment';

    /**
     * the column name for the post_code field
     */
    const COL_POST_CODE = 'shop_orders.post_code';

    /**
     * the column name for the shop_id field
     */
    const COL_SHOP_ID = 'shop_orders.shop_id';

    /**
     * The default string format for model objects of the related table
     */
    const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     */
    protected static $fieldNames = array (
        self::TYPE_PHPNAME       => array('Id', 'CustomerId', 'Datetime', 'UDatetime', 'DiscountSumm', 'Reload', 'DeliveryAddress', 'PaymentId', 'StateId', 'Comment', 'PostCode', 'ShopId', ),
        self::TYPE_CAMELNAME     => array('id', 'customerId', 'datetime', 'uDatetime', 'discountSumm', 'reload', 'deliveryAddress', 'paymentId', 'stateId', 'comment', 'postCode', 'shopId', ),
        self::TYPE_COLNAME       => array(OrderTableMap::COL_ID, OrderTableMap::COL_CUSTOMER_ID, OrderTableMap::COL_DATETIME, OrderTableMap::COL_UDATETIME, OrderTableMap::COL_DISCOUNT_SUMM, OrderTableMap::COL_RELOAD, OrderTableMap::COL_DELIVERY_ADDRESS, OrderTableMap::COL_PAYMENT_ID, OrderTableMap::COL_STATE_ID, OrderTableMap::COL_COMMENT, OrderTableMap::COL_POST_CODE, OrderTableMap::COL_SHOP_ID, ),
        self::TYPE_FIELDNAME     => array('id', 'customer_id', 'datetime', 'udatetime', 'discount_summ', 'reload', 'delivery_address', 'payment_id', 'state_id', 'comment', 'post_code', 'shop_id', ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, )
    );

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     */
    protected static $fieldKeys = array (
        self::TYPE_PHPNAME       => array('Id' => 0, 'CustomerId' => 1, 'Datetime' => 2, 'UDatetime' => 3, 'DiscountSumm' => 4, 'Reload' => 5, 'DeliveryAddress' => 6, 'PaymentId' => 7, 'StateId' => 8, 'Comment' => 9, 'PostCode' => 10, 'ShopId' => 11, ),
        self::TYPE_CAMELNAME     => array('id' => 0, 'customerId' => 1, 'datetime' => 2, 'uDatetime' => 3, 'discountSumm' => 4, 'reload' => 5, 'deliveryAddress' => 6, 'paymentId' => 7, 'stateId' => 8, 'comment' => 9, 'postCode' => 10, 'shopId' => 11, ),
        self::TYPE_COLNAME       => array(OrderTableMap::COL_ID => 0, OrderTableMap::COL_CUSTOMER_ID => 1, OrderTableMap::COL_DATETIME => 2, OrderTableMap::COL_UDATETIME => 3, OrderTableMap::COL_DISCOUNT_SUMM => 4, OrderTableMap::COL_RELOAD => 5, OrderTableMap::COL_DELIVERY_ADDRESS => 6, OrderTableMap::COL_PAYMENT_ID => 7, OrderTableMap::COL_STATE_ID => 8, OrderTableMap::COL_COMMENT => 9, OrderTableMap::COL_POST_CODE => 10, OrderTableMap::COL_SHOP_ID => 11, ),
        self::TYPE_FIELDNAME     => array('id' => 0, 'customer_id' => 1, 'datetime' => 2, 'udatetime' => 3, 'discount_summ' => 4, 'reload' => 5, 'delivery_address' => 6, 'payment_id' => 7, 'state_id' => 8, 'comment' => 9, 'post_code' => 10, 'shop_id' => 11, ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, )
    );

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('shop_orders');
        $this->setPhpName('Order');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Shop\\Models\\Order\\Order');
        $this->setPackage('Models.Order');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addForeignKey('customer_id', 'CustomerId', 'INTEGER', 'shop_customer', 'id', true, null, null);
        $this->addColumn('datetime', 'Datetime', 'TIMESTAMP', true, null, 'CURRENT_TIMESTAMP');
        $this->addColumn('udatetime', 'UDatetime', 'TIMESTAMP', false, null, null);
        $this->addColumn('discount_summ', 'DiscountSumm', 'DECIMAL', false, 19, 0);
        $this->addColumn('reload', 'Reload', 'CHAR', true, null, 'N');
        $this->addColumn('delivery_address', 'DeliveryAddress', 'LONGVARCHAR', false, null, null);
        $this->addForeignKey('payment_id', 'PaymentId', 'INTEGER', 'shop_payments', 'id', true, null, null);
        $this->addForeignKey('state_id', 'StateId', 'INTEGER', 'shop_states', 'id', true, null, null);
        $this->addColumn('comment', 'Comment', 'LONGVARCHAR', false, null, null);
        $this->addColumn('post_code', 'PostCode', 'VARCHAR', false, 100, null);
        $this->addForeignKey('shop_id', 'ShopId', 'INTEGER', 'shop_shops', 'id', true, null, null);
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
        $this->addRelation('Customer', '\\Shop\\Models\\Customer\\Customer', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':customer_id',
    1 => ':id',
  ),
), null, null, null, false);
        $this->addRelation('Payment', '\\Shop\\Models\\Payment\\Payment', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':payment_id',
    1 => ':id',
  ),
), null, null, null, false);
        $this->addRelation('State', '\\Shop\\Models\\State\\State', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':state_id',
    1 => ':id',
  ),
), null, null, null, false);
        $this->addRelation('Shop', '\\Shop\\Models\\Shop\\Shop', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':shop_id',
    1 => ':id',
  ),
), null, null, null, false);
        $this->addRelation('PaymentTransaction', '\\Shop\\Models\\PaymentTransaction\\PaymentTransaction', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':order_id',
    1 => ':id',
  ),
), null, null, 'PaymentTransactions', false);
        $this->addRelation('OrderItem', '\\Shop\\Models\\OrderItem\\OrderItem', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':order_id',
    1 => ':id',
  ),
), null, null, 'OrderItems', false);
    } // buildRelations()

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param boolean $withPrefix Whether or not to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass($withPrefix = true)
    {
        return $withPrefix ? OrderTableMap::CLASS_DEFAULT : OrderTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array  $row       row returned by DataFetcher->fetch().
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array           (Order object, last column rank)
     */
    public static function populateObject($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        $key = OrderTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = OrderTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + OrderTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = OrderTableMap::OM_CLASS;
            /** @var Order $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            OrderTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher)
    {
        $results = array();

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = OrderTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = OrderTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var Order $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                OrderTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria object containing the columns to add.
     * @param string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function addSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->addSelectColumn(OrderTableMap::COL_ID);
            $criteria->addSelectColumn(OrderTableMap::COL_CUSTOMER_ID);
            $criteria->addSelectColumn(OrderTableMap::COL_DATETIME);
            $criteria->addSelectColumn(OrderTableMap::COL_UDATETIME);
            $criteria->addSelectColumn(OrderTableMap::COL_DISCOUNT_SUMM);
            $criteria->addSelectColumn(OrderTableMap::COL_RELOAD);
            $criteria->addSelectColumn(OrderTableMap::COL_DELIVERY_ADDRESS);
            $criteria->addSelectColumn(OrderTableMap::COL_PAYMENT_ID);
            $criteria->addSelectColumn(OrderTableMap::COL_STATE_ID);
            $criteria->addSelectColumn(OrderTableMap::COL_COMMENT);
            $criteria->addSelectColumn(OrderTableMap::COL_POST_CODE);
            $criteria->addSelectColumn(OrderTableMap::COL_SHOP_ID);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.customer_id');
            $criteria->addSelectColumn($alias . '.datetime');
            $criteria->addSelectColumn($alias . '.udatetime');
            $criteria->addSelectColumn($alias . '.discount_summ');
            $criteria->addSelectColumn($alias . '.reload');
            $criteria->addSelectColumn($alias . '.delivery_address');
            $criteria->addSelectColumn($alias . '.payment_id');
            $criteria->addSelectColumn($alias . '.state_id');
            $criteria->addSelectColumn($alias . '.comment');
            $criteria->addSelectColumn($alias . '.post_code');
            $criteria->addSelectColumn($alias . '.shop_id');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap()
    {
        return Propel::getServiceContainer()->getDatabaseMap(OrderTableMap::DATABASE_NAME)->getTable(OrderTableMap::TABLE_NAME);
    }

    /**
     * Add a TableMap instance to the database for this tableMap class.
     */
    public static function buildTableMap()
    {
        $dbMap = Propel::getServiceContainer()->getDatabaseMap(OrderTableMap::DATABASE_NAME);
        if (!$dbMap->hasTable(OrderTableMap::TABLE_NAME)) {
            $dbMap->addTableObject(new OrderTableMap());
        }
    }

    /**
     * Performs a DELETE on the database, given a Order or Criteria object OR a primary key value.
     *
     * @param mixed               $values Criteria or Order object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param  ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ConnectionInterface $con = null)
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(OrderTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Shop\Models\Order\Order) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(OrderTableMap::DATABASE_NAME);
            $criteria->add(OrderTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = OrderQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            OrderTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                OrderTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the shop_orders table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(ConnectionInterface $con = null)
    {
        return OrderQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a Order or Criteria object.
     *
     * @param mixed               $criteria Criteria or Order object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed           The new primary key.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(OrderTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from Order object
        }

        if ($criteria->containsKey(OrderTableMap::COL_ID) && $criteria->keyContainsValue(OrderTableMap::COL_ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.OrderTableMap::COL_ID.')');
        }


        // Set the correct dbName
        $query = OrderQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

} // OrderTableMap
// This is the static code needed to register the TableMap for this table with the main Propel class.
//
OrderTableMap::buildTableMap();
