<?php

namespace Shop\Models\Order\Base;

use \DateTime;
use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveRecord\ActiveRecordInterface;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\BadMethodCallException;
use Propel\Runtime\Exception\LogicException;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Parser\AbstractParser;
use Propel\Runtime\Util\PropelDateTime;
use Shop\Models\Customer\Customer;
use Shop\Models\Customer\CustomerQuery;
use Shop\Models\Order\Order as ChildOrder;
use Shop\Models\Order\OrderQuery as ChildOrderQuery;
use Shop\Models\OrderItem\OrderItem;
use Shop\Models\OrderItem\OrderItemQuery;
use Shop\Models\OrderItem\Base\OrderItem as BaseOrderItem;
use Shop\Models\OrderItem\Map\OrderItemTableMap;
use Shop\Models\Order\Map\OrderTableMap;
use Shop\Models\Payment\Payment;
use Shop\Models\Payment\PaymentQuery;
use Shop\Models\PaymentTransaction\PaymentTransaction;
use Shop\Models\PaymentTransaction\PaymentTransactionQuery;
use Shop\Models\PaymentTransaction\Base\PaymentTransaction as BasePaymentTransaction;
use Shop\Models\PaymentTransaction\Map\PaymentTransactionTableMap;
use Shop\Models\Shop\Shop;
use Shop\Models\Shop\ShopQuery;
use Shop\Models\State\State;
use Shop\Models\State\StateQuery;

/**
 * Base class that represents a row from the 'shop_orders' table.
 *
 *
 *
 * @package    propel.generator.Models.Order.Base
 */
abstract class Order implements ActiveRecordInterface
{
    /**
     * TableMap class name
     */
    const TABLE_MAP = '\\Shop\\Models\\Order\\Map\\OrderTableMap';


    /**
     * attribute to determine if this object has previously been saved.
     * @var boolean
     */
    protected $new = true;

    /**
     * attribute to determine whether this object has been deleted.
     * @var boolean
     */
    protected $deleted = false;

    /**
     * The columns that have been modified in current object.
     * Tracking modified columns allows us to only update modified columns.
     * @var array
     */
    protected $modifiedColumns = array();

    /**
     * The (virtual) columns that are added at runtime
     * The formatters can add supplementary columns based on a resultset
     * @var array
     */
    protected $virtualColumns = array();

    /**
     * The value for the id field.
     *
     * @var        int
     */
    protected $id;

    /**
     * The value for the customer_id field.
     *
     * @var        int
     */
    protected $customer_id;

    /**
     * The value for the datetime field.
     *
     * Note: this column has a database default value of: (expression) CURRENT_TIMESTAMP
     * @var        DateTime
     */
    protected $datetime;

    /**
     * The value for the udatetime field.
     *
     * @var        DateTime
     */
    protected $udatetime;

    /**
     * The value for the discount_summ field.
     *
     * Note: this column has a database default value of: '0.00'
     * @var        string
     */
    protected $discount_summ;

    /**
     * The value for the reload field.
     *
     * Note: this column has a database default value of: 'N'
     * @var        string
     */
    protected $reload;

    /**
     * The value for the delivery_address field.
     *
     * @var        string
     */
    protected $delivery_address;

    /**
     * The value for the payment_id field.
     *
     * @var        int
     */
    protected $payment_id;

    /**
     * The value for the state_id field.
     *
     * @var        int
     */
    protected $state_id;

    /**
     * The value for the comment field.
     *
     * @var        string
     */
    protected $comment;

    /**
     * The value for the post_code field.
     *
     * @var        string
     */
    protected $post_code;

    /**
     * The value for the shop_id field.
     *
     * @var        int
     */
    protected $shop_id;

    /**
     * @var        Customer
     */
    protected $aCustomer;

    /**
     * @var        Payment
     */
    protected $aPayment;

    /**
     * @var        State
     */
    protected $aState;

    /**
     * @var        Shop
     */
    protected $aShop;

    /**
     * @var        ObjectCollection|PaymentTransaction[] Collection to store aggregation of PaymentTransaction objects.
     */
    protected $collPaymentTransactions;
    protected $collPaymentTransactionsPartial;

    /**
     * @var        ObjectCollection|OrderItem[] Collection to store aggregation of OrderItem objects.
     */
    protected $collOrderItems;
    protected $collOrderItemsPartial;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     *
     * @var boolean
     */
    protected $alreadyInSave = false;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|PaymentTransaction[]
     */
    protected $paymentTransactionsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|OrderItem[]
     */
    protected $orderItemsScheduledForDeletion = null;

    /**
     * Applies default values to this object.
     * This method should be called from the object's constructor (or
     * equivalent initialization method).
     * @see __construct()
     */
    public function applyDefaultValues()
    {
        $this->discount_summ = '0.00';
        $this->reload = 'N';
    }

    /**
     * Initializes internal state of Shop\Models\Order\Base\Order object.
     * @see applyDefaults()
     */
    public function __construct()
    {
        $this->applyDefaultValues();
    }

    /**
     * Returns whether the object has been modified.
     *
     * @return boolean True if the object has been modified.
     */
    public function isModified()
    {
        return !!$this->modifiedColumns;
    }

    /**
     * Has specified column been modified?
     *
     * @param  string  $col column fully qualified name (TableMap::TYPE_COLNAME), e.g. Book::AUTHOR_ID
     * @return boolean True if $col has been modified.
     */
    public function isColumnModified($col)
    {
        return $this->modifiedColumns && isset($this->modifiedColumns[$col]);
    }

    /**
     * Get the columns that have been modified in this object.
     * @return array A unique list of the modified column names for this object.
     */
    public function getModifiedColumns()
    {
        return $this->modifiedColumns ? array_keys($this->modifiedColumns) : [];
    }

    /**
     * Returns whether the object has ever been saved.  This will
     * be false, if the object was retrieved from storage or was created
     * and then saved.
     *
     * @return boolean true, if the object has never been persisted.
     */
    public function isNew()
    {
        return $this->new;
    }

    /**
     * Setter for the isNew attribute.  This method will be called
     * by Propel-generated children and objects.
     *
     * @param boolean $b the state of the object.
     */
    public function setNew($b)
    {
        $this->new = (boolean) $b;
    }

    /**
     * Whether this object has been deleted.
     * @return boolean The deleted state of this object.
     */
    public function isDeleted()
    {
        return $this->deleted;
    }

    /**
     * Specify whether this object has been deleted.
     * @param  boolean $b The deleted state of this object.
     * @return void
     */
    public function setDeleted($b)
    {
        $this->deleted = (boolean) $b;
    }

    /**
     * Sets the modified state for the object to be false.
     * @param  string $col If supplied, only the specified column is reset.
     * @return void
     */
    public function resetModified($col = null)
    {
        if (null !== $col) {
            if (isset($this->modifiedColumns[$col])) {
                unset($this->modifiedColumns[$col]);
            }
        } else {
            $this->modifiedColumns = array();
        }
    }

    /**
     * Compares this with another <code>Order</code> instance.  If
     * <code>obj</code> is an instance of <code>Order</code>, delegates to
     * <code>equals(Order)</code>.  Otherwise, returns <code>false</code>.
     *
     * @param  mixed   $obj The object to compare to.
     * @return boolean Whether equal to the object specified.
     */
    public function equals($obj)
    {
        if (!$obj instanceof static) {
            return false;
        }

        if ($this === $obj) {
            return true;
        }

        if (null === $this->getPrimaryKey() || null === $obj->getPrimaryKey()) {
            return false;
        }

        return $this->getPrimaryKey() === $obj->getPrimaryKey();
    }

    /**
     * Get the associative array of the virtual columns in this object
     *
     * @return array
     */
    public function getVirtualColumns()
    {
        return $this->virtualColumns;
    }

    /**
     * Checks the existence of a virtual column in this object
     *
     * @param  string  $name The virtual column name
     * @return boolean
     */
    public function hasVirtualColumn($name)
    {
        return array_key_exists($name, $this->virtualColumns);
    }

    /**
     * Get the value of a virtual column in this object
     *
     * @param  string $name The virtual column name
     * @return mixed
     *
     * @throws PropelException
     */
    public function getVirtualColumn($name)
    {
        if (!$this->hasVirtualColumn($name)) {
            throw new PropelException(sprintf('Cannot get value of inexistent virtual column %s.', $name));
        }

        return $this->virtualColumns[$name];
    }

    /**
     * Set the value of a virtual column in this object
     *
     * @param string $name  The virtual column name
     * @param mixed  $value The value to give to the virtual column
     *
     * @return $this|Order The current object, for fluid interface
     */
    public function setVirtualColumn($name, $value)
    {
        $this->virtualColumns[$name] = $value;

        return $this;
    }

    /**
     * Logs a message using Propel::log().
     *
     * @param  string  $msg
     * @param  int     $priority One of the Propel::LOG_* logging levels
     * @return boolean
     */
    protected function log($msg, $priority = Propel::LOG_INFO)
    {
        return Propel::log(get_class($this) . ': ' . $msg, $priority);
    }

    /**
     * Export the current object properties to a string, using a given parser format
     * <code>
     * $book = BookQuery::create()->findPk(9012);
     * echo $book->exportTo('JSON');
     *  => {"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * @param  mixed   $parser                 A AbstractParser instance, or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param  boolean $includeLazyLoadColumns (optional) Whether to include lazy load(ed) columns. Defaults to TRUE.
     * @return string  The exported data
     */
    public function exportTo($parser, $includeLazyLoadColumns = true)
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        return $parser->fromArray($this->toArray(TableMap::TYPE_PHPNAME, $includeLazyLoadColumns, array(), true));
    }

    /**
     * Clean up internal collections prior to serializing
     * Avoids recursive loops that turn into segmentation faults when serializing
     */
    public function __sleep()
    {
        $this->clearAllReferences();

        $cls = new \ReflectionClass($this);
        $propertyNames = [];
        $serializableProperties = array_diff($cls->getProperties(), $cls->getProperties(\ReflectionProperty::IS_STATIC));

        foreach($serializableProperties as $property) {
            $propertyNames[] = $property->getName();
        }

        return $propertyNames;
    }

    /**
     * Get the [id] column value.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [customer_id] column value.
     *
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customer_id;
    }

    /**
     * Get the [optionally formatted] temporal [datetime] column value.
     *
     *
     * @param      string|null $format The date/time format string (either date()-style or strftime()-style).
     *                            If format is NULL, then the raw DateTime object will be returned.
     *
     * @return string|DateTime Formatted date/time value as string or DateTime object (if format is NULL), NULL if column is NULL, and 0 if column value is 0000-00-00 00:00:00
     *
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getDatetime($format = NULL)
    {
        if ($format === null) {
            return $this->datetime;
        } else {
            return $this->datetime instanceof \DateTimeInterface ? $this->datetime->format($format) : null;
        }
    }

    /**
     * Get the [optionally formatted] temporal [udatetime] column value.
     *
     *
     * @param      string|null $format The date/time format string (either date()-style or strftime()-style).
     *                            If format is NULL, then the raw DateTime object will be returned.
     *
     * @return string|DateTime Formatted date/time value as string or DateTime object (if format is NULL), NULL if column is NULL, and 0 if column value is 0000-00-00 00:00:00
     *
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getUDatetime($format = NULL)
    {
        if ($format === null) {
            return $this->udatetime;
        } else {
            return $this->udatetime instanceof \DateTimeInterface ? $this->udatetime->format($format) : null;
        }
    }

    /**
     * Get the [discount_summ] column value.
     *
     * @return string
     */
    public function getDiscountSumm()
    {
        return $this->discount_summ;
    }

    /**
     * Get the [reload] column value.
     *
     * @return string
     */
    public function getReload()
    {
        return $this->reload;
    }

    /**
     * Get the [delivery_address] column value.
     *
     * @return string
     */
    public function getDeliveryAddress()
    {
        return $this->delivery_address;
    }

    /**
     * Get the [payment_id] column value.
     *
     * @return int
     */
    public function getPaymentId()
    {
        return $this->payment_id;
    }

    /**
     * Get the [state_id] column value.
     *
     * @return int
     */
    public function getStateId()
    {
        return $this->state_id;
    }

    /**
     * Get the [comment] column value.
     *
     * @return string
     */
    public function getComment()
    {
        return $this->comment;
    }

    /**
     * Get the [post_code] column value.
     *
     * @return string
     */
    public function getPostCode()
    {
        return $this->post_code;
    }

    /**
     * Get the [shop_id] column value.
     *
     * @return int
     */
    public function getShopId()
    {
        return $this->shop_id;
    }

    /**
     * Set the value of [id] column.
     *
     * @param int $v new value
     * @return $this|\Shop\Models\Order\Order The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[OrderTableMap::COL_ID] = true;
        }

        return $this;
    } // setId()

    /**
     * Set the value of [customer_id] column.
     *
     * @param int $v new value
     * @return $this|\Shop\Models\Order\Order The current object (for fluent API support)
     */
    public function setCustomerId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->customer_id !== $v) {
            $this->customer_id = $v;
            $this->modifiedColumns[OrderTableMap::COL_CUSTOMER_ID] = true;
        }

        if ($this->aCustomer !== null && $this->aCustomer->getId() !== $v) {
            $this->aCustomer = null;
        }

        return $this;
    } // setCustomerId()

    /**
     * Sets the value of [datetime] column to a normalized version of the date/time value specified.
     *
     * @param  mixed $v string, integer (timestamp), or \DateTimeInterface value.
     *               Empty strings are treated as NULL.
     * @return $this|\Shop\Models\Order\Order The current object (for fluent API support)
     */
    public function setDatetime($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->datetime !== null || $dt !== null) {
            if ($this->datetime === null || $dt === null || $dt->format("Y-m-d H:i:s.u") !== $this->datetime->format("Y-m-d H:i:s.u")) {
                $this->datetime = $dt === null ? null : clone $dt;
                $this->modifiedColumns[OrderTableMap::COL_DATETIME] = true;
            }
        } // if either are not null

        return $this;
    } // setDatetime()

    /**
     * Sets the value of [udatetime] column to a normalized version of the date/time value specified.
     *
     * @param  mixed $v string, integer (timestamp), or \DateTimeInterface value.
     *               Empty strings are treated as NULL.
     * @return $this|\Shop\Models\Order\Order The current object (for fluent API support)
     */
    public function setUDatetime($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->udatetime !== null || $dt !== null) {
            if ($this->udatetime === null || $dt === null || $dt->format("Y-m-d H:i:s.u") !== $this->udatetime->format("Y-m-d H:i:s.u")) {
                $this->udatetime = $dt === null ? null : clone $dt;
                $this->modifiedColumns[OrderTableMap::COL_UDATETIME] = true;
            }
        } // if either are not null

        return $this;
    } // setUDatetime()

    /**
     * Set the value of [discount_summ] column.
     *
     * @param string $v new value
     * @return $this|\Shop\Models\Order\Order The current object (for fluent API support)
     */
    public function setDiscountSumm($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->discount_summ !== $v) {
            $this->discount_summ = $v;
            $this->modifiedColumns[OrderTableMap::COL_DISCOUNT_SUMM] = true;
        }

        return $this;
    } // setDiscountSumm()

    /**
     * Set the value of [reload] column.
     *
     * @param string $v new value
     * @return $this|\Shop\Models\Order\Order The current object (for fluent API support)
     */
    public function setReload($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->reload !== $v) {
            $this->reload = $v;
            $this->modifiedColumns[OrderTableMap::COL_RELOAD] = true;
        }

        return $this;
    } // setReload()

    /**
     * Set the value of [delivery_address] column.
     *
     * @param string $v new value
     * @return $this|\Shop\Models\Order\Order The current object (for fluent API support)
     */
    public function setDeliveryAddress($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->delivery_address !== $v) {
            $this->delivery_address = $v;
            $this->modifiedColumns[OrderTableMap::COL_DELIVERY_ADDRESS] = true;
        }

        return $this;
    } // setDeliveryAddress()

    /**
     * Set the value of [payment_id] column.
     *
     * @param int $v new value
     * @return $this|\Shop\Models\Order\Order The current object (for fluent API support)
     */
    public function setPaymentId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->payment_id !== $v) {
            $this->payment_id = $v;
            $this->modifiedColumns[OrderTableMap::COL_PAYMENT_ID] = true;
        }

        if ($this->aPayment !== null && $this->aPayment->getId() !== $v) {
            $this->aPayment = null;
        }

        return $this;
    } // setPaymentId()

    /**
     * Set the value of [state_id] column.
     *
     * @param int $v new value
     * @return $this|\Shop\Models\Order\Order The current object (for fluent API support)
     */
    public function setStateId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->state_id !== $v) {
            $this->state_id = $v;
            $this->modifiedColumns[OrderTableMap::COL_STATE_ID] = true;
        }

        if ($this->aState !== null && $this->aState->getId() !== $v) {
            $this->aState = null;
        }

        return $this;
    } // setStateId()

    /**
     * Set the value of [comment] column.
     *
     * @param string $v new value
     * @return $this|\Shop\Models\Order\Order The current object (for fluent API support)
     */
    public function setComment($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->comment !== $v) {
            $this->comment = $v;
            $this->modifiedColumns[OrderTableMap::COL_COMMENT] = true;
        }

        return $this;
    } // setComment()

    /**
     * Set the value of [post_code] column.
     *
     * @param string $v new value
     * @return $this|\Shop\Models\Order\Order The current object (for fluent API support)
     */
    public function setPostCode($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->post_code !== $v) {
            $this->post_code = $v;
            $this->modifiedColumns[OrderTableMap::COL_POST_CODE] = true;
        }

        return $this;
    } // setPostCode()

    /**
     * Set the value of [shop_id] column.
     *
     * @param int $v new value
     * @return $this|\Shop\Models\Order\Order The current object (for fluent API support)
     */
    public function setShopId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->shop_id !== $v) {
            $this->shop_id = $v;
            $this->modifiedColumns[OrderTableMap::COL_SHOP_ID] = true;
        }

        if ($this->aShop !== null && $this->aShop->getId() !== $v) {
            $this->aShop = null;
        }

        return $this;
    } // setShopId()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
            if ($this->discount_summ !== '0.00') {
                return false;
            }

            if ($this->reload !== 'N') {
                return false;
            }

        // otherwise, everything was equal, so return TRUE
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array   $row       The row returned by DataFetcher->fetch().
     * @param int     $startcol  0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @param string  $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                  One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                            TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false, $indexType = TableMap::TYPE_NUM)
    {
        try {

            $col = $row[TableMap::TYPE_NUM == $indexType ? 0 + $startcol : OrderTableMap::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
            $this->id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 1 + $startcol : OrderTableMap::translateFieldName('CustomerId', TableMap::TYPE_PHPNAME, $indexType)];
            $this->customer_id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 2 + $startcol : OrderTableMap::translateFieldName('Datetime', TableMap::TYPE_PHPNAME, $indexType)];
            if ($col === '0000-00-00 00:00:00') {
                $col = null;
            }
            $this->datetime = (null !== $col) ? PropelDateTime::newInstance($col, null, 'DateTime') : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 3 + $startcol : OrderTableMap::translateFieldName('UDatetime', TableMap::TYPE_PHPNAME, $indexType)];
            if ($col === '0000-00-00 00:00:00') {
                $col = null;
            }
            $this->udatetime = (null !== $col) ? PropelDateTime::newInstance($col, null, 'DateTime') : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 4 + $startcol : OrderTableMap::translateFieldName('DiscountSumm', TableMap::TYPE_PHPNAME, $indexType)];
            $this->discount_summ = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 5 + $startcol : OrderTableMap::translateFieldName('Reload', TableMap::TYPE_PHPNAME, $indexType)];
            $this->reload = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 6 + $startcol : OrderTableMap::translateFieldName('DeliveryAddress', TableMap::TYPE_PHPNAME, $indexType)];
            $this->delivery_address = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 7 + $startcol : OrderTableMap::translateFieldName('PaymentId', TableMap::TYPE_PHPNAME, $indexType)];
            $this->payment_id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 8 + $startcol : OrderTableMap::translateFieldName('StateId', TableMap::TYPE_PHPNAME, $indexType)];
            $this->state_id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 9 + $startcol : OrderTableMap::translateFieldName('Comment', TableMap::TYPE_PHPNAME, $indexType)];
            $this->comment = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 10 + $startcol : OrderTableMap::translateFieldName('PostCode', TableMap::TYPE_PHPNAME, $indexType)];
            $this->post_code = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 11 + $startcol : OrderTableMap::translateFieldName('ShopId', TableMap::TYPE_PHPNAME, $indexType)];
            $this->shop_id = (null !== $col) ? (int) $col : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 12; // 12 = OrderTableMap::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException(sprintf('Error populating %s object', '\\Shop\\Models\\Order\\Order'), 0, $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {
        if ($this->aCustomer !== null && $this->customer_id !== $this->aCustomer->getId()) {
            $this->aCustomer = null;
        }
        if ($this->aPayment !== null && $this->payment_id !== $this->aPayment->getId()) {
            $this->aPayment = null;
        }
        if ($this->aState !== null && $this->state_id !== $this->aState->getId()) {
            $this->aState = null;
        }
        if ($this->aShop !== null && $this->shop_id !== $this->aShop->getId()) {
            $this->aShop = null;
        }
    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param      boolean $deep (optional) Whether to also de-associated any related objects.
     * @param      ConnectionInterface $con (optional) The ConnectionInterface connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, ConnectionInterface $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(OrderTableMap::DATABASE_NAME);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $dataFetcher = ChildOrderQuery::create(null, $this->buildPkeyCriteria())->setFormatter(ModelCriteria::FORMAT_STATEMENT)->find($con);
        $row = $dataFetcher->fetch();
        $dataFetcher->close();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true, $dataFetcher->getIndexType()); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->aCustomer = null;
            $this->aPayment = null;
            $this->aState = null;
            $this->aShop = null;
            $this->collPaymentTransactions = null;

            $this->collOrderItems = null;

        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param      ConnectionInterface $con
     * @return void
     * @throws PropelException
     * @see Order::setDeleted()
     * @see Order::isDeleted()
     */
    public function delete(ConnectionInterface $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(OrderTableMap::DATABASE_NAME);
        }

        $con->transaction(function () use ($con) {
            $deleteQuery = ChildOrderQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $this->setDeleted(true);
            }
        });
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param      ConnectionInterface $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see doSave()
     */
    public function save(ConnectionInterface $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($this->alreadyInSave) {
            return 0;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(OrderTableMap::DATABASE_NAME);
        }

        return $con->transaction(function () use ($con) {
            $ret = $this->preSave($con);
            $isInsert = $this->isNew();
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                OrderTableMap::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }

            return $affectedRows;
        });
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param      ConnectionInterface $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see save()
     */
    protected function doSave(ConnectionInterface $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            // We call the save method on the following object(s) if they
            // were passed to this object by their corresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aCustomer !== null) {
                if ($this->aCustomer->isModified() || $this->aCustomer->isNew()) {
                    $affectedRows += $this->aCustomer->save($con);
                }
                $this->setCustomer($this->aCustomer);
            }

            if ($this->aPayment !== null) {
                if ($this->aPayment->isModified() || $this->aPayment->isNew()) {
                    $affectedRows += $this->aPayment->save($con);
                }
                $this->setPayment($this->aPayment);
            }

            if ($this->aState !== null) {
                if ($this->aState->isModified() || $this->aState->isNew()) {
                    $affectedRows += $this->aState->save($con);
                }
                $this->setState($this->aState);
            }

            if ($this->aShop !== null) {
                if ($this->aShop->isModified() || $this->aShop->isNew()) {
                    $affectedRows += $this->aShop->save($con);
                }
                $this->setShop($this->aShop);
            }

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                    $affectedRows += 1;
                } else {
                    $affectedRows += $this->doUpdate($con);
                }
                $this->resetModified();
            }

            if ($this->paymentTransactionsScheduledForDeletion !== null) {
                if (!$this->paymentTransactionsScheduledForDeletion->isEmpty()) {
                    foreach ($this->paymentTransactionsScheduledForDeletion as $paymentTransaction) {
                        // need to save related object because we set the relation to null
                        $paymentTransaction->save($con);
                    }
                    $this->paymentTransactionsScheduledForDeletion = null;
                }
            }

            if ($this->collPaymentTransactions !== null) {
                foreach ($this->collPaymentTransactions as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->orderItemsScheduledForDeletion !== null) {
                if (!$this->orderItemsScheduledForDeletion->isEmpty()) {
                    \Shop\Models\OrderItem\OrderItemQuery::create()
                        ->filterByPrimaryKeys($this->orderItemsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->orderItemsScheduledForDeletion = null;
                }
            }

            if ($this->collOrderItems !== null) {
                foreach ($this->collOrderItems as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param      ConnectionInterface $con
     *
     * @throws PropelException
     * @see doSave()
     */
    protected function doInsert(ConnectionInterface $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[OrderTableMap::COL_ID] = true;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . OrderTableMap::COL_ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(OrderTableMap::COL_ID)) {
            $modifiedColumns[':p' . $index++]  = '`id`';
        }
        if ($this->isColumnModified(OrderTableMap::COL_CUSTOMER_ID)) {
            $modifiedColumns[':p' . $index++]  = '`customer_id`';
        }
        if ($this->isColumnModified(OrderTableMap::COL_DATETIME)) {
            $modifiedColumns[':p' . $index++]  = '`datetime`';
        }
        if ($this->isColumnModified(OrderTableMap::COL_UDATETIME)) {
            $modifiedColumns[':p' . $index++]  = '`udatetime`';
        }
        if ($this->isColumnModified(OrderTableMap::COL_DISCOUNT_SUMM)) {
            $modifiedColumns[':p' . $index++]  = '`discount_summ`';
        }
        if ($this->isColumnModified(OrderTableMap::COL_RELOAD)) {
            $modifiedColumns[':p' . $index++]  = '`reload`';
        }
        if ($this->isColumnModified(OrderTableMap::COL_DELIVERY_ADDRESS)) {
            $modifiedColumns[':p' . $index++]  = '`delivery_address`';
        }
        if ($this->isColumnModified(OrderTableMap::COL_PAYMENT_ID)) {
            $modifiedColumns[':p' . $index++]  = '`payment_id`';
        }
        if ($this->isColumnModified(OrderTableMap::COL_STATE_ID)) {
            $modifiedColumns[':p' . $index++]  = '`state_id`';
        }
        if ($this->isColumnModified(OrderTableMap::COL_COMMENT)) {
            $modifiedColumns[':p' . $index++]  = '`comment`';
        }
        if ($this->isColumnModified(OrderTableMap::COL_POST_CODE)) {
            $modifiedColumns[':p' . $index++]  = '`post_code`';
        }
        if ($this->isColumnModified(OrderTableMap::COL_SHOP_ID)) {
            $modifiedColumns[':p' . $index++]  = '`shop_id`';
        }

        $sql = sprintf(
            'INSERT INTO `shop_orders` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`id`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`customer_id`':
                        $stmt->bindValue($identifier, $this->customer_id, PDO::PARAM_INT);
                        break;
                    case '`datetime`':
                        $stmt->bindValue($identifier, $this->datetime ? $this->datetime->format("Y-m-d H:i:s.u") : null, PDO::PARAM_STR);
                        break;
                    case '`udatetime`':
                        $stmt->bindValue($identifier, $this->udatetime ? $this->udatetime->format("Y-m-d H:i:s.u") : null, PDO::PARAM_STR);
                        break;
                    case '`discount_summ`':
                        $stmt->bindValue($identifier, $this->discount_summ, PDO::PARAM_STR);
                        break;
                    case '`reload`':
                        $stmt->bindValue($identifier, $this->reload, PDO::PARAM_STR);
                        break;
                    case '`delivery_address`':
                        $stmt->bindValue($identifier, $this->delivery_address, PDO::PARAM_STR);
                        break;
                    case '`payment_id`':
                        $stmt->bindValue($identifier, $this->payment_id, PDO::PARAM_INT);
                        break;
                    case '`state_id`':
                        $stmt->bindValue($identifier, $this->state_id, PDO::PARAM_INT);
                        break;
                    case '`comment`':
                        $stmt->bindValue($identifier, $this->comment, PDO::PARAM_STR);
                        break;
                    case '`post_code`':
                        $stmt->bindValue($identifier, $this->post_code, PDO::PARAM_STR);
                        break;
                    case '`shop_id`':
                        $stmt->bindValue($identifier, $this->shop_id, PDO::PARAM_INT);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), 0, $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', 0, $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param      ConnectionInterface $con
     *
     * @return Integer Number of updated rows
     * @see doSave()
     */
    protected function doUpdate(ConnectionInterface $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();

        return $selectCriteria->doUpdate($valuesCriteria, $con);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param      string $name name
     * @param      string $type The type of fieldname the $name is of:
     *                     one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                     TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                     Defaults to TableMap::TYPE_PHPNAME.
     * @return mixed Value of field.
     */
    public function getByName($name, $type = TableMap::TYPE_PHPNAME)
    {
        $pos = OrderTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param      int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getCustomerId();
                break;
            case 2:
                return $this->getDatetime();
                break;
            case 3:
                return $this->getUDatetime();
                break;
            case 4:
                return $this->getDiscountSumm();
                break;
            case 5:
                return $this->getReload();
                break;
            case 6:
                return $this->getDeliveryAddress();
                break;
            case 7:
                return $this->getPaymentId();
                break;
            case 8:
                return $this->getStateId();
                break;
            case 9:
                return $this->getComment();
                break;
            case 10:
                return $this->getPostCode();
                break;
            case 11:
                return $this->getShopId();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     *                    TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                    Defaults to TableMap::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to TRUE.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = TableMap::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {

        if (isset($alreadyDumpedObjects['Order'][$this->hashCode()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['Order'][$this->hashCode()] = true;
        $keys = OrderTableMap::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getCustomerId(),
            $keys[2] => $this->getDatetime(),
            $keys[3] => $this->getUDatetime(),
            $keys[4] => $this->getDiscountSumm(),
            $keys[5] => $this->getReload(),
            $keys[6] => $this->getDeliveryAddress(),
            $keys[7] => $this->getPaymentId(),
            $keys[8] => $this->getStateId(),
            $keys[9] => $this->getComment(),
            $keys[10] => $this->getPostCode(),
            $keys[11] => $this->getShopId(),
        );
        if ($result[$keys[2]] instanceof \DateTimeInterface) {
            $result[$keys[2]] = $result[$keys[2]]->format('c');
        }

        if ($result[$keys[3]] instanceof \DateTimeInterface) {
            $result[$keys[3]] = $result[$keys[3]]->format('c');
        }

        $virtualColumns = $this->virtualColumns;
        foreach ($virtualColumns as $key => $virtualColumn) {
            $result[$key] = $virtualColumn;
        }

        if ($includeForeignObjects) {
            if (null !== $this->aCustomer) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'customer';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_customer';
                        break;
                    default:
                        $key = 'Customer';
                }

                $result[$key] = $this->aCustomer->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aPayment) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'payment';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_payments';
                        break;
                    default:
                        $key = 'Payment';
                }

                $result[$key] = $this->aPayment->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aState) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'state';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_states';
                        break;
                    default:
                        $key = 'State';
                }

                $result[$key] = $this->aState->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aShop) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'shop';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_shops';
                        break;
                    default:
                        $key = 'Shop';
                }

                $result[$key] = $this->aShop->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->collPaymentTransactions) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'paymentTransactions';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_payment_transactionss';
                        break;
                    default:
                        $key = 'PaymentTransactions';
                }

                $result[$key] = $this->collPaymentTransactions->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collOrderItems) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'orderItems';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_order_itemss';
                        break;
                    default:
                        $key = 'OrderItems';
                }

                $result[$key] = $this->collOrderItems->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param  string $name
     * @param  mixed  $value field value
     * @param  string $type The type of fieldname the $name is of:
     *                one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                Defaults to TableMap::TYPE_PHPNAME.
     * @return $this|\Shop\Models\Order\Order
     */
    public function setByName($name, $value, $type = TableMap::TYPE_PHPNAME)
    {
        $pos = OrderTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);

        return $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param  int $pos position in xml schema
     * @param  mixed $value field value
     * @return $this|\Shop\Models\Order\Order
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setCustomerId($value);
                break;
            case 2:
                $this->setDatetime($value);
                break;
            case 3:
                $this->setUDatetime($value);
                break;
            case 4:
                $this->setDiscountSumm($value);
                break;
            case 5:
                $this->setReload($value);
                break;
            case 6:
                $this->setDeliveryAddress($value);
                break;
            case 7:
                $this->setPaymentId($value);
                break;
            case 8:
                $this->setStateId($value);
                break;
            case 9:
                $this->setComment($value);
                break;
            case 10:
                $this->setPostCode($value);
                break;
            case 11:
                $this->setShopId($value);
                break;
        } // switch()

        return $this;
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param      array  $arr     An array to populate the object from.
     * @param      string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = TableMap::TYPE_PHPNAME)
    {
        $keys = OrderTableMap::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) {
            $this->setId($arr[$keys[0]]);
        }
        if (array_key_exists($keys[1], $arr)) {
            $this->setCustomerId($arr[$keys[1]]);
        }
        if (array_key_exists($keys[2], $arr)) {
            $this->setDatetime($arr[$keys[2]]);
        }
        if (array_key_exists($keys[3], $arr)) {
            $this->setUDatetime($arr[$keys[3]]);
        }
        if (array_key_exists($keys[4], $arr)) {
            $this->setDiscountSumm($arr[$keys[4]]);
        }
        if (array_key_exists($keys[5], $arr)) {
            $this->setReload($arr[$keys[5]]);
        }
        if (array_key_exists($keys[6], $arr)) {
            $this->setDeliveryAddress($arr[$keys[6]]);
        }
        if (array_key_exists($keys[7], $arr)) {
            $this->setPaymentId($arr[$keys[7]]);
        }
        if (array_key_exists($keys[8], $arr)) {
            $this->setStateId($arr[$keys[8]]);
        }
        if (array_key_exists($keys[9], $arr)) {
            $this->setComment($arr[$keys[9]]);
        }
        if (array_key_exists($keys[10], $arr)) {
            $this->setPostCode($arr[$keys[10]]);
        }
        if (array_key_exists($keys[11], $arr)) {
            $this->setShopId($arr[$keys[11]]);
        }
    }

     /**
     * Populate the current object from a string, using a given parser format
     * <code>
     * $book = new Book();
     * $book->importFrom('JSON', '{"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param mixed $parser A AbstractParser instance,
     *                       or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param string $data The source data to import from
     * @param string $keyType The type of keys the array uses.
     *
     * @return $this|\Shop\Models\Order\Order The current object, for fluid interface
     */
    public function importFrom($parser, $data, $keyType = TableMap::TYPE_PHPNAME)
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        $this->fromArray($parser->toArray($data), $keyType);

        return $this;
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(OrderTableMap::DATABASE_NAME);

        if ($this->isColumnModified(OrderTableMap::COL_ID)) {
            $criteria->add(OrderTableMap::COL_ID, $this->id);
        }
        if ($this->isColumnModified(OrderTableMap::COL_CUSTOMER_ID)) {
            $criteria->add(OrderTableMap::COL_CUSTOMER_ID, $this->customer_id);
        }
        if ($this->isColumnModified(OrderTableMap::COL_DATETIME)) {
            $criteria->add(OrderTableMap::COL_DATETIME, $this->datetime);
        }
        if ($this->isColumnModified(OrderTableMap::COL_UDATETIME)) {
            $criteria->add(OrderTableMap::COL_UDATETIME, $this->udatetime);
        }
        if ($this->isColumnModified(OrderTableMap::COL_DISCOUNT_SUMM)) {
            $criteria->add(OrderTableMap::COL_DISCOUNT_SUMM, $this->discount_summ);
        }
        if ($this->isColumnModified(OrderTableMap::COL_RELOAD)) {
            $criteria->add(OrderTableMap::COL_RELOAD, $this->reload);
        }
        if ($this->isColumnModified(OrderTableMap::COL_DELIVERY_ADDRESS)) {
            $criteria->add(OrderTableMap::COL_DELIVERY_ADDRESS, $this->delivery_address);
        }
        if ($this->isColumnModified(OrderTableMap::COL_PAYMENT_ID)) {
            $criteria->add(OrderTableMap::COL_PAYMENT_ID, $this->payment_id);
        }
        if ($this->isColumnModified(OrderTableMap::COL_STATE_ID)) {
            $criteria->add(OrderTableMap::COL_STATE_ID, $this->state_id);
        }
        if ($this->isColumnModified(OrderTableMap::COL_COMMENT)) {
            $criteria->add(OrderTableMap::COL_COMMENT, $this->comment);
        }
        if ($this->isColumnModified(OrderTableMap::COL_POST_CODE)) {
            $criteria->add(OrderTableMap::COL_POST_CODE, $this->post_code);
        }
        if ($this->isColumnModified(OrderTableMap::COL_SHOP_ID)) {
            $criteria->add(OrderTableMap::COL_SHOP_ID, $this->shop_id);
        }

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @throws LogicException if no primary key is defined
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = ChildOrderQuery::create();
        $criteria->add(OrderTableMap::COL_ID, $this->id);

        return $criteria;
    }

    /**
     * If the primary key is not null, return the hashcode of the
     * primary key. Otherwise, return the hash code of the object.
     *
     * @return int Hashcode
     */
    public function hashCode()
    {
        $validPk = null !== $this->getId();

        $validPrimaryKeyFKs = 0;
        $primaryKeyFKs = [];

        if ($validPk) {
            return crc32(json_encode($this->getPrimaryKey(), JSON_UNESCAPED_UNICODE));
        } elseif ($validPrimaryKeyFKs) {
            return crc32(json_encode($primaryKeyFKs, JSON_UNESCAPED_UNICODE));
        }

        return spl_object_hash($this);
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param       int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {
        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param      object $copyObj An object of \Shop\Models\Order\Order (or compatible) type.
     * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param      boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setCustomerId($this->getCustomerId());
        $copyObj->setDatetime($this->getDatetime());
        $copyObj->setUDatetime($this->getUDatetime());
        $copyObj->setDiscountSumm($this->getDiscountSumm());
        $copyObj->setReload($this->getReload());
        $copyObj->setDeliveryAddress($this->getDeliveryAddress());
        $copyObj->setPaymentId($this->getPaymentId());
        $copyObj->setStateId($this->getStateId());
        $copyObj->setComment($this->getComment());
        $copyObj->setPostCode($this->getPostCode());
        $copyObj->setShopId($this->getShopId());

        if ($deepCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);

            foreach ($this->getPaymentTransactions() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addPaymentTransaction($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getOrderItems() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addOrderItem($relObj->copy($deepCopy));
                }
            }

        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param  boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return \Shop\Models\Order\Order Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Declares an association between this object and a Customer object.
     *
     * @param  Customer $v
     * @return $this|\Shop\Models\Order\Order The current object (for fluent API support)
     * @throws PropelException
     */
    public function setCustomer(Customer $v = null)
    {
        if ($v === null) {
            $this->setCustomerId(NULL);
        } else {
            $this->setCustomerId($v->getId());
        }

        $this->aCustomer = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Customer object, it will not be re-added.
        if ($v !== null) {
            $v->addOrder($this);
        }


        return $this;
    }


    /**
     * Get the associated Customer object
     *
     * @param  ConnectionInterface $con Optional Connection object.
     * @return Customer The associated Customer object.
     * @throws PropelException
     */
    public function getCustomer(ConnectionInterface $con = null)
    {
        if ($this->aCustomer === null && ($this->customer_id != 0)) {
            $this->aCustomer = CustomerQuery::create()->findPk($this->customer_id, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aCustomer->addOrders($this);
             */
        }

        return $this->aCustomer;
    }

    /**
     * Declares an association between this object and a Payment object.
     *
     * @param  Payment $v
     * @return $this|\Shop\Models\Order\Order The current object (for fluent API support)
     * @throws PropelException
     */
    public function setPayment(Payment $v = null)
    {
        if ($v === null) {
            $this->setPaymentId(NULL);
        } else {
            $this->setPaymentId($v->getId());
        }

        $this->aPayment = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Payment object, it will not be re-added.
        if ($v !== null) {
            $v->addOrder($this);
        }


        return $this;
    }


    /**
     * Get the associated Payment object
     *
     * @param  ConnectionInterface $con Optional Connection object.
     * @return Payment The associated Payment object.
     * @throws PropelException
     */
    public function getPayment(ConnectionInterface $con = null)
    {
        if ($this->aPayment === null && ($this->payment_id != 0)) {
            $this->aPayment = PaymentQuery::create()->findPk($this->payment_id, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aPayment->addOrders($this);
             */
        }

        return $this->aPayment;
    }

    /**
     * Declares an association between this object and a State object.
     *
     * @param  State $v
     * @return $this|\Shop\Models\Order\Order The current object (for fluent API support)
     * @throws PropelException
     */
    public function setState(State $v = null)
    {
        if ($v === null) {
            $this->setStateId(NULL);
        } else {
            $this->setStateId($v->getId());
        }

        $this->aState = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the State object, it will not be re-added.
        if ($v !== null) {
            $v->addOrder($this);
        }


        return $this;
    }


    /**
     * Get the associated State object
     *
     * @param  ConnectionInterface $con Optional Connection object.
     * @return State The associated State object.
     * @throws PropelException
     */
    public function getState(ConnectionInterface $con = null)
    {
        if ($this->aState === null && ($this->state_id != 0)) {
            $this->aState = StateQuery::create()->findPk($this->state_id, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aState->addOrders($this);
             */
        }

        return $this->aState;
    }

    /**
     * Declares an association between this object and a Shop object.
     *
     * @param  Shop $v
     * @return $this|\Shop\Models\Order\Order The current object (for fluent API support)
     * @throws PropelException
     */
    public function setShop(Shop $v = null)
    {
        if ($v === null) {
            $this->setShopId(NULL);
        } else {
            $this->setShopId($v->getId());
        }

        $this->aShop = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Shop object, it will not be re-added.
        if ($v !== null) {
            $v->addOrder($this);
        }


        return $this;
    }


    /**
     * Get the associated Shop object
     *
     * @param  ConnectionInterface $con Optional Connection object.
     * @return Shop The associated Shop object.
     * @throws PropelException
     */
    public function getShop(ConnectionInterface $con = null)
    {
        if ($this->aShop === null && ($this->shop_id != 0)) {
            $this->aShop = ShopQuery::create()->findPk($this->shop_id, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aShop->addOrders($this);
             */
        }

        return $this->aShop;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param      string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName)
    {
        if ('PaymentTransaction' == $relationName) {
            $this->initPaymentTransactions();
            return;
        }
        if ('OrderItem' == $relationName) {
            $this->initOrderItems();
            return;
        }
    }

    /**
     * Clears out the collPaymentTransactions collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addPaymentTransactions()
     */
    public function clearPaymentTransactions()
    {
        $this->collPaymentTransactions = null; // important to set this to NULL since that means it is uninitialized
    }

    /**
     * Reset is the collPaymentTransactions collection loaded partially.
     */
    public function resetPartialPaymentTransactions($v = true)
    {
        $this->collPaymentTransactionsPartial = $v;
    }

    /**
     * Initializes the collPaymentTransactions collection.
     *
     * By default this just sets the collPaymentTransactions collection to an empty array (like clearcollPaymentTransactions());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param      boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initPaymentTransactions($overrideExisting = true)
    {
        if (null !== $this->collPaymentTransactions && !$overrideExisting) {
            return;
        }

        $collectionClassName = PaymentTransactionTableMap::getTableMap()->getCollectionClassName();

        $this->collPaymentTransactions = new $collectionClassName;
        $this->collPaymentTransactions->setModel('\Shop\Models\PaymentTransaction\PaymentTransaction');
    }

    /**
     * Gets an array of PaymentTransaction objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildOrder is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @return ObjectCollection|PaymentTransaction[] List of PaymentTransaction objects
     * @throws PropelException
     */
    public function getPaymentTransactions(Criteria $criteria = null, ConnectionInterface $con = null)
    {
        $partial = $this->collPaymentTransactionsPartial && !$this->isNew();
        if (null === $this->collPaymentTransactions || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collPaymentTransactions) {
                // return empty collection
                $this->initPaymentTransactions();
            } else {
                $collPaymentTransactions = PaymentTransactionQuery::create(null, $criteria)
                    ->filterByOrder($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collPaymentTransactionsPartial && count($collPaymentTransactions)) {
                        $this->initPaymentTransactions(false);

                        foreach ($collPaymentTransactions as $obj) {
                            if (false == $this->collPaymentTransactions->contains($obj)) {
                                $this->collPaymentTransactions->append($obj);
                            }
                        }

                        $this->collPaymentTransactionsPartial = true;
                    }

                    return $collPaymentTransactions;
                }

                if ($partial && $this->collPaymentTransactions) {
                    foreach ($this->collPaymentTransactions as $obj) {
                        if ($obj->isNew()) {
                            $collPaymentTransactions[] = $obj;
                        }
                    }
                }

                $this->collPaymentTransactions = $collPaymentTransactions;
                $this->collPaymentTransactionsPartial = false;
            }
        }

        return $this->collPaymentTransactions;
    }

    /**
     * Sets a collection of PaymentTransaction objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param      Collection $paymentTransactions A Propel collection.
     * @param      ConnectionInterface $con Optional connection object
     * @return $this|ChildOrder The current object (for fluent API support)
     */
    public function setPaymentTransactions(Collection $paymentTransactions, ConnectionInterface $con = null)
    {
        /** @var PaymentTransaction[] $paymentTransactionsToDelete */
        $paymentTransactionsToDelete = $this->getPaymentTransactions(new Criteria(), $con)->diff($paymentTransactions);


        $this->paymentTransactionsScheduledForDeletion = $paymentTransactionsToDelete;

        foreach ($paymentTransactionsToDelete as $paymentTransactionRemoved) {
            $paymentTransactionRemoved->setOrder(null);
        }

        $this->collPaymentTransactions = null;
        foreach ($paymentTransactions as $paymentTransaction) {
            $this->addPaymentTransaction($paymentTransaction);
        }

        $this->collPaymentTransactions = $paymentTransactions;
        $this->collPaymentTransactionsPartial = false;

        return $this;
    }

    /**
     * Returns the number of related BasePaymentTransaction objects.
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct
     * @param      ConnectionInterface $con
     * @return int             Count of related BasePaymentTransaction objects.
     * @throws PropelException
     */
    public function countPaymentTransactions(Criteria $criteria = null, $distinct = false, ConnectionInterface $con = null)
    {
        $partial = $this->collPaymentTransactionsPartial && !$this->isNew();
        if (null === $this->collPaymentTransactions || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collPaymentTransactions) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getPaymentTransactions());
            }

            $query = PaymentTransactionQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByOrder($this)
                ->count($con);
        }

        return count($this->collPaymentTransactions);
    }

    /**
     * Method called to associate a PaymentTransaction object to this object
     * through the PaymentTransaction foreign key attribute.
     *
     * @param  PaymentTransaction $l PaymentTransaction
     * @return $this|\Shop\Models\Order\Order The current object (for fluent API support)
     */
    public function addPaymentTransaction(PaymentTransaction $l)
    {
        if ($this->collPaymentTransactions === null) {
            $this->initPaymentTransactions();
            $this->collPaymentTransactionsPartial = true;
        }

        if (!$this->collPaymentTransactions->contains($l)) {
            $this->doAddPaymentTransaction($l);

            if ($this->paymentTransactionsScheduledForDeletion and $this->paymentTransactionsScheduledForDeletion->contains($l)) {
                $this->paymentTransactionsScheduledForDeletion->remove($this->paymentTransactionsScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param PaymentTransaction $paymentTransaction The PaymentTransaction object to add.
     */
    protected function doAddPaymentTransaction(PaymentTransaction $paymentTransaction)
    {
        $this->collPaymentTransactions[]= $paymentTransaction;
        $paymentTransaction->setOrder($this);
    }

    /**
     * @param  PaymentTransaction $paymentTransaction The PaymentTransaction object to remove.
     * @return $this|ChildOrder The current object (for fluent API support)
     */
    public function removePaymentTransaction(PaymentTransaction $paymentTransaction)
    {
        if ($this->getPaymentTransactions()->contains($paymentTransaction)) {
            $pos = $this->collPaymentTransactions->search($paymentTransaction);
            $this->collPaymentTransactions->remove($pos);
            if (null === $this->paymentTransactionsScheduledForDeletion) {
                $this->paymentTransactionsScheduledForDeletion = clone $this->collPaymentTransactions;
                $this->paymentTransactionsScheduledForDeletion->clear();
            }
            $this->paymentTransactionsScheduledForDeletion[]= $paymentTransaction;
            $paymentTransaction->setOrder(null);
        }

        return $this;
    }

    /**
     * Clears out the collOrderItems collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addOrderItems()
     */
    public function clearOrderItems()
    {
        $this->collOrderItems = null; // important to set this to NULL since that means it is uninitialized
    }

    /**
     * Reset is the collOrderItems collection loaded partially.
     */
    public function resetPartialOrderItems($v = true)
    {
        $this->collOrderItemsPartial = $v;
    }

    /**
     * Initializes the collOrderItems collection.
     *
     * By default this just sets the collOrderItems collection to an empty array (like clearcollOrderItems());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param      boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initOrderItems($overrideExisting = true)
    {
        if (null !== $this->collOrderItems && !$overrideExisting) {
            return;
        }

        $collectionClassName = OrderItemTableMap::getTableMap()->getCollectionClassName();

        $this->collOrderItems = new $collectionClassName;
        $this->collOrderItems->setModel('\Shop\Models\OrderItem\OrderItem');
    }

    /**
     * Gets an array of OrderItem objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildOrder is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @return ObjectCollection|OrderItem[] List of OrderItem objects
     * @throws PropelException
     */
    public function getOrderItems(Criteria $criteria = null, ConnectionInterface $con = null)
    {
        $partial = $this->collOrderItemsPartial && !$this->isNew();
        if (null === $this->collOrderItems || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collOrderItems) {
                // return empty collection
                $this->initOrderItems();
            } else {
                $collOrderItems = OrderItemQuery::create(null, $criteria)
                    ->filterByOrder($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collOrderItemsPartial && count($collOrderItems)) {
                        $this->initOrderItems(false);

                        foreach ($collOrderItems as $obj) {
                            if (false == $this->collOrderItems->contains($obj)) {
                                $this->collOrderItems->append($obj);
                            }
                        }

                        $this->collOrderItemsPartial = true;
                    }

                    return $collOrderItems;
                }

                if ($partial && $this->collOrderItems) {
                    foreach ($this->collOrderItems as $obj) {
                        if ($obj->isNew()) {
                            $collOrderItems[] = $obj;
                        }
                    }
                }

                $this->collOrderItems = $collOrderItems;
                $this->collOrderItemsPartial = false;
            }
        }

        return $this->collOrderItems;
    }

    /**
     * Sets a collection of OrderItem objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param      Collection $orderItems A Propel collection.
     * @param      ConnectionInterface $con Optional connection object
     * @return $this|ChildOrder The current object (for fluent API support)
     */
    public function setOrderItems(Collection $orderItems, ConnectionInterface $con = null)
    {
        /** @var OrderItem[] $orderItemsToDelete */
        $orderItemsToDelete = $this->getOrderItems(new Criteria(), $con)->diff($orderItems);


        $this->orderItemsScheduledForDeletion = $orderItemsToDelete;

        foreach ($orderItemsToDelete as $orderItemRemoved) {
            $orderItemRemoved->setOrder(null);
        }

        $this->collOrderItems = null;
        foreach ($orderItems as $orderItem) {
            $this->addOrderItem($orderItem);
        }

        $this->collOrderItems = $orderItems;
        $this->collOrderItemsPartial = false;

        return $this;
    }

    /**
     * Returns the number of related BaseOrderItem objects.
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct
     * @param      ConnectionInterface $con
     * @return int             Count of related BaseOrderItem objects.
     * @throws PropelException
     */
    public function countOrderItems(Criteria $criteria = null, $distinct = false, ConnectionInterface $con = null)
    {
        $partial = $this->collOrderItemsPartial && !$this->isNew();
        if (null === $this->collOrderItems || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collOrderItems) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getOrderItems());
            }

            $query = OrderItemQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByOrder($this)
                ->count($con);
        }

        return count($this->collOrderItems);
    }

    /**
     * Method called to associate a OrderItem object to this object
     * through the OrderItem foreign key attribute.
     *
     * @param  OrderItem $l OrderItem
     * @return $this|\Shop\Models\Order\Order The current object (for fluent API support)
     */
    public function addOrderItem(OrderItem $l)
    {
        if ($this->collOrderItems === null) {
            $this->initOrderItems();
            $this->collOrderItemsPartial = true;
        }

        if (!$this->collOrderItems->contains($l)) {
            $this->doAddOrderItem($l);

            if ($this->orderItemsScheduledForDeletion and $this->orderItemsScheduledForDeletion->contains($l)) {
                $this->orderItemsScheduledForDeletion->remove($this->orderItemsScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param OrderItem $orderItem The OrderItem object to add.
     */
    protected function doAddOrderItem(OrderItem $orderItem)
    {
        $this->collOrderItems[]= $orderItem;
        $orderItem->setOrder($this);
    }

    /**
     * @param  OrderItem $orderItem The OrderItem object to remove.
     * @return $this|ChildOrder The current object (for fluent API support)
     */
    public function removeOrderItem(OrderItem $orderItem)
    {
        if ($this->getOrderItems()->contains($orderItem)) {
            $pos = $this->collOrderItems->search($orderItem);
            $this->collOrderItems->remove($pos);
            if (null === $this->orderItemsScheduledForDeletion) {
                $this->orderItemsScheduledForDeletion = clone $this->collOrderItems;
                $this->orderItemsScheduledForDeletion->clear();
            }
            $this->orderItemsScheduledForDeletion[]= clone $orderItem;
            $orderItem->setOrder(null);
        }

        return $this;
    }

    /**
     * Clears the current object, sets all attributes to their default values and removes
     * outgoing references as well as back-references (from other objects to this one. Results probably in a database
     * change of those foreign objects when you call `save` there).
     */
    public function clear()
    {
        if (null !== $this->aCustomer) {
            $this->aCustomer->removeOrder($this);
        }
        if (null !== $this->aPayment) {
            $this->aPayment->removeOrder($this);
        }
        if (null !== $this->aState) {
            $this->aState->removeOrder($this);
        }
        if (null !== $this->aShop) {
            $this->aShop->removeOrder($this);
        }
        $this->id = null;
        $this->customer_id = null;
        $this->datetime = null;
        $this->udatetime = null;
        $this->discount_summ = null;
        $this->reload = null;
        $this->delivery_address = null;
        $this->payment_id = null;
        $this->state_id = null;
        $this->comment = null;
        $this->post_code = null;
        $this->shop_id = null;
        $this->alreadyInSave = false;
        $this->clearAllReferences();
        $this->applyDefaultValues();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references and back-references to other model objects or collections of model objects.
     *
     * This method is used to reset all php object references (not the actual reference in the database).
     * Necessary for object serialisation.
     *
     * @param      boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
            if ($this->collPaymentTransactions) {
                foreach ($this->collPaymentTransactions as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collOrderItems) {
                foreach ($this->collOrderItems as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        $this->collPaymentTransactions = null;
        $this->collOrderItems = null;
        $this->aCustomer = null;
        $this->aPayment = null;
        $this->aState = null;
        $this->aShop = null;
    }

    /**
     * Return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(OrderTableMap::DEFAULT_STRING_FORMAT);
    }

    /**
     * Code to be run before persisting the object
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preSave(ConnectionInterface $con = null)
    {
        if (is_callable('parent::preSave')) {
            return parent::preSave($con);
        }
        return true;
    }

    /**
     * Code to be run after persisting the object
     * @param ConnectionInterface $con
     */
    public function postSave(ConnectionInterface $con = null)
    {
        if (is_callable('parent::postSave')) {
            parent::postSave($con);
        }
    }

    /**
     * Code to be run before inserting to database
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preInsert(ConnectionInterface $con = null)
    {
        if (is_callable('parent::preInsert')) {
            return parent::preInsert($con);
        }
        return true;
    }

    /**
     * Code to be run after inserting to database
     * @param ConnectionInterface $con
     */
    public function postInsert(ConnectionInterface $con = null)
    {
        if (is_callable('parent::postInsert')) {
            parent::postInsert($con);
        }
    }

    /**
     * Code to be run before updating the object in database
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preUpdate(ConnectionInterface $con = null)
    {
        if (is_callable('parent::preUpdate')) {
            return parent::preUpdate($con);
        }
        return true;
    }

    /**
     * Code to be run after updating the object in database
     * @param ConnectionInterface $con
     */
    public function postUpdate(ConnectionInterface $con = null)
    {
        if (is_callable('parent::postUpdate')) {
            parent::postUpdate($con);
        }
    }

    /**
     * Code to be run before deleting the object in database
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preDelete(ConnectionInterface $con = null)
    {
        if (is_callable('parent::preDelete')) {
            return parent::preDelete($con);
        }
        return true;
    }

    /**
     * Code to be run after deleting the object in database
     * @param ConnectionInterface $con
     */
    public function postDelete(ConnectionInterface $con = null)
    {
        if (is_callable('parent::postDelete')) {
            parent::postDelete($con);
        }
    }


    /**
     * Derived method to catches calls to undefined methods.
     *
     * Provides magic import/export method support (fromXML()/toXML(), fromYAML()/toYAML(), etc.).
     * Allows to define default __call() behavior if you overwrite __call()
     *
     * @param string $name
     * @param mixed  $params
     *
     * @return array|string
     */
    public function __call($name, $params)
    {
        if (0 === strpos($name, 'get')) {
            $virtualColumn = substr($name, 3);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }

            $virtualColumn = lcfirst($virtualColumn);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }
        }

        if (0 === strpos($name, 'from')) {
            $format = substr($name, 4);

            return $this->importFrom($format, reset($params));
        }

        if (0 === strpos($name, 'to')) {
            $format = substr($name, 2);
            $includeLazyLoadColumns = isset($params[0]) ? $params[0] : true;

            return $this->exportTo($format, $includeLazyLoadColumns);
        }

        throw new BadMethodCallException(sprintf('Call to undefined method: %s.', $name));
    }

}
