<?php

namespace Shop\Models\Customer;

use Shop\Models\Customer\Base\Customer as BaseCustomer;

/**
 * Skeleton subclass for representing a row from the 'shop_customer' table.
 *
 *
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 */
class Customer extends BaseCustomer
{

    /**
     * Код созданный при регистрации
     * @var type 
     */
    protected $registerCode;
    
    /**
     * 
     * @return string
     */
    function getRegisterCode(): string {
        return $this->registerCode;
    }

    /**
     * 
     * @param string $registerCode
     * @return $this
     */
    function setRegisterCode(string $registerCode) {
        $this->registerCode = $registerCode;
        return $this;
    }
    
    /**
     * Разрешена ли отправка на email
     * @return bool
     */
    public function isNotifyEmail():bool{
        
        if(strpos($this->getNotifyType(), "email")!==false){
            return true;
        }
        
        return false;
    }
    
    /**
     * Разрешена ли отправка на sms
     * @return bool
     */
    public function isNotifySms():bool{
        
        if(strpos($this->getNotifyType(), "sms")!==false){
            return true;
        }
        
        return false;
    }    

}
