<?php

namespace Shop\Models\Customer\Base;

use \DateTime;
use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveRecord\ActiveRecordInterface;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\BadMethodCallException;
use Propel\Runtime\Exception\LogicException;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Parser\AbstractParser;
use Propel\Runtime\Util\PropelDateTime;
use Shop\Models\Basket\Basket;
use Shop\Models\Basket\BasketQuery;
use Shop\Models\City\City;
use Shop\Models\City\CityQuery;
use Shop\Models\Customer\Customer as ChildCustomer;
use Shop\Models\Customer\CustomerQuery as ChildCustomerQuery;
use Shop\Models\CustomerGroup\CustomerGroup;
use Shop\Models\CustomerGroup\CustomerGroupQuery;
use Shop\Models\Customer\Map\CustomerTableMap;
use Shop\Models\FastLink\FastLink;
use Shop\Models\FastLink\FastLinkQuery;
use Shop\Models\FastLink\Base\FastLink as BaseFastLink;
use Shop\Models\FastLink\Map\FastLinkTableMap;
use Shop\Models\Manager\Manager;
use Shop\Models\Manager\ManagerQuery;
use Shop\Models\Order\Order;
use Shop\Models\Order\OrderQuery;
use Shop\Models\Order\Base\Order as BaseOrder;
use Shop\Models\Order\Map\OrderTableMap;
use Shop\Models\SocialLogin\SocialLogin;
use Shop\Models\SocialLogin\SocialLoginQuery;

/**
 * Base class that represents a row from the 'shop_customer' table.
 *
 *
 *
 * @package    propel.generator.Models.Customer.Base
 */
abstract class Customer implements ActiveRecordInterface
{
    /**
     * TableMap class name
     */
    const TABLE_MAP = '\\Shop\\Models\\Customer\\Map\\CustomerTableMap';


    /**
     * attribute to determine if this object has previously been saved.
     * @var boolean
     */
    protected $new = true;

    /**
     * attribute to determine whether this object has been deleted.
     * @var boolean
     */
    protected $deleted = false;

    /**
     * The columns that have been modified in current object.
     * Tracking modified columns allows us to only update modified columns.
     * @var array
     */
    protected $modifiedColumns = array();

    /**
     * The (virtual) columns that are added at runtime
     * The formatters can add supplementary columns based on a resultset
     * @var array
     */
    protected $virtualColumns = array();

    /**
     * The value for the id field.
     *
     * @var        int
     */
    protected $id;

    /**
     * The value for the name field.
     *
     * @var        string
     */
    protected $name;

    /**
     * The value for the email field.
     *
     * @var        string
     */
    protected $email;

    /**
     * The value for the password field.
     *
     * @var        string
     */
    protected $password;

    /**
     * The value for the phone field.
     *
     * @var        string
     */
    protected $phone;

    /**
     * The value for the registred field.
     *
     * Note: this column has a database default value of: (expression) CURRENT_TIMESTAMP
     * @var        DateTime
     */
    protected $registred;

    /**
     * The value for the lastauth field.
     *
     * @var        DateTime
     */
    protected $lastauth;

    /**
     * The value for the blocked field.
     *
     * Note: this column has a database default value of: 'N'
     * @var        string
     */
    protected $blocked;

    /**
     * The value for the notify_type field.
     *
     * Note: this column has a database default value of: 'sms_email'
     * @var        string
     */
    protected $notify_type;

    /**
     * The value for the delete field.
     *
     * Note: this column has a database default value of: 0
     * @var        int
     */
    protected $delete;

    /**
     * The value for the discount field.
     *
     * Note: this column has a database default value of: '0.00'
     * @var        string
     */
    protected $discount;

    /**
     * The value for the inn field.
     *
     * @var        string
     */
    protected $inn;

    /**
     * The value for the info_hidden field.
     *
     * @var        string
     */
    protected $info_hidden;

    /**
     * The value for the group_id field.
     *
     * @var        int
     */
    protected $group_id;

    /**
     * The value for the city_id field.
     *
     * @var        int
     */
    protected $city_id;

    /**
     * The value for the manager_id field.
     *
     * @var        int
     */
    protected $manager_id;

    /**
     * The value for the notify_order field.
     *
     * Note: this column has a database default value of: 'Y'
     * @var        string
     */
    protected $notify_order;

    /**
     * The value for the notify_news field.
     *
     * Note: this column has a database default value of: 'Y'
     * @var        string
     */
    protected $notify_news;

    /**
     * The value for the notify_products field.
     *
     * Note: this column has a database default value of: 'Y'
     * @var        string
     */
    protected $notify_products;

    /**
     * @var        CustomerGroup
     */
    protected $aCustomerGroup;

    /**
     * @var        City
     */
    protected $aCustomerCity;

    /**
     * @var        Manager
     */
    protected $aManager;

    /**
     * @var        SocialLogin one-to-one related SocialLogin object
     */
    protected $singleSocialLogin;

    /**
     * @var        Basket one-to-one related Basket object
     */
    protected $singleBasket;

    /**
     * @var        ObjectCollection|Order[] Collection to store aggregation of Order objects.
     */
    protected $collOrders;
    protected $collOrdersPartial;

    /**
     * @var        ObjectCollection|FastLink[] Collection to store aggregation of FastLink objects.
     */
    protected $collFastLinksRelatedByOwnerCustomerId;
    protected $collFastLinksRelatedByOwnerCustomerIdPartial;

    /**
     * @var        FastLink one-to-one related FastLink object
     */
    protected $singleFastLinkRelatedByCode;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     *
     * @var boolean
     */
    protected $alreadyInSave = false;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|Order[]
     */
    protected $ordersScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|FastLink[]
     */
    protected $fastLinksRelatedByOwnerCustomerIdScheduledForDeletion = null;

    /**
     * Applies default values to this object.
     * This method should be called from the object's constructor (or
     * equivalent initialization method).
     * @see __construct()
     */
    public function applyDefaultValues()
    {
        $this->blocked = 'N';
        $this->notify_type = 'sms_email';
        $this->delete = 0;
        $this->discount = '0.00';
        $this->notify_order = 'Y';
        $this->notify_news = 'Y';
        $this->notify_products = 'Y';
    }

    /**
     * Initializes internal state of Shop\Models\Customer\Base\Customer object.
     * @see applyDefaults()
     */
    public function __construct()
    {
        $this->applyDefaultValues();
    }

    /**
     * Returns whether the object has been modified.
     *
     * @return boolean True if the object has been modified.
     */
    public function isModified()
    {
        return !!$this->modifiedColumns;
    }

    /**
     * Has specified column been modified?
     *
     * @param  string  $col column fully qualified name (TableMap::TYPE_COLNAME), e.g. Book::AUTHOR_ID
     * @return boolean True if $col has been modified.
     */
    public function isColumnModified($col)
    {
        return $this->modifiedColumns && isset($this->modifiedColumns[$col]);
    }

    /**
     * Get the columns that have been modified in this object.
     * @return array A unique list of the modified column names for this object.
     */
    public function getModifiedColumns()
    {
        return $this->modifiedColumns ? array_keys($this->modifiedColumns) : [];
    }

    /**
     * Returns whether the object has ever been saved.  This will
     * be false, if the object was retrieved from storage or was created
     * and then saved.
     *
     * @return boolean true, if the object has never been persisted.
     */
    public function isNew()
    {
        return $this->new;
    }

    /**
     * Setter for the isNew attribute.  This method will be called
     * by Propel-generated children and objects.
     *
     * @param boolean $b the state of the object.
     */
    public function setNew($b)
    {
        $this->new = (boolean) $b;
    }

    /**
     * Whether this object has been deleted.
     * @return boolean The deleted state of this object.
     */
    public function isDeleted()
    {
        return $this->deleted;
    }

    /**
     * Specify whether this object has been deleted.
     * @param  boolean $b The deleted state of this object.
     * @return void
     */
    public function setDeleted($b)
    {
        $this->deleted = (boolean) $b;
    }

    /**
     * Sets the modified state for the object to be false.
     * @param  string $col If supplied, only the specified column is reset.
     * @return void
     */
    public function resetModified($col = null)
    {
        if (null !== $col) {
            if (isset($this->modifiedColumns[$col])) {
                unset($this->modifiedColumns[$col]);
            }
        } else {
            $this->modifiedColumns = array();
        }
    }

    /**
     * Compares this with another <code>Customer</code> instance.  If
     * <code>obj</code> is an instance of <code>Customer</code>, delegates to
     * <code>equals(Customer)</code>.  Otherwise, returns <code>false</code>.
     *
     * @param  mixed   $obj The object to compare to.
     * @return boolean Whether equal to the object specified.
     */
    public function equals($obj)
    {
        if (!$obj instanceof static) {
            return false;
        }

        if ($this === $obj) {
            return true;
        }

        if (null === $this->getPrimaryKey() || null === $obj->getPrimaryKey()) {
            return false;
        }

        return $this->getPrimaryKey() === $obj->getPrimaryKey();
    }

    /**
     * Get the associative array of the virtual columns in this object
     *
     * @return array
     */
    public function getVirtualColumns()
    {
        return $this->virtualColumns;
    }

    /**
     * Checks the existence of a virtual column in this object
     *
     * @param  string  $name The virtual column name
     * @return boolean
     */
    public function hasVirtualColumn($name)
    {
        return array_key_exists($name, $this->virtualColumns);
    }

    /**
     * Get the value of a virtual column in this object
     *
     * @param  string $name The virtual column name
     * @return mixed
     *
     * @throws PropelException
     */
    public function getVirtualColumn($name)
    {
        if (!$this->hasVirtualColumn($name)) {
            throw new PropelException(sprintf('Cannot get value of inexistent virtual column %s.', $name));
        }

        return $this->virtualColumns[$name];
    }

    /**
     * Set the value of a virtual column in this object
     *
     * @param string $name  The virtual column name
     * @param mixed  $value The value to give to the virtual column
     *
     * @return $this|Customer The current object, for fluid interface
     */
    public function setVirtualColumn($name, $value)
    {
        $this->virtualColumns[$name] = $value;

        return $this;
    }

    /**
     * Logs a message using Propel::log().
     *
     * @param  string  $msg
     * @param  int     $priority One of the Propel::LOG_* logging levels
     * @return boolean
     */
    protected function log($msg, $priority = Propel::LOG_INFO)
    {
        return Propel::log(get_class($this) . ': ' . $msg, $priority);
    }

    /**
     * Export the current object properties to a string, using a given parser format
     * <code>
     * $book = BookQuery::create()->findPk(9012);
     * echo $book->exportTo('JSON');
     *  => {"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * @param  mixed   $parser                 A AbstractParser instance, or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param  boolean $includeLazyLoadColumns (optional) Whether to include lazy load(ed) columns. Defaults to TRUE.
     * @return string  The exported data
     */
    public function exportTo($parser, $includeLazyLoadColumns = true)
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        return $parser->fromArray($this->toArray(TableMap::TYPE_PHPNAME, $includeLazyLoadColumns, array(), true));
    }

    /**
     * Clean up internal collections prior to serializing
     * Avoids recursive loops that turn into segmentation faults when serializing
     */
    public function __sleep()
    {
        $this->clearAllReferences();

        $cls = new \ReflectionClass($this);
        $propertyNames = [];
        $serializableProperties = array_diff($cls->getProperties(), $cls->getProperties(\ReflectionProperty::IS_STATIC));

        foreach($serializableProperties as $property) {
            $propertyNames[] = $property->getName();
        }

        return $propertyNames;
    }

    /**
     * Get the [id] column value.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [name] column value.
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get the [email] column value.
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Get the [password] column value.
     *
     * @return string
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * Get the [phone] column value.
     *
     * @return string
     */
    public function getPhone()
    {
        return $this->phone;
    }

    /**
     * Get the [optionally formatted] temporal [registred] column value.
     *
     *
     * @param      string|null $format The date/time format string (either date()-style or strftime()-style).
     *                            If format is NULL, then the raw DateTime object will be returned.
     *
     * @return string|DateTime Formatted date/time value as string or DateTime object (if format is NULL), NULL if column is NULL, and 0 if column value is 0000-00-00 00:00:00
     *
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getRegistred($format = NULL)
    {
        if ($format === null) {
            return $this->registred;
        } else {
            return $this->registred instanceof \DateTimeInterface ? $this->registred->format($format) : null;
        }
    }

    /**
     * Get the [optionally formatted] temporal [lastauth] column value.
     *
     *
     * @param      string|null $format The date/time format string (either date()-style or strftime()-style).
     *                            If format is NULL, then the raw DateTime object will be returned.
     *
     * @return string|DateTime Formatted date/time value as string or DateTime object (if format is NULL), NULL if column is NULL, and 0 if column value is 0000-00-00 00:00:00
     *
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getLastauth($format = NULL)
    {
        if ($format === null) {
            return $this->lastauth;
        } else {
            return $this->lastauth instanceof \DateTimeInterface ? $this->lastauth->format($format) : null;
        }
    }

    /**
     * Get the [blocked] column value.
     *
     * @return string
     */
    public function getBlocked()
    {
        return $this->blocked;
    }

    /**
     * Get the [notify_type] column value.
     *
     * @return string
     */
    public function getNotifyType()
    {
        return $this->notify_type;
    }

    /**
     * Get the [delete] column value.
     *
     * @return int
     */
    public function getDelete()
    {
        return $this->delete;
    }

    /**
     * Get the [discount] column value.
     *
     * @return string
     */
    public function getDiscount()
    {
        return $this->discount;
    }

    /**
     * Get the [inn] column value.
     *
     * @return string
     */
    public function getInn()
    {
        return $this->inn;
    }

    /**
     * Get the [info_hidden] column value.
     *
     * @return string
     */
    public function getInfoHidden()
    {
        return $this->info_hidden;
    }

    /**
     * Get the [group_id] column value.
     *
     * @return int
     */
    public function getGroupId()
    {
        return $this->group_id;
    }

    /**
     * Get the [city_id] column value.
     *
     * @return int
     */
    public function getCityId()
    {
        return $this->city_id;
    }

    /**
     * Get the [manager_id] column value.
     *
     * @return int
     */
    public function getManagerId()
    {
        return $this->manager_id;
    }

    /**
     * Get the [notify_order] column value.
     *
     * @return string
     */
    public function getNotifyOrder()
    {
        return $this->notify_order;
    }

    /**
     * Get the [notify_news] column value.
     *
     * @return string
     */
    public function getNotifyNews()
    {
        return $this->notify_news;
    }

    /**
     * Get the [notify_products] column value.
     *
     * @return string
     */
    public function getNotifyProducts()
    {
        return $this->notify_products;
    }

    /**
     * Set the value of [id] column.
     *
     * @param int $v new value
     * @return $this|\Shop\Models\Customer\Customer The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[CustomerTableMap::COL_ID] = true;
        }

        return $this;
    } // setId()

    /**
     * Set the value of [name] column.
     *
     * @param string $v new value
     * @return $this|\Shop\Models\Customer\Customer The current object (for fluent API support)
     */
    public function setName($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->name !== $v) {
            $this->name = $v;
            $this->modifiedColumns[CustomerTableMap::COL_NAME] = true;
        }

        return $this;
    } // setName()

    /**
     * Set the value of [email] column.
     *
     * @param string $v new value
     * @return $this|\Shop\Models\Customer\Customer The current object (for fluent API support)
     */
    public function setEmail($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->email !== $v) {
            $this->email = $v;
            $this->modifiedColumns[CustomerTableMap::COL_EMAIL] = true;
        }

        return $this;
    } // setEmail()

    /**
     * Set the value of [password] column.
     *
     * @param string $v new value
     * @return $this|\Shop\Models\Customer\Customer The current object (for fluent API support)
     */
    public function setPassword($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->password !== $v) {
            $this->password = $v;
            $this->modifiedColumns[CustomerTableMap::COL_PASSWORD] = true;
        }

        return $this;
    } // setPassword()

    /**
     * Set the value of [phone] column.
     *
     * @param string $v new value
     * @return $this|\Shop\Models\Customer\Customer The current object (for fluent API support)
     */
    public function setPhone($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->phone !== $v) {
            $this->phone = $v;
            $this->modifiedColumns[CustomerTableMap::COL_PHONE] = true;
        }

        return $this;
    } // setPhone()

    /**
     * Sets the value of [registred] column to a normalized version of the date/time value specified.
     *
     * @param  mixed $v string, integer (timestamp), or \DateTimeInterface value.
     *               Empty strings are treated as NULL.
     * @return $this|\Shop\Models\Customer\Customer The current object (for fluent API support)
     */
    public function setRegistred($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->registred !== null || $dt !== null) {
            if ($this->registred === null || $dt === null || $dt->format("Y-m-d H:i:s.u") !== $this->registred->format("Y-m-d H:i:s.u")) {
                $this->registred = $dt === null ? null : clone $dt;
                $this->modifiedColumns[CustomerTableMap::COL_REGISTRED] = true;
            }
        } // if either are not null

        return $this;
    } // setRegistred()

    /**
     * Sets the value of [lastauth] column to a normalized version of the date/time value specified.
     *
     * @param  mixed $v string, integer (timestamp), or \DateTimeInterface value.
     *               Empty strings are treated as NULL.
     * @return $this|\Shop\Models\Customer\Customer The current object (for fluent API support)
     */
    public function setLastauth($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->lastauth !== null || $dt !== null) {
            if ($this->lastauth === null || $dt === null || $dt->format("Y-m-d H:i:s.u") !== $this->lastauth->format("Y-m-d H:i:s.u")) {
                $this->lastauth = $dt === null ? null : clone $dt;
                $this->modifiedColumns[CustomerTableMap::COL_LASTAUTH] = true;
            }
        } // if either are not null

        return $this;
    } // setLastauth()

    /**
     * Set the value of [blocked] column.
     *
     * @param string $v new value
     * @return $this|\Shop\Models\Customer\Customer The current object (for fluent API support)
     */
    public function setBlocked($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->blocked !== $v) {
            $this->blocked = $v;
            $this->modifiedColumns[CustomerTableMap::COL_BLOCKED] = true;
        }

        return $this;
    } // setBlocked()

    /**
     * Set the value of [notify_type] column.
     *
     * @param string $v new value
     * @return $this|\Shop\Models\Customer\Customer The current object (for fluent API support)
     */
    public function setNotifyType($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->notify_type !== $v) {
            $this->notify_type = $v;
            $this->modifiedColumns[CustomerTableMap::COL_NOTIFY_TYPE] = true;
        }

        return $this;
    } // setNotifyType()

    /**
     * Set the value of [delete] column.
     *
     * @param int $v new value
     * @return $this|\Shop\Models\Customer\Customer The current object (for fluent API support)
     */
    public function setDelete($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->delete !== $v) {
            $this->delete = $v;
            $this->modifiedColumns[CustomerTableMap::COL_DELETE] = true;
        }

        return $this;
    } // setDelete()

    /**
     * Set the value of [discount] column.
     *
     * @param string $v new value
     * @return $this|\Shop\Models\Customer\Customer The current object (for fluent API support)
     */
    public function setDiscount($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->discount !== $v) {
            $this->discount = $v;
            $this->modifiedColumns[CustomerTableMap::COL_DISCOUNT] = true;
        }

        return $this;
    } // setDiscount()

    /**
     * Set the value of [inn] column.
     *
     * @param string $v new value
     * @return $this|\Shop\Models\Customer\Customer The current object (for fluent API support)
     */
    public function setInn($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->inn !== $v) {
            $this->inn = $v;
            $this->modifiedColumns[CustomerTableMap::COL_INN] = true;
        }

        return $this;
    } // setInn()

    /**
     * Set the value of [info_hidden] column.
     *
     * @param string $v new value
     * @return $this|\Shop\Models\Customer\Customer The current object (for fluent API support)
     */
    public function setInfoHidden($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->info_hidden !== $v) {
            $this->info_hidden = $v;
            $this->modifiedColumns[CustomerTableMap::COL_INFO_HIDDEN] = true;
        }

        return $this;
    } // setInfoHidden()

    /**
     * Set the value of [group_id] column.
     *
     * @param int $v new value
     * @return $this|\Shop\Models\Customer\Customer The current object (for fluent API support)
     */
    public function setGroupId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->group_id !== $v) {
            $this->group_id = $v;
            $this->modifiedColumns[CustomerTableMap::COL_GROUP_ID] = true;
        }

        if ($this->aCustomerGroup !== null && $this->aCustomerGroup->getId() !== $v) {
            $this->aCustomerGroup = null;
        }

        return $this;
    } // setGroupId()

    /**
     * Set the value of [city_id] column.
     *
     * @param int $v new value
     * @return $this|\Shop\Models\Customer\Customer The current object (for fluent API support)
     */
    public function setCityId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->city_id !== $v) {
            $this->city_id = $v;
            $this->modifiedColumns[CustomerTableMap::COL_CITY_ID] = true;
        }

        if ($this->aCustomerCity !== null && $this->aCustomerCity->getId() !== $v) {
            $this->aCustomerCity = null;
        }

        return $this;
    } // setCityId()

    /**
     * Set the value of [manager_id] column.
     *
     * @param int $v new value
     * @return $this|\Shop\Models\Customer\Customer The current object (for fluent API support)
     */
    public function setManagerId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->manager_id !== $v) {
            $this->manager_id = $v;
            $this->modifiedColumns[CustomerTableMap::COL_MANAGER_ID] = true;
        }

        if ($this->aManager !== null && $this->aManager->getId() !== $v) {
            $this->aManager = null;
        }

        return $this;
    } // setManagerId()

    /**
     * Set the value of [notify_order] column.
     *
     * @param string $v new value
     * @return $this|\Shop\Models\Customer\Customer The current object (for fluent API support)
     */
    public function setNotifyOrder($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->notify_order !== $v) {
            $this->notify_order = $v;
            $this->modifiedColumns[CustomerTableMap::COL_NOTIFY_ORDER] = true;
        }

        return $this;
    } // setNotifyOrder()

    /**
     * Set the value of [notify_news] column.
     *
     * @param string $v new value
     * @return $this|\Shop\Models\Customer\Customer The current object (for fluent API support)
     */
    public function setNotifyNews($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->notify_news !== $v) {
            $this->notify_news = $v;
            $this->modifiedColumns[CustomerTableMap::COL_NOTIFY_NEWS] = true;
        }

        return $this;
    } // setNotifyNews()

    /**
     * Set the value of [notify_products] column.
     *
     * @param string $v new value
     * @return $this|\Shop\Models\Customer\Customer The current object (for fluent API support)
     */
    public function setNotifyProducts($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->notify_products !== $v) {
            $this->notify_products = $v;
            $this->modifiedColumns[CustomerTableMap::COL_NOTIFY_PRODUCTS] = true;
        }

        return $this;
    } // setNotifyProducts()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
            if ($this->blocked !== 'N') {
                return false;
            }

            if ($this->notify_type !== 'sms_email') {
                return false;
            }

            if ($this->delete !== 0) {
                return false;
            }

            if ($this->discount !== '0.00') {
                return false;
            }

            if ($this->notify_order !== 'Y') {
                return false;
            }

            if ($this->notify_news !== 'Y') {
                return false;
            }

            if ($this->notify_products !== 'Y') {
                return false;
            }

        // otherwise, everything was equal, so return TRUE
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array   $row       The row returned by DataFetcher->fetch().
     * @param int     $startcol  0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @param string  $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                  One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                            TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false, $indexType = TableMap::TYPE_NUM)
    {
        try {

            $col = $row[TableMap::TYPE_NUM == $indexType ? 0 + $startcol : CustomerTableMap::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
            $this->id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 1 + $startcol : CustomerTableMap::translateFieldName('Name', TableMap::TYPE_PHPNAME, $indexType)];
            $this->name = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 2 + $startcol : CustomerTableMap::translateFieldName('Email', TableMap::TYPE_PHPNAME, $indexType)];
            $this->email = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 3 + $startcol : CustomerTableMap::translateFieldName('Password', TableMap::TYPE_PHPNAME, $indexType)];
            $this->password = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 4 + $startcol : CustomerTableMap::translateFieldName('Phone', TableMap::TYPE_PHPNAME, $indexType)];
            $this->phone = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 5 + $startcol : CustomerTableMap::translateFieldName('Registred', TableMap::TYPE_PHPNAME, $indexType)];
            if ($col === '0000-00-00 00:00:00') {
                $col = null;
            }
            $this->registred = (null !== $col) ? PropelDateTime::newInstance($col, null, 'DateTime') : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 6 + $startcol : CustomerTableMap::translateFieldName('Lastauth', TableMap::TYPE_PHPNAME, $indexType)];
            if ($col === '0000-00-00 00:00:00') {
                $col = null;
            }
            $this->lastauth = (null !== $col) ? PropelDateTime::newInstance($col, null, 'DateTime') : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 7 + $startcol : CustomerTableMap::translateFieldName('Blocked', TableMap::TYPE_PHPNAME, $indexType)];
            $this->blocked = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 8 + $startcol : CustomerTableMap::translateFieldName('NotifyType', TableMap::TYPE_PHPNAME, $indexType)];
            $this->notify_type = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 9 + $startcol : CustomerTableMap::translateFieldName('Delete', TableMap::TYPE_PHPNAME, $indexType)];
            $this->delete = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 10 + $startcol : CustomerTableMap::translateFieldName('Discount', TableMap::TYPE_PHPNAME, $indexType)];
            $this->discount = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 11 + $startcol : CustomerTableMap::translateFieldName('Inn', TableMap::TYPE_PHPNAME, $indexType)];
            $this->inn = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 12 + $startcol : CustomerTableMap::translateFieldName('InfoHidden', TableMap::TYPE_PHPNAME, $indexType)];
            $this->info_hidden = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 13 + $startcol : CustomerTableMap::translateFieldName('GroupId', TableMap::TYPE_PHPNAME, $indexType)];
            $this->group_id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 14 + $startcol : CustomerTableMap::translateFieldName('CityId', TableMap::TYPE_PHPNAME, $indexType)];
            $this->city_id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 15 + $startcol : CustomerTableMap::translateFieldName('ManagerId', TableMap::TYPE_PHPNAME, $indexType)];
            $this->manager_id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 16 + $startcol : CustomerTableMap::translateFieldName('NotifyOrder', TableMap::TYPE_PHPNAME, $indexType)];
            $this->notify_order = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 17 + $startcol : CustomerTableMap::translateFieldName('NotifyNews', TableMap::TYPE_PHPNAME, $indexType)];
            $this->notify_news = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 18 + $startcol : CustomerTableMap::translateFieldName('NotifyProducts', TableMap::TYPE_PHPNAME, $indexType)];
            $this->notify_products = (null !== $col) ? (string) $col : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 19; // 19 = CustomerTableMap::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException(sprintf('Error populating %s object', '\\Shop\\Models\\Customer\\Customer'), 0, $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {
        if ($this->aCustomerGroup !== null && $this->group_id !== $this->aCustomerGroup->getId()) {
            $this->aCustomerGroup = null;
        }
        if ($this->aCustomerCity !== null && $this->city_id !== $this->aCustomerCity->getId()) {
            $this->aCustomerCity = null;
        }
        if ($this->aManager !== null && $this->manager_id !== $this->aManager->getId()) {
            $this->aManager = null;
        }
    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param      boolean $deep (optional) Whether to also de-associated any related objects.
     * @param      ConnectionInterface $con (optional) The ConnectionInterface connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, ConnectionInterface $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(CustomerTableMap::DATABASE_NAME);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $dataFetcher = ChildCustomerQuery::create(null, $this->buildPkeyCriteria())->setFormatter(ModelCriteria::FORMAT_STATEMENT)->find($con);
        $row = $dataFetcher->fetch();
        $dataFetcher->close();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true, $dataFetcher->getIndexType()); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->aCustomerGroup = null;
            $this->aCustomerCity = null;
            $this->aManager = null;
            $this->singleSocialLogin = null;

            $this->singleBasket = null;

            $this->collOrders = null;

            $this->collFastLinksRelatedByOwnerCustomerId = null;

            $this->singleFastLinkRelatedByCode = null;

        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param      ConnectionInterface $con
     * @return void
     * @throws PropelException
     * @see Customer::setDeleted()
     * @see Customer::isDeleted()
     */
    public function delete(ConnectionInterface $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(CustomerTableMap::DATABASE_NAME);
        }

        $con->transaction(function () use ($con) {
            $deleteQuery = ChildCustomerQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $this->setDeleted(true);
            }
        });
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param      ConnectionInterface $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see doSave()
     */
    public function save(ConnectionInterface $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($this->alreadyInSave) {
            return 0;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(CustomerTableMap::DATABASE_NAME);
        }

        return $con->transaction(function () use ($con) {
            $ret = $this->preSave($con);
            $isInsert = $this->isNew();
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                CustomerTableMap::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }

            return $affectedRows;
        });
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param      ConnectionInterface $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see save()
     */
    protected function doSave(ConnectionInterface $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            // We call the save method on the following object(s) if they
            // were passed to this object by their corresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aCustomerGroup !== null) {
                if ($this->aCustomerGroup->isModified() || $this->aCustomerGroup->isNew()) {
                    $affectedRows += $this->aCustomerGroup->save($con);
                }
                $this->setCustomerGroup($this->aCustomerGroup);
            }

            if ($this->aCustomerCity !== null) {
                if ($this->aCustomerCity->isModified() || $this->aCustomerCity->isNew()) {
                    $affectedRows += $this->aCustomerCity->save($con);
                }
                $this->setCustomerCity($this->aCustomerCity);
            }

            if ($this->aManager !== null) {
                if ($this->aManager->isModified() || $this->aManager->isNew()) {
                    $affectedRows += $this->aManager->save($con);
                }
                $this->setManager($this->aManager);
            }

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                    $affectedRows += 1;
                } else {
                    $affectedRows += $this->doUpdate($con);
                }
                $this->resetModified();
            }

            if ($this->singleSocialLogin !== null) {
                if (!$this->singleSocialLogin->isDeleted() && ($this->singleSocialLogin->isNew() || $this->singleSocialLogin->isModified())) {
                    $affectedRows += $this->singleSocialLogin->save($con);
                }
            }

            if ($this->singleBasket !== null) {
                if (!$this->singleBasket->isDeleted() && ($this->singleBasket->isNew() || $this->singleBasket->isModified())) {
                    $affectedRows += $this->singleBasket->save($con);
                }
            }

            if ($this->ordersScheduledForDeletion !== null) {
                if (!$this->ordersScheduledForDeletion->isEmpty()) {
                    \Shop\Models\Order\OrderQuery::create()
                        ->filterByPrimaryKeys($this->ordersScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->ordersScheduledForDeletion = null;
                }
            }

            if ($this->collOrders !== null) {
                foreach ($this->collOrders as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->fastLinksRelatedByOwnerCustomerIdScheduledForDeletion !== null) {
                if (!$this->fastLinksRelatedByOwnerCustomerIdScheduledForDeletion->isEmpty()) {
                    \Shop\Models\FastLink\FastLinkQuery::create()
                        ->filterByPrimaryKeys($this->fastLinksRelatedByOwnerCustomerIdScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->fastLinksRelatedByOwnerCustomerIdScheduledForDeletion = null;
                }
            }

            if ($this->collFastLinksRelatedByOwnerCustomerId !== null) {
                foreach ($this->collFastLinksRelatedByOwnerCustomerId as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->singleFastLinkRelatedByCode !== null) {
                if (!$this->singleFastLinkRelatedByCode->isDeleted() && ($this->singleFastLinkRelatedByCode->isNew() || $this->singleFastLinkRelatedByCode->isModified())) {
                    $affectedRows += $this->singleFastLinkRelatedByCode->save($con);
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param      ConnectionInterface $con
     *
     * @throws PropelException
     * @see doSave()
     */
    protected function doInsert(ConnectionInterface $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[CustomerTableMap::COL_ID] = true;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . CustomerTableMap::COL_ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(CustomerTableMap::COL_ID)) {
            $modifiedColumns[':p' . $index++]  = '`id`';
        }
        if ($this->isColumnModified(CustomerTableMap::COL_NAME)) {
            $modifiedColumns[':p' . $index++]  = '`name`';
        }
        if ($this->isColumnModified(CustomerTableMap::COL_EMAIL)) {
            $modifiedColumns[':p' . $index++]  = '`email`';
        }
        if ($this->isColumnModified(CustomerTableMap::COL_PASSWORD)) {
            $modifiedColumns[':p' . $index++]  = '`password`';
        }
        if ($this->isColumnModified(CustomerTableMap::COL_PHONE)) {
            $modifiedColumns[':p' . $index++]  = '`phone`';
        }
        if ($this->isColumnModified(CustomerTableMap::COL_REGISTRED)) {
            $modifiedColumns[':p' . $index++]  = '`registred`';
        }
        if ($this->isColumnModified(CustomerTableMap::COL_LASTAUTH)) {
            $modifiedColumns[':p' . $index++]  = '`lastauth`';
        }
        if ($this->isColumnModified(CustomerTableMap::COL_BLOCKED)) {
            $modifiedColumns[':p' . $index++]  = '`blocked`';
        }
        if ($this->isColumnModified(CustomerTableMap::COL_NOTIFY_TYPE)) {
            $modifiedColumns[':p' . $index++]  = '`notify_type`';
        }
        if ($this->isColumnModified(CustomerTableMap::COL_DELETE)) {
            $modifiedColumns[':p' . $index++]  = '`delete`';
        }
        if ($this->isColumnModified(CustomerTableMap::COL_DISCOUNT)) {
            $modifiedColumns[':p' . $index++]  = '`discount`';
        }
        if ($this->isColumnModified(CustomerTableMap::COL_INN)) {
            $modifiedColumns[':p' . $index++]  = '`inn`';
        }
        if ($this->isColumnModified(CustomerTableMap::COL_INFO_HIDDEN)) {
            $modifiedColumns[':p' . $index++]  = '`info_hidden`';
        }
        if ($this->isColumnModified(CustomerTableMap::COL_GROUP_ID)) {
            $modifiedColumns[':p' . $index++]  = '`group_id`';
        }
        if ($this->isColumnModified(CustomerTableMap::COL_CITY_ID)) {
            $modifiedColumns[':p' . $index++]  = '`city_id`';
        }
        if ($this->isColumnModified(CustomerTableMap::COL_MANAGER_ID)) {
            $modifiedColumns[':p' . $index++]  = '`manager_id`';
        }
        if ($this->isColumnModified(CustomerTableMap::COL_NOTIFY_ORDER)) {
            $modifiedColumns[':p' . $index++]  = '`notify_order`';
        }
        if ($this->isColumnModified(CustomerTableMap::COL_NOTIFY_NEWS)) {
            $modifiedColumns[':p' . $index++]  = '`notify_news`';
        }
        if ($this->isColumnModified(CustomerTableMap::COL_NOTIFY_PRODUCTS)) {
            $modifiedColumns[':p' . $index++]  = '`notify_products`';
        }

        $sql = sprintf(
            'INSERT INTO `shop_customer` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`id`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`name`':
                        $stmt->bindValue($identifier, $this->name, PDO::PARAM_STR);
                        break;
                    case '`email`':
                        $stmt->bindValue($identifier, $this->email, PDO::PARAM_STR);
                        break;
                    case '`password`':
                        $stmt->bindValue($identifier, $this->password, PDO::PARAM_STR);
                        break;
                    case '`phone`':
                        $stmt->bindValue($identifier, $this->phone, PDO::PARAM_STR);
                        break;
                    case '`registred`':
                        $stmt->bindValue($identifier, $this->registred ? $this->registred->format("Y-m-d H:i:s.u") : null, PDO::PARAM_STR);
                        break;
                    case '`lastauth`':
                        $stmt->bindValue($identifier, $this->lastauth ? $this->lastauth->format("Y-m-d H:i:s.u") : null, PDO::PARAM_STR);
                        break;
                    case '`blocked`':
                        $stmt->bindValue($identifier, $this->blocked, PDO::PARAM_STR);
                        break;
                    case '`notify_type`':
                        $stmt->bindValue($identifier, $this->notify_type, PDO::PARAM_STR);
                        break;
                    case '`delete`':
                        $stmt->bindValue($identifier, $this->delete, PDO::PARAM_INT);
                        break;
                    case '`discount`':
                        $stmt->bindValue($identifier, $this->discount, PDO::PARAM_STR);
                        break;
                    case '`inn`':
                        $stmt->bindValue($identifier, $this->inn, PDO::PARAM_STR);
                        break;
                    case '`info_hidden`':
                        $stmt->bindValue($identifier, $this->info_hidden, PDO::PARAM_STR);
                        break;
                    case '`group_id`':
                        $stmt->bindValue($identifier, $this->group_id, PDO::PARAM_INT);
                        break;
                    case '`city_id`':
                        $stmt->bindValue($identifier, $this->city_id, PDO::PARAM_INT);
                        break;
                    case '`manager_id`':
                        $stmt->bindValue($identifier, $this->manager_id, PDO::PARAM_INT);
                        break;
                    case '`notify_order`':
                        $stmt->bindValue($identifier, $this->notify_order, PDO::PARAM_STR);
                        break;
                    case '`notify_news`':
                        $stmt->bindValue($identifier, $this->notify_news, PDO::PARAM_STR);
                        break;
                    case '`notify_products`':
                        $stmt->bindValue($identifier, $this->notify_products, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), 0, $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', 0, $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param      ConnectionInterface $con
     *
     * @return Integer Number of updated rows
     * @see doSave()
     */
    protected function doUpdate(ConnectionInterface $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();

        return $selectCriteria->doUpdate($valuesCriteria, $con);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param      string $name name
     * @param      string $type The type of fieldname the $name is of:
     *                     one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                     TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                     Defaults to TableMap::TYPE_PHPNAME.
     * @return mixed Value of field.
     */
    public function getByName($name, $type = TableMap::TYPE_PHPNAME)
    {
        $pos = CustomerTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param      int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getName();
                break;
            case 2:
                return $this->getEmail();
                break;
            case 3:
                return $this->getPassword();
                break;
            case 4:
                return $this->getPhone();
                break;
            case 5:
                return $this->getRegistred();
                break;
            case 6:
                return $this->getLastauth();
                break;
            case 7:
                return $this->getBlocked();
                break;
            case 8:
                return $this->getNotifyType();
                break;
            case 9:
                return $this->getDelete();
                break;
            case 10:
                return $this->getDiscount();
                break;
            case 11:
                return $this->getInn();
                break;
            case 12:
                return $this->getInfoHidden();
                break;
            case 13:
                return $this->getGroupId();
                break;
            case 14:
                return $this->getCityId();
                break;
            case 15:
                return $this->getManagerId();
                break;
            case 16:
                return $this->getNotifyOrder();
                break;
            case 17:
                return $this->getNotifyNews();
                break;
            case 18:
                return $this->getNotifyProducts();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     *                    TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                    Defaults to TableMap::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to TRUE.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = TableMap::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {

        if (isset($alreadyDumpedObjects['Customer'][$this->hashCode()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['Customer'][$this->hashCode()] = true;
        $keys = CustomerTableMap::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getName(),
            $keys[2] => $this->getEmail(),
            $keys[3] => $this->getPassword(),
            $keys[4] => $this->getPhone(),
            $keys[5] => $this->getRegistred(),
            $keys[6] => $this->getLastauth(),
            $keys[7] => $this->getBlocked(),
            $keys[8] => $this->getNotifyType(),
            $keys[9] => $this->getDelete(),
            $keys[10] => $this->getDiscount(),
            $keys[11] => $this->getInn(),
            $keys[12] => $this->getInfoHidden(),
            $keys[13] => $this->getGroupId(),
            $keys[14] => $this->getCityId(),
            $keys[15] => $this->getManagerId(),
            $keys[16] => $this->getNotifyOrder(),
            $keys[17] => $this->getNotifyNews(),
            $keys[18] => $this->getNotifyProducts(),
        );
        if ($result[$keys[5]] instanceof \DateTimeInterface) {
            $result[$keys[5]] = $result[$keys[5]]->format('c');
        }

        if ($result[$keys[6]] instanceof \DateTimeInterface) {
            $result[$keys[6]] = $result[$keys[6]]->format('c');
        }

        $virtualColumns = $this->virtualColumns;
        foreach ($virtualColumns as $key => $virtualColumn) {
            $result[$key] = $virtualColumn;
        }

        if ($includeForeignObjects) {
            if (null !== $this->aCustomerGroup) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'customerGroup';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_customer_groups';
                        break;
                    default:
                        $key = 'CustomerGroup';
                }

                $result[$key] = $this->aCustomerGroup->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aCustomerCity) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'city';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_cities';
                        break;
                    default:
                        $key = 'CustomerCity';
                }

                $result[$key] = $this->aCustomerCity->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aManager) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'manager';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_managers';
                        break;
                    default:
                        $key = 'Manager';
                }

                $result[$key] = $this->aManager->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->singleSocialLogin) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'socialLogin';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_customer_social_logins';
                        break;
                    default:
                        $key = 'SocialLogin';
                }

                $result[$key] = $this->singleSocialLogin->toArray($keyType, $includeLazyLoadColumns, $alreadyDumpedObjects, true);
            }
            if (null !== $this->singleBasket) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'basket';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_basket';
                        break;
                    default:
                        $key = 'Basket';
                }

                $result[$key] = $this->singleBasket->toArray($keyType, $includeLazyLoadColumns, $alreadyDumpedObjects, true);
            }
            if (null !== $this->collOrders) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'orders';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_orderss';
                        break;
                    default:
                        $key = 'Orders';
                }

                $result[$key] = $this->collOrders->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collFastLinksRelatedByOwnerCustomerId) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'fastLinks';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_fastlinkss';
                        break;
                    default:
                        $key = 'FastLinks';
                }

                $result[$key] = $this->collFastLinksRelatedByOwnerCustomerId->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->singleFastLinkRelatedByCode) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'fastLink';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_fastlinks';
                        break;
                    default:
                        $key = 'FastLink';
                }

                $result[$key] = $this->singleFastLinkRelatedByCode->toArray($keyType, $includeLazyLoadColumns, $alreadyDumpedObjects, true);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param  string $name
     * @param  mixed  $value field value
     * @param  string $type The type of fieldname the $name is of:
     *                one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                Defaults to TableMap::TYPE_PHPNAME.
     * @return $this|\Shop\Models\Customer\Customer
     */
    public function setByName($name, $value, $type = TableMap::TYPE_PHPNAME)
    {
        $pos = CustomerTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);

        return $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param  int $pos position in xml schema
     * @param  mixed $value field value
     * @return $this|\Shop\Models\Customer\Customer
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setName($value);
                break;
            case 2:
                $this->setEmail($value);
                break;
            case 3:
                $this->setPassword($value);
                break;
            case 4:
                $this->setPhone($value);
                break;
            case 5:
                $this->setRegistred($value);
                break;
            case 6:
                $this->setLastauth($value);
                break;
            case 7:
                $this->setBlocked($value);
                break;
            case 8:
                $this->setNotifyType($value);
                break;
            case 9:
                $this->setDelete($value);
                break;
            case 10:
                $this->setDiscount($value);
                break;
            case 11:
                $this->setInn($value);
                break;
            case 12:
                $this->setInfoHidden($value);
                break;
            case 13:
                $this->setGroupId($value);
                break;
            case 14:
                $this->setCityId($value);
                break;
            case 15:
                $this->setManagerId($value);
                break;
            case 16:
                $this->setNotifyOrder($value);
                break;
            case 17:
                $this->setNotifyNews($value);
                break;
            case 18:
                $this->setNotifyProducts($value);
                break;
        } // switch()

        return $this;
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param      array  $arr     An array to populate the object from.
     * @param      string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = TableMap::TYPE_PHPNAME)
    {
        $keys = CustomerTableMap::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) {
            $this->setId($arr[$keys[0]]);
        }
        if (array_key_exists($keys[1], $arr)) {
            $this->setName($arr[$keys[1]]);
        }
        if (array_key_exists($keys[2], $arr)) {
            $this->setEmail($arr[$keys[2]]);
        }
        if (array_key_exists($keys[3], $arr)) {
            $this->setPassword($arr[$keys[3]]);
        }
        if (array_key_exists($keys[4], $arr)) {
            $this->setPhone($arr[$keys[4]]);
        }
        if (array_key_exists($keys[5], $arr)) {
            $this->setRegistred($arr[$keys[5]]);
        }
        if (array_key_exists($keys[6], $arr)) {
            $this->setLastauth($arr[$keys[6]]);
        }
        if (array_key_exists($keys[7], $arr)) {
            $this->setBlocked($arr[$keys[7]]);
        }
        if (array_key_exists($keys[8], $arr)) {
            $this->setNotifyType($arr[$keys[8]]);
        }
        if (array_key_exists($keys[9], $arr)) {
            $this->setDelete($arr[$keys[9]]);
        }
        if (array_key_exists($keys[10], $arr)) {
            $this->setDiscount($arr[$keys[10]]);
        }
        if (array_key_exists($keys[11], $arr)) {
            $this->setInn($arr[$keys[11]]);
        }
        if (array_key_exists($keys[12], $arr)) {
            $this->setInfoHidden($arr[$keys[12]]);
        }
        if (array_key_exists($keys[13], $arr)) {
            $this->setGroupId($arr[$keys[13]]);
        }
        if (array_key_exists($keys[14], $arr)) {
            $this->setCityId($arr[$keys[14]]);
        }
        if (array_key_exists($keys[15], $arr)) {
            $this->setManagerId($arr[$keys[15]]);
        }
        if (array_key_exists($keys[16], $arr)) {
            $this->setNotifyOrder($arr[$keys[16]]);
        }
        if (array_key_exists($keys[17], $arr)) {
            $this->setNotifyNews($arr[$keys[17]]);
        }
        if (array_key_exists($keys[18], $arr)) {
            $this->setNotifyProducts($arr[$keys[18]]);
        }
    }

     /**
     * Populate the current object from a string, using a given parser format
     * <code>
     * $book = new Book();
     * $book->importFrom('JSON', '{"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param mixed $parser A AbstractParser instance,
     *                       or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param string $data The source data to import from
     * @param string $keyType The type of keys the array uses.
     *
     * @return $this|\Shop\Models\Customer\Customer The current object, for fluid interface
     */
    public function importFrom($parser, $data, $keyType = TableMap::TYPE_PHPNAME)
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        $this->fromArray($parser->toArray($data), $keyType);

        return $this;
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(CustomerTableMap::DATABASE_NAME);

        if ($this->isColumnModified(CustomerTableMap::COL_ID)) {
            $criteria->add(CustomerTableMap::COL_ID, $this->id);
        }
        if ($this->isColumnModified(CustomerTableMap::COL_NAME)) {
            $criteria->add(CustomerTableMap::COL_NAME, $this->name);
        }
        if ($this->isColumnModified(CustomerTableMap::COL_EMAIL)) {
            $criteria->add(CustomerTableMap::COL_EMAIL, $this->email);
        }
        if ($this->isColumnModified(CustomerTableMap::COL_PASSWORD)) {
            $criteria->add(CustomerTableMap::COL_PASSWORD, $this->password);
        }
        if ($this->isColumnModified(CustomerTableMap::COL_PHONE)) {
            $criteria->add(CustomerTableMap::COL_PHONE, $this->phone);
        }
        if ($this->isColumnModified(CustomerTableMap::COL_REGISTRED)) {
            $criteria->add(CustomerTableMap::COL_REGISTRED, $this->registred);
        }
        if ($this->isColumnModified(CustomerTableMap::COL_LASTAUTH)) {
            $criteria->add(CustomerTableMap::COL_LASTAUTH, $this->lastauth);
        }
        if ($this->isColumnModified(CustomerTableMap::COL_BLOCKED)) {
            $criteria->add(CustomerTableMap::COL_BLOCKED, $this->blocked);
        }
        if ($this->isColumnModified(CustomerTableMap::COL_NOTIFY_TYPE)) {
            $criteria->add(CustomerTableMap::COL_NOTIFY_TYPE, $this->notify_type);
        }
        if ($this->isColumnModified(CustomerTableMap::COL_DELETE)) {
            $criteria->add(CustomerTableMap::COL_DELETE, $this->delete);
        }
        if ($this->isColumnModified(CustomerTableMap::COL_DISCOUNT)) {
            $criteria->add(CustomerTableMap::COL_DISCOUNT, $this->discount);
        }
        if ($this->isColumnModified(CustomerTableMap::COL_INN)) {
            $criteria->add(CustomerTableMap::COL_INN, $this->inn);
        }
        if ($this->isColumnModified(CustomerTableMap::COL_INFO_HIDDEN)) {
            $criteria->add(CustomerTableMap::COL_INFO_HIDDEN, $this->info_hidden);
        }
        if ($this->isColumnModified(CustomerTableMap::COL_GROUP_ID)) {
            $criteria->add(CustomerTableMap::COL_GROUP_ID, $this->group_id);
        }
        if ($this->isColumnModified(CustomerTableMap::COL_CITY_ID)) {
            $criteria->add(CustomerTableMap::COL_CITY_ID, $this->city_id);
        }
        if ($this->isColumnModified(CustomerTableMap::COL_MANAGER_ID)) {
            $criteria->add(CustomerTableMap::COL_MANAGER_ID, $this->manager_id);
        }
        if ($this->isColumnModified(CustomerTableMap::COL_NOTIFY_ORDER)) {
            $criteria->add(CustomerTableMap::COL_NOTIFY_ORDER, $this->notify_order);
        }
        if ($this->isColumnModified(CustomerTableMap::COL_NOTIFY_NEWS)) {
            $criteria->add(CustomerTableMap::COL_NOTIFY_NEWS, $this->notify_news);
        }
        if ($this->isColumnModified(CustomerTableMap::COL_NOTIFY_PRODUCTS)) {
            $criteria->add(CustomerTableMap::COL_NOTIFY_PRODUCTS, $this->notify_products);
        }

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @throws LogicException if no primary key is defined
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = ChildCustomerQuery::create();
        $criteria->add(CustomerTableMap::COL_ID, $this->id);

        return $criteria;
    }

    /**
     * If the primary key is not null, return the hashcode of the
     * primary key. Otherwise, return the hash code of the object.
     *
     * @return int Hashcode
     */
    public function hashCode()
    {
        $validPk = null !== $this->getId();

        $validPrimaryKeyFKs = 0;
        $primaryKeyFKs = [];

        if ($validPk) {
            return crc32(json_encode($this->getPrimaryKey(), JSON_UNESCAPED_UNICODE));
        } elseif ($validPrimaryKeyFKs) {
            return crc32(json_encode($primaryKeyFKs, JSON_UNESCAPED_UNICODE));
        }

        return spl_object_hash($this);
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param       int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {
        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param      object $copyObj An object of \Shop\Models\Customer\Customer (or compatible) type.
     * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param      boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setName($this->getName());
        $copyObj->setEmail($this->getEmail());
        $copyObj->setPassword($this->getPassword());
        $copyObj->setPhone($this->getPhone());
        $copyObj->setRegistred($this->getRegistred());
        $copyObj->setLastauth($this->getLastauth());
        $copyObj->setBlocked($this->getBlocked());
        $copyObj->setNotifyType($this->getNotifyType());
        $copyObj->setDelete($this->getDelete());
        $copyObj->setDiscount($this->getDiscount());
        $copyObj->setInn($this->getInn());
        $copyObj->setInfoHidden($this->getInfoHidden());
        $copyObj->setGroupId($this->getGroupId());
        $copyObj->setCityId($this->getCityId());
        $copyObj->setManagerId($this->getManagerId());
        $copyObj->setNotifyOrder($this->getNotifyOrder());
        $copyObj->setNotifyNews($this->getNotifyNews());
        $copyObj->setNotifyProducts($this->getNotifyProducts());

        if ($deepCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);

            $relObj = $this->getSocialLogin();
            if ($relObj) {
                $copyObj->setSocialLogin($relObj->copy($deepCopy));
            }

            $relObj = $this->getBasket();
            if ($relObj) {
                $copyObj->setBasket($relObj->copy($deepCopy));
            }

            foreach ($this->getOrders() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addOrder($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getFastLinksRelatedByOwnerCustomerId() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addFastLinkRelatedByOwnerCustomerId($relObj->copy($deepCopy));
                }
            }

            $relObj = $this->getFastLinkRelatedByCode();
            if ($relObj) {
                $copyObj->setFastLinkRelatedByCode($relObj->copy($deepCopy));
            }

        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param  boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return \Shop\Models\Customer\Customer Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Declares an association between this object and a CustomerGroup object.
     *
     * @param  CustomerGroup $v
     * @return $this|\Shop\Models\Customer\Customer The current object (for fluent API support)
     * @throws PropelException
     */
    public function setCustomerGroup(CustomerGroup $v = null)
    {
        if ($v === null) {
            $this->setGroupId(NULL);
        } else {
            $this->setGroupId($v->getId());
        }

        $this->aCustomerGroup = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the CustomerGroup object, it will not be re-added.
        if ($v !== null) {
            $v->addCustomer($this);
        }


        return $this;
    }


    /**
     * Get the associated CustomerGroup object
     *
     * @param  ConnectionInterface $con Optional Connection object.
     * @return CustomerGroup The associated CustomerGroup object.
     * @throws PropelException
     */
    public function getCustomerGroup(ConnectionInterface $con = null)
    {
        if ($this->aCustomerGroup === null && ($this->group_id != 0)) {
            $this->aCustomerGroup = CustomerGroupQuery::create()->findPk($this->group_id, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aCustomerGroup->addCustomers($this);
             */
        }

        return $this->aCustomerGroup;
    }

    /**
     * Declares an association between this object and a City object.
     *
     * @param  City $v
     * @return $this|\Shop\Models\Customer\Customer The current object (for fluent API support)
     * @throws PropelException
     */
    public function setCustomerCity(City $v = null)
    {
        if ($v === null) {
            $this->setCityId(NULL);
        } else {
            $this->setCityId($v->getId());
        }

        $this->aCustomerCity = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the City object, it will not be re-added.
        if ($v !== null) {
            $v->addCustomer($this);
        }


        return $this;
    }


    /**
     * Get the associated City object
     *
     * @param  ConnectionInterface $con Optional Connection object.
     * @return City The associated City object.
     * @throws PropelException
     */
    public function getCustomerCity(ConnectionInterface $con = null)
    {
        if ($this->aCustomerCity === null && ($this->city_id != 0)) {
            $this->aCustomerCity = CityQuery::create()->findPk($this->city_id, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aCustomerCity->addCustomers($this);
             */
        }

        return $this->aCustomerCity;
    }

    /**
     * Declares an association between this object and a Manager object.
     *
     * @param  Manager $v
     * @return $this|\Shop\Models\Customer\Customer The current object (for fluent API support)
     * @throws PropelException
     */
    public function setManager(Manager $v = null)
    {
        if ($v === null) {
            $this->setManagerId(NULL);
        } else {
            $this->setManagerId($v->getId());
        }

        $this->aManager = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Manager object, it will not be re-added.
        if ($v !== null) {
            $v->addCustomer($this);
        }


        return $this;
    }


    /**
     * Get the associated Manager object
     *
     * @param  ConnectionInterface $con Optional Connection object.
     * @return Manager The associated Manager object.
     * @throws PropelException
     */
    public function getManager(ConnectionInterface $con = null)
    {
        if ($this->aManager === null && ($this->manager_id != 0)) {
            $this->aManager = ManagerQuery::create()->findPk($this->manager_id, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aManager->addCustomers($this);
             */
        }

        return $this->aManager;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param      string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName)
    {
        if ('Order' == $relationName) {
            $this->initOrders();
            return;
        }
        if ('FastLinkRelatedByOwnerCustomerId' == $relationName) {
            $this->initFastLinksRelatedByOwnerCustomerId();
            return;
        }
    }

    /**
     * Gets a single SocialLogin object, which is related to this object by a one-to-one relationship.
     *
     * @param  ConnectionInterface $con optional connection object
     * @return SocialLogin
     * @throws PropelException
     */
    public function getSocialLogin(ConnectionInterface $con = null)
    {

        if ($this->singleSocialLogin === null && !$this->isNew()) {
            $this->singleSocialLogin = SocialLoginQuery::create()->findPk($this->getPrimaryKey(), $con);
        }

        return $this->singleSocialLogin;
    }

    /**
     * Sets a single SocialLogin object as related to this object by a one-to-one relationship.
     *
     * @param  SocialLogin $v SocialLogin
     * @return $this|\Shop\Models\Customer\Customer The current object (for fluent API support)
     * @throws PropelException
     */
    public function setSocialLogin(SocialLogin $v = null)
    {
        $this->singleSocialLogin = $v;

        // Make sure that that the passed-in SocialLogin isn't already associated with this object
        if ($v !== null && $v->getCustomer(null, false) === null) {
            $v->setCustomer($this);
        }

        return $this;
    }

    /**
     * Gets a single Basket object, which is related to this object by a one-to-one relationship.
     *
     * @param  ConnectionInterface $con optional connection object
     * @return Basket
     * @throws PropelException
     */
    public function getBasket(ConnectionInterface $con = null)
    {

        if ($this->singleBasket === null && !$this->isNew()) {
            $this->singleBasket = BasketQuery::create()->findPk($this->getPrimaryKey(), $con);
        }

        return $this->singleBasket;
    }

    /**
     * Sets a single Basket object as related to this object by a one-to-one relationship.
     *
     * @param  Basket $v Basket
     * @return $this|\Shop\Models\Customer\Customer The current object (for fluent API support)
     * @throws PropelException
     */
    public function setBasket(Basket $v = null)
    {
        $this->singleBasket = $v;

        // Make sure that that the passed-in Basket isn't already associated with this object
        if ($v !== null && $v->getCustomer(null, false) === null) {
            $v->setCustomer($this);
        }

        return $this;
    }

    /**
     * Clears out the collOrders collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addOrders()
     */
    public function clearOrders()
    {
        $this->collOrders = null; // important to set this to NULL since that means it is uninitialized
    }

    /**
     * Reset is the collOrders collection loaded partially.
     */
    public function resetPartialOrders($v = true)
    {
        $this->collOrdersPartial = $v;
    }

    /**
     * Initializes the collOrders collection.
     *
     * By default this just sets the collOrders collection to an empty array (like clearcollOrders());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param      boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initOrders($overrideExisting = true)
    {
        if (null !== $this->collOrders && !$overrideExisting) {
            return;
        }

        $collectionClassName = OrderTableMap::getTableMap()->getCollectionClassName();

        $this->collOrders = new $collectionClassName;
        $this->collOrders->setModel('\Shop\Models\Order\Order');
    }

    /**
     * Gets an array of Order objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildCustomer is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @return ObjectCollection|Order[] List of Order objects
     * @throws PropelException
     */
    public function getOrders(Criteria $criteria = null, ConnectionInterface $con = null)
    {
        $partial = $this->collOrdersPartial && !$this->isNew();
        if (null === $this->collOrders || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collOrders) {
                // return empty collection
                $this->initOrders();
            } else {
                $collOrders = OrderQuery::create(null, $criteria)
                    ->filterByCustomer($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collOrdersPartial && count($collOrders)) {
                        $this->initOrders(false);

                        foreach ($collOrders as $obj) {
                            if (false == $this->collOrders->contains($obj)) {
                                $this->collOrders->append($obj);
                            }
                        }

                        $this->collOrdersPartial = true;
                    }

                    return $collOrders;
                }

                if ($partial && $this->collOrders) {
                    foreach ($this->collOrders as $obj) {
                        if ($obj->isNew()) {
                            $collOrders[] = $obj;
                        }
                    }
                }

                $this->collOrders = $collOrders;
                $this->collOrdersPartial = false;
            }
        }

        return $this->collOrders;
    }

    /**
     * Sets a collection of Order objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param      Collection $orders A Propel collection.
     * @param      ConnectionInterface $con Optional connection object
     * @return $this|ChildCustomer The current object (for fluent API support)
     */
    public function setOrders(Collection $orders, ConnectionInterface $con = null)
    {
        /** @var Order[] $ordersToDelete */
        $ordersToDelete = $this->getOrders(new Criteria(), $con)->diff($orders);


        $this->ordersScheduledForDeletion = $ordersToDelete;

        foreach ($ordersToDelete as $orderRemoved) {
            $orderRemoved->setCustomer(null);
        }

        $this->collOrders = null;
        foreach ($orders as $order) {
            $this->addOrder($order);
        }

        $this->collOrders = $orders;
        $this->collOrdersPartial = false;

        return $this;
    }

    /**
     * Returns the number of related BaseOrder objects.
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct
     * @param      ConnectionInterface $con
     * @return int             Count of related BaseOrder objects.
     * @throws PropelException
     */
    public function countOrders(Criteria $criteria = null, $distinct = false, ConnectionInterface $con = null)
    {
        $partial = $this->collOrdersPartial && !$this->isNew();
        if (null === $this->collOrders || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collOrders) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getOrders());
            }

            $query = OrderQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByCustomer($this)
                ->count($con);
        }

        return count($this->collOrders);
    }

    /**
     * Method called to associate a Order object to this object
     * through the Order foreign key attribute.
     *
     * @param  Order $l Order
     * @return $this|\Shop\Models\Customer\Customer The current object (for fluent API support)
     */
    public function addOrder(Order $l)
    {
        if ($this->collOrders === null) {
            $this->initOrders();
            $this->collOrdersPartial = true;
        }

        if (!$this->collOrders->contains($l)) {
            $this->doAddOrder($l);

            if ($this->ordersScheduledForDeletion and $this->ordersScheduledForDeletion->contains($l)) {
                $this->ordersScheduledForDeletion->remove($this->ordersScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param Order $order The Order object to add.
     */
    protected function doAddOrder(Order $order)
    {
        $this->collOrders[]= $order;
        $order->setCustomer($this);
    }

    /**
     * @param  Order $order The Order object to remove.
     * @return $this|ChildCustomer The current object (for fluent API support)
     */
    public function removeOrder(Order $order)
    {
        if ($this->getOrders()->contains($order)) {
            $pos = $this->collOrders->search($order);
            $this->collOrders->remove($pos);
            if (null === $this->ordersScheduledForDeletion) {
                $this->ordersScheduledForDeletion = clone $this->collOrders;
                $this->ordersScheduledForDeletion->clear();
            }
            $this->ordersScheduledForDeletion[]= clone $order;
            $order->setCustomer(null);
        }

        return $this;
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Customer is new, it will return
     * an empty collection; or if this Customer has previously
     * been saved, it will retrieve related Orders from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Customer.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @param      string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|Order[] List of Order objects
     */
    public function getOrdersJoinPayment(Criteria $criteria = null, ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = OrderQuery::create(null, $criteria);
        $query->joinWith('Payment', $joinBehavior);

        return $this->getOrders($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Customer is new, it will return
     * an empty collection; or if this Customer has previously
     * been saved, it will retrieve related Orders from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Customer.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @param      string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|Order[] List of Order objects
     */
    public function getOrdersJoinState(Criteria $criteria = null, ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = OrderQuery::create(null, $criteria);
        $query->joinWith('State', $joinBehavior);

        return $this->getOrders($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Customer is new, it will return
     * an empty collection; or if this Customer has previously
     * been saved, it will retrieve related Orders from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Customer.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @param      string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|Order[] List of Order objects
     */
    public function getOrdersJoinShop(Criteria $criteria = null, ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = OrderQuery::create(null, $criteria);
        $query->joinWith('Shop', $joinBehavior);

        return $this->getOrders($query, $con);
    }

    /**
     * Clears out the collFastLinksRelatedByOwnerCustomerId collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addFastLinksRelatedByOwnerCustomerId()
     */
    public function clearFastLinksRelatedByOwnerCustomerId()
    {
        $this->collFastLinksRelatedByOwnerCustomerId = null; // important to set this to NULL since that means it is uninitialized
    }

    /**
     * Reset is the collFastLinksRelatedByOwnerCustomerId collection loaded partially.
     */
    public function resetPartialFastLinksRelatedByOwnerCustomerId($v = true)
    {
        $this->collFastLinksRelatedByOwnerCustomerIdPartial = $v;
    }

    /**
     * Initializes the collFastLinksRelatedByOwnerCustomerId collection.
     *
     * By default this just sets the collFastLinksRelatedByOwnerCustomerId collection to an empty array (like clearcollFastLinksRelatedByOwnerCustomerId());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param      boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initFastLinksRelatedByOwnerCustomerId($overrideExisting = true)
    {
        if (null !== $this->collFastLinksRelatedByOwnerCustomerId && !$overrideExisting) {
            return;
        }

        $collectionClassName = FastLinkTableMap::getTableMap()->getCollectionClassName();

        $this->collFastLinksRelatedByOwnerCustomerId = new $collectionClassName;
        $this->collFastLinksRelatedByOwnerCustomerId->setModel('\Shop\Models\FastLink\FastLink');
    }

    /**
     * Gets an array of FastLink objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildCustomer is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @return ObjectCollection|FastLink[] List of FastLink objects
     * @throws PropelException
     */
    public function getFastLinksRelatedByOwnerCustomerId(Criteria $criteria = null, ConnectionInterface $con = null)
    {
        $partial = $this->collFastLinksRelatedByOwnerCustomerIdPartial && !$this->isNew();
        if (null === $this->collFastLinksRelatedByOwnerCustomerId || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collFastLinksRelatedByOwnerCustomerId) {
                // return empty collection
                $this->initFastLinksRelatedByOwnerCustomerId();
            } else {
                $collFastLinksRelatedByOwnerCustomerId = FastLinkQuery::create(null, $criteria)
                    ->filterByOwnerCustomer($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collFastLinksRelatedByOwnerCustomerIdPartial && count($collFastLinksRelatedByOwnerCustomerId)) {
                        $this->initFastLinksRelatedByOwnerCustomerId(false);

                        foreach ($collFastLinksRelatedByOwnerCustomerId as $obj) {
                            if (false == $this->collFastLinksRelatedByOwnerCustomerId->contains($obj)) {
                                $this->collFastLinksRelatedByOwnerCustomerId->append($obj);
                            }
                        }

                        $this->collFastLinksRelatedByOwnerCustomerIdPartial = true;
                    }

                    return $collFastLinksRelatedByOwnerCustomerId;
                }

                if ($partial && $this->collFastLinksRelatedByOwnerCustomerId) {
                    foreach ($this->collFastLinksRelatedByOwnerCustomerId as $obj) {
                        if ($obj->isNew()) {
                            $collFastLinksRelatedByOwnerCustomerId[] = $obj;
                        }
                    }
                }

                $this->collFastLinksRelatedByOwnerCustomerId = $collFastLinksRelatedByOwnerCustomerId;
                $this->collFastLinksRelatedByOwnerCustomerIdPartial = false;
            }
        }

        return $this->collFastLinksRelatedByOwnerCustomerId;
    }

    /**
     * Sets a collection of FastLink objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param      Collection $fastLinksRelatedByOwnerCustomerId A Propel collection.
     * @param      ConnectionInterface $con Optional connection object
     * @return $this|ChildCustomer The current object (for fluent API support)
     */
    public function setFastLinksRelatedByOwnerCustomerId(Collection $fastLinksRelatedByOwnerCustomerId, ConnectionInterface $con = null)
    {
        /** @var FastLink[] $fastLinksRelatedByOwnerCustomerIdToDelete */
        $fastLinksRelatedByOwnerCustomerIdToDelete = $this->getFastLinksRelatedByOwnerCustomerId(new Criteria(), $con)->diff($fastLinksRelatedByOwnerCustomerId);


        $this->fastLinksRelatedByOwnerCustomerIdScheduledForDeletion = $fastLinksRelatedByOwnerCustomerIdToDelete;

        foreach ($fastLinksRelatedByOwnerCustomerIdToDelete as $fastLinkRelatedByOwnerCustomerIdRemoved) {
            $fastLinkRelatedByOwnerCustomerIdRemoved->setOwnerCustomer(null);
        }

        $this->collFastLinksRelatedByOwnerCustomerId = null;
        foreach ($fastLinksRelatedByOwnerCustomerId as $fastLinkRelatedByOwnerCustomerId) {
            $this->addFastLinkRelatedByOwnerCustomerId($fastLinkRelatedByOwnerCustomerId);
        }

        $this->collFastLinksRelatedByOwnerCustomerId = $fastLinksRelatedByOwnerCustomerId;
        $this->collFastLinksRelatedByOwnerCustomerIdPartial = false;

        return $this;
    }

    /**
     * Returns the number of related BaseFastLink objects.
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct
     * @param      ConnectionInterface $con
     * @return int             Count of related BaseFastLink objects.
     * @throws PropelException
     */
    public function countFastLinksRelatedByOwnerCustomerId(Criteria $criteria = null, $distinct = false, ConnectionInterface $con = null)
    {
        $partial = $this->collFastLinksRelatedByOwnerCustomerIdPartial && !$this->isNew();
        if (null === $this->collFastLinksRelatedByOwnerCustomerId || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collFastLinksRelatedByOwnerCustomerId) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getFastLinksRelatedByOwnerCustomerId());
            }

            $query = FastLinkQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByOwnerCustomer($this)
                ->count($con);
        }

        return count($this->collFastLinksRelatedByOwnerCustomerId);
    }

    /**
     * Method called to associate a FastLink object to this object
     * through the FastLink foreign key attribute.
     *
     * @param  FastLink $l FastLink
     * @return $this|\Shop\Models\Customer\Customer The current object (for fluent API support)
     */
    public function addFastLinkRelatedByOwnerCustomerId(FastLink $l)
    {
        if ($this->collFastLinksRelatedByOwnerCustomerId === null) {
            $this->initFastLinksRelatedByOwnerCustomerId();
            $this->collFastLinksRelatedByOwnerCustomerIdPartial = true;
        }

        if (!$this->collFastLinksRelatedByOwnerCustomerId->contains($l)) {
            $this->doAddFastLinkRelatedByOwnerCustomerId($l);

            if ($this->fastLinksRelatedByOwnerCustomerIdScheduledForDeletion and $this->fastLinksRelatedByOwnerCustomerIdScheduledForDeletion->contains($l)) {
                $this->fastLinksRelatedByOwnerCustomerIdScheduledForDeletion->remove($this->fastLinksRelatedByOwnerCustomerIdScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param FastLink $fastLinkRelatedByOwnerCustomerId The FastLink object to add.
     */
    protected function doAddFastLinkRelatedByOwnerCustomerId(FastLink $fastLinkRelatedByOwnerCustomerId)
    {
        $this->collFastLinksRelatedByOwnerCustomerId[]= $fastLinkRelatedByOwnerCustomerId;
        $fastLinkRelatedByOwnerCustomerId->setOwnerCustomer($this);
    }

    /**
     * @param  FastLink $fastLinkRelatedByOwnerCustomerId The FastLink object to remove.
     * @return $this|ChildCustomer The current object (for fluent API support)
     */
    public function removeFastLinkRelatedByOwnerCustomerId(FastLink $fastLinkRelatedByOwnerCustomerId)
    {
        if ($this->getFastLinksRelatedByOwnerCustomerId()->contains($fastLinkRelatedByOwnerCustomerId)) {
            $pos = $this->collFastLinksRelatedByOwnerCustomerId->search($fastLinkRelatedByOwnerCustomerId);
            $this->collFastLinksRelatedByOwnerCustomerId->remove($pos);
            if (null === $this->fastLinksRelatedByOwnerCustomerIdScheduledForDeletion) {
                $this->fastLinksRelatedByOwnerCustomerIdScheduledForDeletion = clone $this->collFastLinksRelatedByOwnerCustomerId;
                $this->fastLinksRelatedByOwnerCustomerIdScheduledForDeletion->clear();
            }
            $this->fastLinksRelatedByOwnerCustomerIdScheduledForDeletion[]= clone $fastLinkRelatedByOwnerCustomerId;
            $fastLinkRelatedByOwnerCustomerId->setOwnerCustomer(null);
        }

        return $this;
    }

    /**
     * Gets a single FastLink object, which is related to this object by a one-to-one relationship.
     *
     * @param  ConnectionInterface $con optional connection object
     * @return FastLink
     * @throws PropelException
     */
    public function getFastLinkRelatedByCode(ConnectionInterface $con = null)
    {

        if ($this->singleFastLinkRelatedByCode === null && !$this->isNew()) {
            $this->singleFastLinkRelatedByCode = FastLinkQuery::create()->findPk($this->getPrimaryKey(), $con);
        }

        return $this->singleFastLinkRelatedByCode;
    }

    /**
     * Sets a single FastLink object as related to this object by a one-to-one relationship.
     *
     * @param  FastLink $v FastLink
     * @return $this|\Shop\Models\Customer\Customer The current object (for fluent API support)
     * @throws PropelException
     */
    public function setFastLinkRelatedByCode(FastLink $v = null)
    {
        $this->singleFastLinkRelatedByCode = $v;

        // Make sure that that the passed-in FastLink isn't already associated with this object
        if ($v !== null && $v->getCustomer(null, false) === null) {
            $v->setCustomer($this);
        }

        return $this;
    }

    /**
     * Clears the current object, sets all attributes to their default values and removes
     * outgoing references as well as back-references (from other objects to this one. Results probably in a database
     * change of those foreign objects when you call `save` there).
     */
    public function clear()
    {
        if (null !== $this->aCustomerGroup) {
            $this->aCustomerGroup->removeCustomer($this);
        }
        if (null !== $this->aCustomerCity) {
            $this->aCustomerCity->removeCustomer($this);
        }
        if (null !== $this->aManager) {
            $this->aManager->removeCustomer($this);
        }
        $this->id = null;
        $this->name = null;
        $this->email = null;
        $this->password = null;
        $this->phone = null;
        $this->registred = null;
        $this->lastauth = null;
        $this->blocked = null;
        $this->notify_type = null;
        $this->delete = null;
        $this->discount = null;
        $this->inn = null;
        $this->info_hidden = null;
        $this->group_id = null;
        $this->city_id = null;
        $this->manager_id = null;
        $this->notify_order = null;
        $this->notify_news = null;
        $this->notify_products = null;
        $this->alreadyInSave = false;
        $this->clearAllReferences();
        $this->applyDefaultValues();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references and back-references to other model objects or collections of model objects.
     *
     * This method is used to reset all php object references (not the actual reference in the database).
     * Necessary for object serialisation.
     *
     * @param      boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
            if ($this->singleSocialLogin) {
                $this->singleSocialLogin->clearAllReferences($deep);
            }
            if ($this->singleBasket) {
                $this->singleBasket->clearAllReferences($deep);
            }
            if ($this->collOrders) {
                foreach ($this->collOrders as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collFastLinksRelatedByOwnerCustomerId) {
                foreach ($this->collFastLinksRelatedByOwnerCustomerId as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->singleFastLinkRelatedByCode) {
                $this->singleFastLinkRelatedByCode->clearAllReferences($deep);
            }
        } // if ($deep)

        $this->singleSocialLogin = null;
        $this->singleBasket = null;
        $this->collOrders = null;
        $this->collFastLinksRelatedByOwnerCustomerId = null;
        $this->singleFastLinkRelatedByCode = null;
        $this->aCustomerGroup = null;
        $this->aCustomerCity = null;
        $this->aManager = null;
    }

    /**
     * Return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(CustomerTableMap::DEFAULT_STRING_FORMAT);
    }

    /**
     * Code to be run before persisting the object
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preSave(ConnectionInterface $con = null)
    {
        if (is_callable('parent::preSave')) {
            return parent::preSave($con);
        }
        return true;
    }

    /**
     * Code to be run after persisting the object
     * @param ConnectionInterface $con
     */
    public function postSave(ConnectionInterface $con = null)
    {
        if (is_callable('parent::postSave')) {
            parent::postSave($con);
        }
    }

    /**
     * Code to be run before inserting to database
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preInsert(ConnectionInterface $con = null)
    {
        if (is_callable('parent::preInsert')) {
            return parent::preInsert($con);
        }
        return true;
    }

    /**
     * Code to be run after inserting to database
     * @param ConnectionInterface $con
     */
    public function postInsert(ConnectionInterface $con = null)
    {
        if (is_callable('parent::postInsert')) {
            parent::postInsert($con);
        }
    }

    /**
     * Code to be run before updating the object in database
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preUpdate(ConnectionInterface $con = null)
    {
        if (is_callable('parent::preUpdate')) {
            return parent::preUpdate($con);
        }
        return true;
    }

    /**
     * Code to be run after updating the object in database
     * @param ConnectionInterface $con
     */
    public function postUpdate(ConnectionInterface $con = null)
    {
        if (is_callable('parent::postUpdate')) {
            parent::postUpdate($con);
        }
    }

    /**
     * Code to be run before deleting the object in database
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preDelete(ConnectionInterface $con = null)
    {
        if (is_callable('parent::preDelete')) {
            return parent::preDelete($con);
        }
        return true;
    }

    /**
     * Code to be run after deleting the object in database
     * @param ConnectionInterface $con
     */
    public function postDelete(ConnectionInterface $con = null)
    {
        if (is_callable('parent::postDelete')) {
            parent::postDelete($con);
        }
    }


    /**
     * Derived method to catches calls to undefined methods.
     *
     * Provides magic import/export method support (fromXML()/toXML(), fromYAML()/toYAML(), etc.).
     * Allows to define default __call() behavior if you overwrite __call()
     *
     * @param string $name
     * @param mixed  $params
     *
     * @return array|string
     */
    public function __call($name, $params)
    {
        if (0 === strpos($name, 'get')) {
            $virtualColumn = substr($name, 3);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }

            $virtualColumn = lcfirst($virtualColumn);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }
        }

        if (0 === strpos($name, 'from')) {
            $format = substr($name, 4);

            return $this->importFrom($format, reset($params));
        }

        if (0 === strpos($name, 'to')) {
            $format = substr($name, 2);
            $includeLazyLoadColumns = isset($params[0]) ? $params[0] : true;

            return $this->exportTo($format, $includeLazyLoadColumns);
        }

        throw new BadMethodCallException(sprintf('Call to undefined method: %s.', $name));
    }

}
