<?php

namespace Shop\Commands;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Input\StringInput;
use Symfony\Component\Console\Input\ArrayInput;
use Symfony\Component\Process\Process;
use Symfony\Component\Process\Exception\ProcessFailedException;
use samdark\sitemap\Sitemap as SitemapLib;
use Diamond\Repositories\Page as pageRepo;
use Shop\Repositories\Product as productRepo;
use Shop\Repositories\Category as categoryRepo;

/**
 * Description of SitemapCommand
 *
 * @author Admin
 */
class Sitemap extends Command {

    protected $pageRepo;
    protected $productRepo;
    protected $categoryRepo;

    function __construct($name = null, pageRepo $pageRepo, productRepo $productRepo, categoryRepo $categoryRepo) {

        $this->pageRepo = $pageRepo;
        $this->productRepo = $productRepo;
        $this->categoryRepo = $categoryRepo;

        parent::__construct($name);
    }

    protected function configure() {
        $this->setName('sitemap:create')
                ->setDescription('Create simemap.xml');
    }

    protected function execute(InputInterface $input, OutputInterface $output) {

        $sitemap = new SitemapLib(BASEPATH . '/public_html/sitemap.xml');

        $baseurl = rtrim(getenv("BASE_URL"),"/");

        //Генерируем страницы
        $pages = $this->pageRepo->buildQuery()
                ->filterByActive("Y")
                ->filterBySystem("N")
                ->find();

        foreach ($pages as $page) {
            $sitemap->addItem($baseurl . $page->getUrl(), time(), SitemapLib::DAILY, 1);
        }

        //-----------
        $categories = $this->categoryRepo->findAll();
        
        foreach ($categories as $category){
            
            $sitemap->addItem(
                    sprintf(
                            "%s/catalog/%s", $baseurl, $category->getAlias()
                    )
                    , time(), SitemapLib::DAILY, 0.9);            
            
        }


        //-------------------
        $products = $this->productRepo->buildQuery()
                ->filterByActive("Y")
                ->find();

        foreach ($products as $product) {
            $sitemap->addItem(
                    sprintf(
                            "%s/catalog/%s/%s-%s", $baseurl, $product->getCategory()->getAlias(), $product->getId(), \Shop\Helpers\Text::replaceAndTranslite($product->getTitle())
                    )
                    , time(), SitemapLib::DAILY, 0.8);
        }


        try {
            $sitemap->write();
            $output->writeln("sitemap.xml create completed!");
        } catch (\Exception $ex) {
            $output->writeln("sitemap.xml create error!");
        }
    }

}
