<?php
namespace Payment;

/**
 * Платежка paymaster
 */
class Paymaster{

    private $LMI_MERCHANT_ID;

    private $transaction_table = 'pp_paymaster_transactions';
    
    private $currency = 'RUB';
    
    protected $config;
    
    function __construct(Config $config) {

        
        $this->config = $config;
        $this->LMI_MERCHANT_ID = $config->getMerchantId();
        
//        $this->CI = & get_instance();
//
//        Loader::getConfig('eshop\paymaster');
//        Loader::getModel('eshop\paymaster_trans_model');
    }

    public function getTransactionId($data) {
        $str = implode(';', $data);
        return md5($str);//base64_encode
    }


    public function createTransaction($summ,$LMI_PAYMENT_AMOUNT,$commission, $LMI_PAYMENT_DESC,$order_code) {
                
        $code = $this->getTransactionId(array(
            'LMI_PAYMENT_AMOUNT'    =>  $LMI_PAYMENT_AMOUNT,
            'order_code'            =>  $order_code,
            'LMI_MERCHANT_ID'       =>  $this->LMI_MERCHANT_ID
        ));
     
        if(!$this->is_confirmed($code)){
        
            $insert_data = array(
                'trn_code'          =>  $code,
                'trn_order_summ'    =>  $summ,
                'trn_payed_summ'    =>  $LMI_PAYMENT_AMOUNT,
                'trn_commission'    =>  $commission,
                'trn_desc'          =>  $LMI_PAYMENT_DESC,
                'trn_currency'      =>  $this->currency,
                'trn_order_code'    =>  $order_code
            );
            
            if($result = $this->CI->paymaster_trans_model->insert_ignore($insert_data,TRUE)){
                return $code;    
            }    
            else{
                return FALSE;
            }     
        }
        else{
            return FALSE;
        }
    }
    
    /**
     * Проверка на завершенность транзакции
     * 
     * @param type $code
     */
    public function is_confirmed($code) {
        $trans = $this->CI->paymaster_trans_model->get_by(array(
            'trn_code'      =>  $code,
            'trn_confirmed' =>  'Y'
        ));
        if($trans){
            return true;
        }
        else{
            return false;
        }
    }

    /*
     * Обновление платежа
     */
    public function updateTransaction($transaction_code,$status,$confirm = false) {
        $trans = $this->CI->paymaster_trans_model->get_by(array(
            'trn_code'      =>  $transaction_code,
            'trn_confirmed' =>  'N'
        ));
        
        if(isset($trans['trn_id'])){
 
            $this->CI->paymaster_trans_model->update($trans['trn_id'],array(
                'trn_result'    => $status,
                'trn_confirmed' => (!$confirm  ? 'N' : 'Y')
            ));
            
            return $trans;
        }
        else{
            return FALSE;
        }
    }

    /**
     * Расчет суммы для оплаты с учетом коммисии
     * 
     * @param type $summ
     * @param type $commission
     * @param type $reverse
     * @return type
     */
    public function getPaySumm($summ, $reverse = FALSE) {
        
        $commission = $this->config->getCommistion();
        
        if (!$reverse) {
            $summ_all = $summ + ($summ / 100 * $commission);

            $result = round($summ + ($summ_all / 100 * $commission ), 2);
        }
        else {
            $result = $summ - round(($summ / 100 * $commission), 2);
        }

        return $result;
    }

}
