<?php


namespace MoySklad\Infrastructure;


use Diamond\Infrastructure\Models\User\UserQuery;
use MoySklad\Domain\Provider\ProviderEntity;
use MoySklad\Domain\Remain\RemainCollection;
use MoySklad\Domain\Stock\StockEntity;


class MoySkladSupplyRepository extends MoySkladRepository
{
    public function findByCriteria(SearchCriteria $criteria): RemainCollection
    {
        $httpClient = $this->getHttpClient();

        $remainCollection = new RemainCollection();

        //Получение инфы о складе
        try {

            $key = 'entity/store/' . $criteria->getFilterByStockId();

            if (!$result = $this->getInCache($key)) {
                $store = $httpClient->get('entity/store/' . $criteria->getFilterByStockId());
                $this->addInCache($key, serialize($store));
            } else {
                $store = unserialize($result);
            }

        } catch (\GuzzleHttp\Exception\ServerException $ex) {
            $this->logger->error($ex->getMessage());
            throw new RepositoryException('Service Unavailable');
        }

        $stockEntity = (new StockEntity())->setName($store->name)->setId($store->id);

        //получаем приемки
        $httpClient = $this->getHttpClient();

        $offset = ($criteria->getPage() - 1) * $criteria->getLimit();
        
        $result = $httpClient->get('report/stock/all', [
            'limit' => $criteria->getLimit(),
            'offset' => $offset,
            'store.id' => $criteria->getFilterByStockId(),
            'stockMode' => 'positiveOnly',
            'groupBy' => 'product'
        ]);

        foreach ($result->rows as $remain) {

            $productLink = $remain->meta->href;

            $provider = (new ProviderEntity())
                ->setName('Не определен')
                ->setId(0);

            $this->buildRemainPosition(
                $remainCollection,
                $remain,
                $criteria,
                $httpClient,
                $productLink,
                $provider,
                $stockEntity
            );
        }


        UserQuery::create()->count();
        $this->logger->debug('оживили базу при получении приемок');

        return $remainCollection;
    }

}