<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 26.05.2020
 * Time: 22:33
 */

namespace MoySklad\Infrastructure\MoySkladTask;


use Diamond\Repositories\PropelAbstractRepository;
use MoySklad\Domain\MoySkladTask\Contracts\MoySkladCriteriaInterface;
use MoySklad\Domain\MoySkladTask\MoySkladTaskCollection;
use MoySklad\Models\MoySkladTask\MoySkladTask;
use MoySklad\Models\MoySkladTask\MoySkladTaskQuery;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;


class MoySkladTaskRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{
    public function findByCriteria(PaginationInterface $criteria): CollectionInterface
    {
        $query = $this->createQuery();
        $this->modifyCriteria($criteria, $query);
        $result = $query->paginate($criteria->getPage(), $criteria->getLimit());

        $collection = new MoySkladTaskCollection();

        foreach ($result->getResults() as $row) {
            $collection->push($row);
        }

        return $collection;
    }


    public static function createEntity(): EntityInterface
    {
        return new MoySkladTask();
    }

    protected function createQuery(): ModelCriteria
    {
        return MoySkladTaskQuery::create();
    }

    /**
     * @param PaginationInterface|MoySkladCriteriaInterface $criteria
     * @param ModelCriteria|MoySkladTaskQuery $dbCriteria
     */
    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {
        $this->modifyCriteriaForFilterSort($criteria, $dbCriteria);

        $dbCriteria
            //------------------
            ->_if($criteria->getFilterByActive() !== null)
            ->filterByActive($criteria->getFilterByActive() === true ? 1 : 0)
            ->_endif()
            //---------------------
            ->_if($criteria->getSearchBySalePrice() !== null)
            ->filterBySalePrice('%' . $criteria->getSearchBySalePrice() . '%', Criteria::LIKE)
            ->_endif()
            //------------------
            ->_if($criteria->getSearchByStockId() !== null)
            ->filterByStockId('%' . $criteria->getSearchByStockId() . '%', Criteria::LIKE)
            ->_endif();
    }


}