<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 20.05.2020
 * Time: 23:29
 */

namespace MoySklad\Domain\Provider;


class FullAddress
{

    /**
     * @var string
     */
    protected $postalCode;
    /**
     * @var string
     */
    protected $city;
    /**
     * @var string
     */
    protected $street;
    /**
     * @var string
     */
    protected $house;
    /**
     * @var string
     */
    protected $apartment;

    public function __construct(?string $postalCode,? string $city,?string  $street,?string $house,?string $apartment)
    {
        $this->postalCode = $postalCode;
        $this->city = $city;
        $this->street = $street;
        $this->house = $house;
        $this->apartment = $apartment;
    }

    /**
     * @return string
     */
    public function getPostalCode(): ?string
    {
        return $this->postalCode;
    }

    /**
     * @return string
     */
    public function getCity(): ?string
    {
        return $this->city;
    }

    /**
     * @return string
     */
    public function getStreet(): ?string
    {
        return $this->street;
    }

    /**
     * @return string
     */
    public function getHouse(): ?string
    {
        return $this->house;
    }

    /**
     * @return string
     */
    public function getApartment(): ?string
    {
        return $this->apartment;
    }

}