<?php


namespace MoySklad\Domain\MoySkladTask\Contracts;


use Repo\PaginationInterface;
use Repo\RepositoryCriteriaInterface;

interface MoySkladCriteriaInterface extends RepositoryCriteriaInterface, PaginationInterface
{

    /**
     * @return string|null
     */
    public function getSearchByStockId(): ?string;

    /**
     * @param bool|null $active
     * @return mixed
     */
    public function setFilterByActive(?bool $active);

    /**
     * @return bool|null
     */
    public function getFilterByActive(): ?bool;

    /**
     * @return string|null
     */
    public function getSearchBySalePrice():?string ;

    /**
     * @param string|null $price
     * @return mixed
     */
    public function setSearchBySalePrice(?string $price);
}