<?php

namespace MoySklad\Models\MoySkladTask\Map;

use MoySklad\Models\MoySkladTask\MoySkladTask;
use MoySklad\Models\MoySkladTask\MoySkladTaskQuery;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;


/**
 * This class defines the structure of the 'moysklad_tasks' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class MoySkladTaskTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'Models.MoySkladTask.Map.MoySkladTaskTableMap';

    /**
     * The default database name for this class
     */
    const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    const TABLE_NAME = 'moysklad_tasks';

    /**
     * The related Propel class for this table
     */
    const OM_CLASS = '\\MoySklad\\Models\\MoySkladTask\\MoySkladTask';

    /**
     * A class that can be returned by this tableMap
     */
    const CLASS_DEFAULT = 'Models.MoySkladTask.MoySkladTask';

    /**
     * The total number of columns
     */
    const NUM_COLUMNS = 15;

    /**
     * The number of lazy-loaded columns
     */
    const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    const NUM_HYDRATE_COLUMNS = 15;

    /**
     * the column name for the id field
     */
    const COL_ID = 'moysklad_tasks.id';

    /**
     * the column name for the sale_price field
     */
    const COL_SALE_PRICE = 'moysklad_tasks.sale_price';

    /**
     * the column name for the brand_id field
     */
    const COL_BRAND_ID = 'moysklad_tasks.brand_id';

    /**
     * the column name for the category_id field
     */
    const COL_CATEGORY_ID = 'moysklad_tasks.category_id';

    /**
     * the column name for the login field
     */
    const COL_LOGIN = 'moysklad_tasks.login';

    /**
     * the column name for the password field
     */
    const COL_PASSWORD = 'moysklad_tasks.password';

    /**
     * the column name for the active field
     */
    const COL_ACTIVE = 'moysklad_tasks.active';

    /**
     * the column name for the complete field
     */
    const COL_COMPLETE = 'moysklad_tasks.complete';

    /**
     * the column name for the stock_id field
     */
    const COL_STOCK_ID = 'moysklad_tasks.stock_id';

    /**
     * the column name for the mark field
     */
    const COL_MARK = 'moysklad_tasks.mark';

    /**
     * the column name for the datetime_start field
     */
    const COL_DATETIME_START = 'moysklad_tasks.datetime_start';

    /**
     * the column name for the datetime_end field
     */
    const COL_DATETIME_END = 'moysklad_tasks.datetime_end';

    /**
     * the column name for the pricelist_sheet_id field
     */
    const COL_PRICELIST_SHEET_ID = 'moysklad_tasks.pricelist_sheet_id';

    /**
     * the column name for the time_start field
     */
    const COL_TIME_START = 'moysklad_tasks.time_start';

    /**
     * the column name for the interval field
     */
    const COL_INTERVAL = 'moysklad_tasks.interval';

    /**
     * The default string format for model objects of the related table
     */
    const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     */
    protected static $fieldNames = array (
        self::TYPE_PHPNAME       => array('Id', 'SalePrice', 'BrandId', 'CategoryId', 'Login', 'Password', 'Active', 'Complete', 'StockId', 'Mark', 'DateTimeStart', 'DateTimeEnd', 'PricelistSheetId', 'TimeStart', 'Interval', ),
        self::TYPE_CAMELNAME     => array('id', 'salePrice', 'brandId', 'categoryId', 'login', 'password', 'active', 'complete', 'stockId', 'mark', 'dateTimeStart', 'dateTimeEnd', 'pricelistSheetId', 'timeStart', 'interval', ),
        self::TYPE_COLNAME       => array(MoySkladTaskTableMap::COL_ID, MoySkladTaskTableMap::COL_SALE_PRICE, MoySkladTaskTableMap::COL_BRAND_ID, MoySkladTaskTableMap::COL_CATEGORY_ID, MoySkladTaskTableMap::COL_LOGIN, MoySkladTaskTableMap::COL_PASSWORD, MoySkladTaskTableMap::COL_ACTIVE, MoySkladTaskTableMap::COL_COMPLETE, MoySkladTaskTableMap::COL_STOCK_ID, MoySkladTaskTableMap::COL_MARK, MoySkladTaskTableMap::COL_DATETIME_START, MoySkladTaskTableMap::COL_DATETIME_END, MoySkladTaskTableMap::COL_PRICELIST_SHEET_ID, MoySkladTaskTableMap::COL_TIME_START, MoySkladTaskTableMap::COL_INTERVAL, ),
        self::TYPE_FIELDNAME     => array('id', 'sale_price', 'brand_id', 'category_id', 'login', 'password', 'active', 'complete', 'stock_id', 'mark', 'datetime_start', 'datetime_end', 'pricelist_sheet_id', 'time_start', 'interval', ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, )
    );

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     */
    protected static $fieldKeys = array (
        self::TYPE_PHPNAME       => array('Id' => 0, 'SalePrice' => 1, 'BrandId' => 2, 'CategoryId' => 3, 'Login' => 4, 'Password' => 5, 'Active' => 6, 'Complete' => 7, 'StockId' => 8, 'Mark' => 9, 'DateTimeStart' => 10, 'DateTimeEnd' => 11, 'PricelistSheetId' => 12, 'TimeStart' => 13, 'Interval' => 14, ),
        self::TYPE_CAMELNAME     => array('id' => 0, 'salePrice' => 1, 'brandId' => 2, 'categoryId' => 3, 'login' => 4, 'password' => 5, 'active' => 6, 'complete' => 7, 'stockId' => 8, 'mark' => 9, 'dateTimeStart' => 10, 'dateTimeEnd' => 11, 'pricelistSheetId' => 12, 'timeStart' => 13, 'interval' => 14, ),
        self::TYPE_COLNAME       => array(MoySkladTaskTableMap::COL_ID => 0, MoySkladTaskTableMap::COL_SALE_PRICE => 1, MoySkladTaskTableMap::COL_BRAND_ID => 2, MoySkladTaskTableMap::COL_CATEGORY_ID => 3, MoySkladTaskTableMap::COL_LOGIN => 4, MoySkladTaskTableMap::COL_PASSWORD => 5, MoySkladTaskTableMap::COL_ACTIVE => 6, MoySkladTaskTableMap::COL_COMPLETE => 7, MoySkladTaskTableMap::COL_STOCK_ID => 8, MoySkladTaskTableMap::COL_MARK => 9, MoySkladTaskTableMap::COL_DATETIME_START => 10, MoySkladTaskTableMap::COL_DATETIME_END => 11, MoySkladTaskTableMap::COL_PRICELIST_SHEET_ID => 12, MoySkladTaskTableMap::COL_TIME_START => 13, MoySkladTaskTableMap::COL_INTERVAL => 14, ),
        self::TYPE_FIELDNAME     => array('id' => 0, 'sale_price' => 1, 'brand_id' => 2, 'category_id' => 3, 'login' => 4, 'password' => 5, 'active' => 6, 'complete' => 7, 'stock_id' => 8, 'mark' => 9, 'datetime_start' => 10, 'datetime_end' => 11, 'pricelist_sheet_id' => 12, 'time_start' => 13, 'interval' => 14, ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, )
    );

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('moysklad_tasks');
        $this->setPhpName('MoySkladTask');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\MoySklad\\Models\\MoySkladTask\\MoySkladTask');
        $this->setPackage('Models.MoySkladTask');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('sale_price', 'SalePrice', 'VARCHAR', false, 100, null);
        $this->addForeignKey('brand_id', 'BrandId', 'INTEGER', 'shop_brands', 'id', false, null, null);
        $this->addForeignKey('category_id', 'CategoryId', 'INTEGER', 'shop_categories', 'id', false, null, null);
        $this->addColumn('login', 'Login', 'VARCHAR', false, 255, null);
        $this->addColumn('password', 'Password', 'VARCHAR', false, 255, null);
        $this->addColumn('active', 'Active', 'TINYINT', true, null, 1);
        $this->addColumn('complete', 'Complete', 'TINYINT', true, null, 0);
        $this->addColumn('stock_id', 'StockId', 'VARCHAR', false, 255, null);
        $this->addColumn('mark', 'Mark', 'INTEGER', false, null, null);
        $this->addColumn('datetime_start', 'DateTimeStart', 'TIMESTAMP', false, null, null);
        $this->addColumn('datetime_end', 'DateTimeEnd', 'TIMESTAMP', false, null, null);
        $this->addForeignKey('pricelist_sheet_id', 'PricelistSheetId', 'INTEGER', 'shop_pricelist_sheets', 'id', false, null, null);
        $this->addColumn('time_start', 'TimeStart', 'CHAR', false, null, '00:00');
        $this->addColumn('interval', 'Interval', 'CHAR', false, null, '1d');
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
        $this->addRelation('ShopBrand', '\\Shop\\Models\\Brand\\Brand', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':brand_id',
    1 => ':id',
  ),
), null, null, null, false);
        $this->addRelation('Category', '\\Shop\\Models\\Category\\Category', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':category_id',
    1 => ':id',
  ),
), null, null, null, false);
        $this->addRelation('PricelistSheet', '\\Shop\\Models\\PricelistSheet\\PricelistSheet', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':pricelist_sheet_id',
    1 => ':id',
  ),
), null, null, null, false);
    } // buildRelations()

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param boolean $withPrefix Whether or not to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass($withPrefix = true)
    {
        return $withPrefix ? MoySkladTaskTableMap::CLASS_DEFAULT : MoySkladTaskTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array  $row       row returned by DataFetcher->fetch().
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array           (MoySkladTask object, last column rank)
     */
    public static function populateObject($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        $key = MoySkladTaskTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = MoySkladTaskTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + MoySkladTaskTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = MoySkladTaskTableMap::OM_CLASS;
            /** @var MoySkladTask $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            MoySkladTaskTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher)
    {
        $results = array();

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = MoySkladTaskTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = MoySkladTaskTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var MoySkladTask $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                MoySkladTaskTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria object containing the columns to add.
     * @param string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function addSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->addSelectColumn(MoySkladTaskTableMap::COL_ID);
            $criteria->addSelectColumn(MoySkladTaskTableMap::COL_SALE_PRICE);
            $criteria->addSelectColumn(MoySkladTaskTableMap::COL_BRAND_ID);
            $criteria->addSelectColumn(MoySkladTaskTableMap::COL_CATEGORY_ID);
            $criteria->addSelectColumn(MoySkladTaskTableMap::COL_LOGIN);
            $criteria->addSelectColumn(MoySkladTaskTableMap::COL_PASSWORD);
            $criteria->addSelectColumn(MoySkladTaskTableMap::COL_ACTIVE);
            $criteria->addSelectColumn(MoySkladTaskTableMap::COL_COMPLETE);
            $criteria->addSelectColumn(MoySkladTaskTableMap::COL_STOCK_ID);
            $criteria->addSelectColumn(MoySkladTaskTableMap::COL_MARK);
            $criteria->addSelectColumn(MoySkladTaskTableMap::COL_DATETIME_START);
            $criteria->addSelectColumn(MoySkladTaskTableMap::COL_DATETIME_END);
            $criteria->addSelectColumn(MoySkladTaskTableMap::COL_PRICELIST_SHEET_ID);
            $criteria->addSelectColumn(MoySkladTaskTableMap::COL_TIME_START);
            $criteria->addSelectColumn(MoySkladTaskTableMap::COL_INTERVAL);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.sale_price');
            $criteria->addSelectColumn($alias . '.brand_id');
            $criteria->addSelectColumn($alias . '.category_id');
            $criteria->addSelectColumn($alias . '.login');
            $criteria->addSelectColumn($alias . '.password');
            $criteria->addSelectColumn($alias . '.active');
            $criteria->addSelectColumn($alias . '.complete');
            $criteria->addSelectColumn($alias . '.stock_id');
            $criteria->addSelectColumn($alias . '.mark');
            $criteria->addSelectColumn($alias . '.datetime_start');
            $criteria->addSelectColumn($alias . '.datetime_end');
            $criteria->addSelectColumn($alias . '.pricelist_sheet_id');
            $criteria->addSelectColumn($alias . '.time_start');
            $criteria->addSelectColumn($alias . '.interval');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap()
    {
        return Propel::getServiceContainer()->getDatabaseMap(MoySkladTaskTableMap::DATABASE_NAME)->getTable(MoySkladTaskTableMap::TABLE_NAME);
    }

    /**
     * Add a TableMap instance to the database for this tableMap class.
     */
    public static function buildTableMap()
    {
        $dbMap = Propel::getServiceContainer()->getDatabaseMap(MoySkladTaskTableMap::DATABASE_NAME);
        if (!$dbMap->hasTable(MoySkladTaskTableMap::TABLE_NAME)) {
            $dbMap->addTableObject(new MoySkladTaskTableMap());
        }
    }

    /**
     * Performs a DELETE on the database, given a MoySkladTask or Criteria object OR a primary key value.
     *
     * @param mixed               $values Criteria or MoySkladTask object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param  ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ConnectionInterface $con = null)
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(MoySkladTaskTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \MoySklad\Models\MoySkladTask\MoySkladTask) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(MoySkladTaskTableMap::DATABASE_NAME);
            $criteria->add(MoySkladTaskTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = MoySkladTaskQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            MoySkladTaskTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                MoySkladTaskTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the moysklad_tasks table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(ConnectionInterface $con = null)
    {
        return MoySkladTaskQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a MoySkladTask or Criteria object.
     *
     * @param mixed               $criteria Criteria or MoySkladTask object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed           The new primary key.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(MoySkladTaskTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from MoySkladTask object
        }

        if ($criteria->containsKey(MoySkladTaskTableMap::COL_ID) && $criteria->keyContainsValue(MoySkladTaskTableMap::COL_ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.MoySkladTaskTableMap::COL_ID.')');
        }


        // Set the correct dbName
        $query = MoySkladTaskQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

} // MoySkladTaskTableMap
// This is the static code needed to register the TableMap for this table with the main Propel class.
//
MoySkladTaskTableMap::buildTableMap();
