<?php


namespace MoySklad\Application\Commands\CreateOrder;


use Shop\Domain\CustomerOrder\Contracts\CustomerOrderEntityInterface;

class CreateOrderCommand
{

    /**
     * @var CustomerOrderEntityInterface
     */
    protected $order;

    /**
     * @var null|string
     */
    protected $resultId;

    /**
     * @var string
     */
    protected $remoteStock;

    public function __construct(CustomerOrderEntityInterface $order, string $remoteStock)
    {
        $this->order = $order;
        $this->remoteStock = $remoteStock;
    }

    /**
     * @return CustomerOrderEntityInterface
     */
    public function getOrder(): CustomerOrderEntityInterface
    {
        return $this->order;
    }

    /**
     * @return int|null
     */
    public function getResultId():?string
    {
        return $this->resultId;
    }

    /**
     * @param string|null $resultId
     * @return CreateOrderCommand
     */
    public function setResultId(?string $resultId): CreateOrderCommand
    {
        $this->resultId = $resultId;
        return $this;
    }

    /**
     * @return string
     */
    public function getRemoteStock(): string
    {
        return $this->remoteStock;
    }

}