<?php

namespace MoySklad\Models\MoySkladTask;

use MoySklad\Domain\MoySkladTask\Contracts\MoySkladEntityInterface;
use MoySklad\Models\MoySkladTask\Base\MoySkladTask as BaseMoySkladTask;

/**
 * Skeleton subclass for representing a row from the 'moysklad_tasks' table.
 *
 *
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 */
class MoySkladTask extends BaseMoySkladTask implements MoySkladEntityInterface
{
    /**
     * @return string
     */
    public function getStockUuid(): string
    {
        $stock = $this->getStockId();
        return preg_replace('~.*\[(.*?)\]~is', '$1', $stock);
    }

    public function getStockLabel(): string
    {
        $stock = $this->getStockId();
        return preg_replace('~(\[.*?\])~is', '', $stock);
    }
}
