<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 20.05.2020
 * Time: 22:56
 */

namespace MoySklad\Infrastructure;


use Repo\Concrete\AbstractCriteria;

class SearchCriteria extends AbstractCriteria
{

    /**
     * @var string|null
     */
    protected $filterByContractorName;

    /**
     * онже адрес, он же направление
     * @var string|null
     */
    protected $filterByProviderAddress;

    /**
     * @var string
     */
    protected $filterByStockId;

    /**
     * фильтр по цене продажи
     * если фильтр активен будет получена цена продажи товара вместо цены закупа
     * @var string
     */
    protected $filterBySalePrice;

    /**
     * @return string|null
     */
    public function getFilterByContractorName(): ?string
    {
        return $this->filterByContractorName;
    }

    /**
     * @param string|null $filterByContractorName
     * @return SearchCriteria
     */
    public function setFilterByContractorName(?string $filterByContractorName): SearchCriteria
    {
        $this->filterByContractorName = $filterByContractorName;
        return $this;
    }

    /**
     * @return string
     */
    public function getFilterBySalePrice(): string
    {
        return $this->filterBySalePrice;
    }

    /**
     * @param string $filterBySalePrice
     * @return SearchCriteria
     */
    public function setFilterBySalePrice(string $filterBySalePrice): SearchCriteria
    {
        $this->filterBySalePrice = $filterBySalePrice;
        return $this;
    }


    /**
     * @return string|null
     */
    public function getFilterByStockId(): string
    {
        return $this->filterByStockId;
    }

    /**
     * @param string|null $filterByStockId
     * @return SearchCriteria
     */
    public function setFilterByStockId(string $filterByStockId): SearchCriteria
    {
        $this->filterByStockId = $filterByStockId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getFilterByProviderAddress(): ?string
    {
        return $this->filterByProviderAddress;
    }

    /**
     * @param string|null $filterByProviderAddress
     * @return SearchCriteria
     */
    public function setFilterByProviderAddress(?string $filterByProviderAddress): SearchCriteria
    {
        $this->filterByProviderAddress = $filterByProviderAddress;
        return $this;
    }


    /**
     * @return SearchCriteria
     */
    public static function create()
    {
        return new self();
    }

}