<?php

namespace MoySklad\Infrastructure\MoySkladTask;


use MoySklad\Domain\MoySkladTask\Contracts\MoySkladCriteriaInterface;
use Repo\Concrete\AbstractCriteria;

class MoySkladCriteria extends AbstractCriteria implements MoySkladCriteriaInterface
{

    /**
     * @var string|null
     */
    protected $searchByStockId;

    /**
     * @var string|null
     */
    protected $searchBySalePrice;

    /**
     * @var bool|null
     */
    protected $filterByActive;

    /**
     * @return string|null
     */
    public function getSearchBySalePrice(): ?string
    {
        return $this->searchBySalePrice;
    }

    /**
     * @param string|null $searchBySalePrice
     * @return MoySkladCriteria
     */
    public function setSearchBySalePrice(?string $searchBySalePrice): MoySkladCriteria
    {
        $this->searchBySalePrice = $searchBySalePrice;
        return $this;
    }


    /**
     * @return string|null
     */
    public function getSearchByStockId(): ?string
    {
        return $this->searchByStockId;
    }

    /**
     * @param string|null $searchByStockId
     * @return MoySkladCriteria
     */
    public function setSearchByStockId(?string $searchByStockId): MoySkladCriteria
    {
        $this->searchByStockId = $searchByStockId;
        return $this;
    }


    public static function create()
    {
        return new self();
    }

    public function setFilterByActive(?bool $active)
    {
        $this->filterByActive = $active;
        return $this;
    }

    public function getFilterByActive(): ?bool
    {
        return$this->filterByActive;
    }


}