<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 20.05.2020
 * Time: 22:49
 */

namespace MoySklad\Domain\Remain;


use MoySklad\Domain\Provider\ProviderEntity;
use MoySklad\Domain\Stock\StockEntity;
use Repo\Concrete\AbstractEntity;

class RemainEntity extends AbstractEntity
{

    /**
     * @var ProviderEntity
     */
    protected $provider;

    /**
     * @var StockEntity
     */
    protected $stock;

    /**
     * @var float
     */
    protected $price;

    /**
     * @var string
     */
    protected $currency = 'Руб.';

    /**
     * @var string
     */
    protected $code;

    /**
     * @var string
     */
    protected $name;

    /**
     * @var int
     */
    protected $remains;

    /**
     * @var float
     */
    protected $weight;

    /**
     * @return ProviderEntity
     */
    public function getProvider(): ProviderEntity
    {
        return $this->provider;
    }

    /**
     * @param ProviderEntity $provider
     * @return RemainEntity
     */
    public function setProvider(ProviderEntity $provider): RemainEntity
    {
        $this->provider = $provider;
        return $this;
    }

    /**
     * @return StockEntity
     */
    public function getStock(): StockEntity
    {
        return $this->stock;
    }

    /**
     * @param StockEntity $stock
     * @return RemainEntity
     */
    public function setStock(StockEntity $stock): RemainEntity
    {
        $this->stock = $stock;
        return $this;
    }

    /**
     * @return float
     */
    public function getPrice(): float
    {
        return $this->price;
    }

    /**
     * @param float $price
     * @return RemainEntity
     */
    public function setPrice(float $price): RemainEntity
    {
        $this->price = $price;
        return $this;
    }

    /**
     * @return string
     */
    public function getCode(): string
    {
        return $this->code;
    }

    /**
     * @param string $code
     * @return RemainEntity
     */
    public function setCode(string $code): RemainEntity
    {
        $this->code = $code;
        return $this;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return RemainEntity
     */
    public function setName(string $name): RemainEntity
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return int
     */
    public function getRemains(): int
    {
        return $this->remains;
    }

    /**
     * @param int $remains
     * @return RemainEntity
     */
    public function setRemains(int $remains): RemainEntity
    {
        $this->remains = $remains;
        return $this;
    }

    /**
     * @return float
     */
    public function getWeight(): float
    {
        return $this->weight;
    }

    /**
     * @param float $weight
     * @return RemainEntity
     */
    public function setWeight(float $weight): RemainEntity
    {
        $this->weight = $weight;
        return $this;
    }

    /**
     * @return string
     */
    public function getCurrency(): string
    {
        return $this->currency;
    }

    /**
     * @param string $currency
     * @return RemainEntity
     */
    public function setCurrency(string $currency): RemainEntity
    {
        $this->currency = $currency;
        return $this;
    }



}