<?php


namespace MoySklad\Application\Modules\AdminSyncMySklad;


use ActiveTable\Contracts\CommandInterface;
use ActiveTable\DataTableEngine;
use Diamond\Helpers\Form;
use MoySklad\Application\Commands\UpdatePriceListFromRemains\UpdatePriceListsByTaskCommand;
use MoySklad\Application\Commands\UpdatePriceListFromRemains\UpdatePriceListsByTaskException;
use MoySklad\Infrastructure\MoySkladTask\MoySkladCriteria;
use spaceonfire\CommandBus\CommandBus;
use Symfony\Component\HttpFoundation\RedirectResponse;

class UpdatePriceListsAction implements CommandInterface
{
    protected $registry;
    protected $commandBus;

    /**
     * UpdatePriceListsAction constructor.
     * @param DataTableEngine $registry
     * @param CommandBus $commandBus
     */
    public function __construct(DataTableEngine $registry, CommandBus $commandBus)
    {
        $this->registry = $registry;
        $this->commandBus = $commandBus;
    }

    /**
     *
     */
    public function process(): void
    {
        $ids = Form::getIdsFromRequest();
        $repo = $this->registry->getRepo();

        $success = $errors = [];

        $tasks = $repo->findByCriteria(
            MoySkladCriteria::create()->setFilterByIds($ids)
        );

        foreach ($tasks as $task) {
            try {
                $this->commandBus->handle(new UpdatePriceListsByTaskCommand($task->getId()));
                $success[] = $task->getId();
            } catch (UpdatePriceListsByTaskException $ex) {
                $errors[] = $task->getId();
            }

        }

        if(count($success)){
            Form::addTableNotice(Form::buildSuccessMessage(
                sprintf(
                    'Следующий задания № %s успешно обновили прайс-листы',
                    implode(',', $success)
                )
            ));
        }

        if(count($errors)){
            Form::addTableNotice(Form::buildErrorMessage(
                sprintf(
                    'Следующий обновления заданий № %s завершились с ошибкой',
                    implode(',', $errors)
                )
            ));
        }

        RedirectResponse::create(adaptive_url([], ['fn', 'id']))->send();
    }


}