<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 21.05.2020
 * Time: 22:04
 */

namespace MoySklad\Infrastructure;


use MoySklad\Domain\Stock\StockCollection;
use MoySklad\Domain\Stock\StockEntity;
use Psr\Log\LoggerAwareInterface;
use Psr\Log\LoggerAwareTrait;
use Psr\Log\NullLogger;

class StockRepository implements LoggerAwareInterface
{
    use LoggerAwareTrait;
    use MoySkladClient;


    public function __construct(string $login, string $password)
    {
        $this->login = $login;
        $this->password = $password;
        $this->logger = new NullLogger();
    }

    /**
     * @param SearchCriteria $criteria
     * @return StockCollection
     * @throws \Repo\Concrete\Exceptions\Collection
     * @throws \Throwable
     */
    public function findByCriteria(SearchCriteria $criteria): StockCollection
    {
        $httpClient = $this->getHttpClient();

        $stockCollection = new StockCollection();

        $stores = $httpClient->get('entity/store', [
            'offset' => 0,
            'maxResults' => 50,
            'limit' => 50
        ]);

        if (count($stores->rows) === 0) {
            return $stockCollection;
        }

        foreach ((array)$stores->rows as $stock) {
            $stockCollection->push(
                (new StockEntity())->setName($stock->name)->setId($stock->id)
            );
        }

        return $stockCollection;
    }

    /**
     * @param string $stockId
     * @return int
     * @throws \Throwable
     */
    public function getRemainCountByStock(string $stockId): int
    {
        $httpClient = $this->getHttpClient();

        $result = $httpClient->get('report/stock/all', [
            'limit' => 1,
            'store.id' => $stockId,
            'stockMode'=> 'positiveOnly',
            'groupBy' => 'product'
        ]);

        return $result->meta->size;
    }

}