<?php

namespace MoySklad\Models\MoySkladTask\Base;

use \Exception;
use \PDO;
use MoySklad\Models\MoySkladTask\MoySkladTask as ChildMoySkladTask;
use MoySklad\Models\MoySkladTask\MoySkladTaskQuery as ChildMoySkladTaskQuery;
use MoySklad\Models\MoySkladTask\Map\MoySkladTaskTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Shop\Models\Brand\Brand;
use Shop\Models\Category\Category;
use Shop\Models\PricelistSheet\PricelistSheet;

/**
 * Base class that represents a query for the 'moysklad_tasks' table.
 *
 *
 *
 * @method     ChildMoySkladTaskQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildMoySkladTaskQuery orderBySalePrice($order = Criteria::ASC) Order by the sale_price column
 * @method     ChildMoySkladTaskQuery orderByBrandId($order = Criteria::ASC) Order by the brand_id column
 * @method     ChildMoySkladTaskQuery orderByCategoryId($order = Criteria::ASC) Order by the category_id column
 * @method     ChildMoySkladTaskQuery orderByLogin($order = Criteria::ASC) Order by the login column
 * @method     ChildMoySkladTaskQuery orderByPassword($order = Criteria::ASC) Order by the password column
 * @method     ChildMoySkladTaskQuery orderByActive($order = Criteria::ASC) Order by the active column
 * @method     ChildMoySkladTaskQuery orderByComplete($order = Criteria::ASC) Order by the complete column
 * @method     ChildMoySkladTaskQuery orderByStockId($order = Criteria::ASC) Order by the stock_id column
 * @method     ChildMoySkladTaskQuery orderByMark($order = Criteria::ASC) Order by the mark column
 * @method     ChildMoySkladTaskQuery orderByDateTimeStart($order = Criteria::ASC) Order by the datetime_start column
 * @method     ChildMoySkladTaskQuery orderByDateTimeEnd($order = Criteria::ASC) Order by the datetime_end column
 * @method     ChildMoySkladTaskQuery orderByPricelistSheetId($order = Criteria::ASC) Order by the pricelist_sheet_id column
 * @method     ChildMoySkladTaskQuery orderByTimeStart($order = Criteria::ASC) Order by the time_start column
 * @method     ChildMoySkladTaskQuery orderByInterval($order = Criteria::ASC) Order by the interval column
 *
 * @method     ChildMoySkladTaskQuery groupById() Group by the id column
 * @method     ChildMoySkladTaskQuery groupBySalePrice() Group by the sale_price column
 * @method     ChildMoySkladTaskQuery groupByBrandId() Group by the brand_id column
 * @method     ChildMoySkladTaskQuery groupByCategoryId() Group by the category_id column
 * @method     ChildMoySkladTaskQuery groupByLogin() Group by the login column
 * @method     ChildMoySkladTaskQuery groupByPassword() Group by the password column
 * @method     ChildMoySkladTaskQuery groupByActive() Group by the active column
 * @method     ChildMoySkladTaskQuery groupByComplete() Group by the complete column
 * @method     ChildMoySkladTaskQuery groupByStockId() Group by the stock_id column
 * @method     ChildMoySkladTaskQuery groupByMark() Group by the mark column
 * @method     ChildMoySkladTaskQuery groupByDateTimeStart() Group by the datetime_start column
 * @method     ChildMoySkladTaskQuery groupByDateTimeEnd() Group by the datetime_end column
 * @method     ChildMoySkladTaskQuery groupByPricelistSheetId() Group by the pricelist_sheet_id column
 * @method     ChildMoySkladTaskQuery groupByTimeStart() Group by the time_start column
 * @method     ChildMoySkladTaskQuery groupByInterval() Group by the interval column
 *
 * @method     ChildMoySkladTaskQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildMoySkladTaskQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildMoySkladTaskQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildMoySkladTaskQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildMoySkladTaskQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildMoySkladTaskQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildMoySkladTaskQuery leftJoinShopBrand($relationAlias = null) Adds a LEFT JOIN clause to the query using the ShopBrand relation
 * @method     ChildMoySkladTaskQuery rightJoinShopBrand($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ShopBrand relation
 * @method     ChildMoySkladTaskQuery innerJoinShopBrand($relationAlias = null) Adds a INNER JOIN clause to the query using the ShopBrand relation
 *
 * @method     ChildMoySkladTaskQuery joinWithShopBrand($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the ShopBrand relation
 *
 * @method     ChildMoySkladTaskQuery leftJoinWithShopBrand() Adds a LEFT JOIN clause and with to the query using the ShopBrand relation
 * @method     ChildMoySkladTaskQuery rightJoinWithShopBrand() Adds a RIGHT JOIN clause and with to the query using the ShopBrand relation
 * @method     ChildMoySkladTaskQuery innerJoinWithShopBrand() Adds a INNER JOIN clause and with to the query using the ShopBrand relation
 *
 * @method     ChildMoySkladTaskQuery leftJoinCategory($relationAlias = null) Adds a LEFT JOIN clause to the query using the Category relation
 * @method     ChildMoySkladTaskQuery rightJoinCategory($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Category relation
 * @method     ChildMoySkladTaskQuery innerJoinCategory($relationAlias = null) Adds a INNER JOIN clause to the query using the Category relation
 *
 * @method     ChildMoySkladTaskQuery joinWithCategory($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Category relation
 *
 * @method     ChildMoySkladTaskQuery leftJoinWithCategory() Adds a LEFT JOIN clause and with to the query using the Category relation
 * @method     ChildMoySkladTaskQuery rightJoinWithCategory() Adds a RIGHT JOIN clause and with to the query using the Category relation
 * @method     ChildMoySkladTaskQuery innerJoinWithCategory() Adds a INNER JOIN clause and with to the query using the Category relation
 *
 * @method     ChildMoySkladTaskQuery leftJoinPricelistSheet($relationAlias = null) Adds a LEFT JOIN clause to the query using the PricelistSheet relation
 * @method     ChildMoySkladTaskQuery rightJoinPricelistSheet($relationAlias = null) Adds a RIGHT JOIN clause to the query using the PricelistSheet relation
 * @method     ChildMoySkladTaskQuery innerJoinPricelistSheet($relationAlias = null) Adds a INNER JOIN clause to the query using the PricelistSheet relation
 *
 * @method     ChildMoySkladTaskQuery joinWithPricelistSheet($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the PricelistSheet relation
 *
 * @method     ChildMoySkladTaskQuery leftJoinWithPricelistSheet() Adds a LEFT JOIN clause and with to the query using the PricelistSheet relation
 * @method     ChildMoySkladTaskQuery rightJoinWithPricelistSheet() Adds a RIGHT JOIN clause and with to the query using the PricelistSheet relation
 * @method     ChildMoySkladTaskQuery innerJoinWithPricelistSheet() Adds a INNER JOIN clause and with to the query using the PricelistSheet relation
 *
 * @method     \Shop\Models\Brand\BrandQuery|\Shop\Models\Category\CategoryQuery|\Shop\Models\PricelistSheet\PricelistSheetQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildMoySkladTask findOne(ConnectionInterface $con = null) Return the first ChildMoySkladTask matching the query
 * @method     ChildMoySkladTask findOneOrCreate(ConnectionInterface $con = null) Return the first ChildMoySkladTask matching the query, or a new ChildMoySkladTask object populated from the query conditions when no match is found
 *
 * @method     ChildMoySkladTask findOneById(int $id) Return the first ChildMoySkladTask filtered by the id column
 * @method     ChildMoySkladTask findOneBySalePrice(string $sale_price) Return the first ChildMoySkladTask filtered by the sale_price column
 * @method     ChildMoySkladTask findOneByBrandId(int $brand_id) Return the first ChildMoySkladTask filtered by the brand_id column
 * @method     ChildMoySkladTask findOneByCategoryId(int $category_id) Return the first ChildMoySkladTask filtered by the category_id column
 * @method     ChildMoySkladTask findOneByLogin(string $login) Return the first ChildMoySkladTask filtered by the login column
 * @method     ChildMoySkladTask findOneByPassword(string $password) Return the first ChildMoySkladTask filtered by the password column
 * @method     ChildMoySkladTask findOneByActive(int $active) Return the first ChildMoySkladTask filtered by the active column
 * @method     ChildMoySkladTask findOneByComplete(int $complete) Return the first ChildMoySkladTask filtered by the complete column
 * @method     ChildMoySkladTask findOneByStockId(string $stock_id) Return the first ChildMoySkladTask filtered by the stock_id column
 * @method     ChildMoySkladTask findOneByMark(int $mark) Return the first ChildMoySkladTask filtered by the mark column
 * @method     ChildMoySkladTask findOneByDateTimeStart(string $datetime_start) Return the first ChildMoySkladTask filtered by the datetime_start column
 * @method     ChildMoySkladTask findOneByDateTimeEnd(string $datetime_end) Return the first ChildMoySkladTask filtered by the datetime_end column
 * @method     ChildMoySkladTask findOneByPricelistSheetId(int $pricelist_sheet_id) Return the first ChildMoySkladTask filtered by the pricelist_sheet_id column
 * @method     ChildMoySkladTask findOneByTimeStart(string $time_start) Return the first ChildMoySkladTask filtered by the time_start column
 * @method     ChildMoySkladTask findOneByInterval(string $interval) Return the first ChildMoySkladTask filtered by the interval column *

 * @method     ChildMoySkladTask requirePk($key, ConnectionInterface $con = null) Return the ChildMoySkladTask by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMoySkladTask requireOne(ConnectionInterface $con = null) Return the first ChildMoySkladTask matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildMoySkladTask requireOneById(int $id) Return the first ChildMoySkladTask filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMoySkladTask requireOneBySalePrice(string $sale_price) Return the first ChildMoySkladTask filtered by the sale_price column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMoySkladTask requireOneByBrandId(int $brand_id) Return the first ChildMoySkladTask filtered by the brand_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMoySkladTask requireOneByCategoryId(int $category_id) Return the first ChildMoySkladTask filtered by the category_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMoySkladTask requireOneByLogin(string $login) Return the first ChildMoySkladTask filtered by the login column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMoySkladTask requireOneByPassword(string $password) Return the first ChildMoySkladTask filtered by the password column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMoySkladTask requireOneByActive(int $active) Return the first ChildMoySkladTask filtered by the active column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMoySkladTask requireOneByComplete(int $complete) Return the first ChildMoySkladTask filtered by the complete column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMoySkladTask requireOneByStockId(string $stock_id) Return the first ChildMoySkladTask filtered by the stock_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMoySkladTask requireOneByMark(int $mark) Return the first ChildMoySkladTask filtered by the mark column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMoySkladTask requireOneByDateTimeStart(string $datetime_start) Return the first ChildMoySkladTask filtered by the datetime_start column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMoySkladTask requireOneByDateTimeEnd(string $datetime_end) Return the first ChildMoySkladTask filtered by the datetime_end column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMoySkladTask requireOneByPricelistSheetId(int $pricelist_sheet_id) Return the first ChildMoySkladTask filtered by the pricelist_sheet_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMoySkladTask requireOneByTimeStart(string $time_start) Return the first ChildMoySkladTask filtered by the time_start column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMoySkladTask requireOneByInterval(string $interval) Return the first ChildMoySkladTask filtered by the interval column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildMoySkladTask[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildMoySkladTask objects based on current ModelCriteria
 * @method     ChildMoySkladTask[]|ObjectCollection findById(int $id) Return ChildMoySkladTask objects filtered by the id column
 * @method     ChildMoySkladTask[]|ObjectCollection findBySalePrice(string $sale_price) Return ChildMoySkladTask objects filtered by the sale_price column
 * @method     ChildMoySkladTask[]|ObjectCollection findByBrandId(int $brand_id) Return ChildMoySkladTask objects filtered by the brand_id column
 * @method     ChildMoySkladTask[]|ObjectCollection findByCategoryId(int $category_id) Return ChildMoySkladTask objects filtered by the category_id column
 * @method     ChildMoySkladTask[]|ObjectCollection findByLogin(string $login) Return ChildMoySkladTask objects filtered by the login column
 * @method     ChildMoySkladTask[]|ObjectCollection findByPassword(string $password) Return ChildMoySkladTask objects filtered by the password column
 * @method     ChildMoySkladTask[]|ObjectCollection findByActive(int $active) Return ChildMoySkladTask objects filtered by the active column
 * @method     ChildMoySkladTask[]|ObjectCollection findByComplete(int $complete) Return ChildMoySkladTask objects filtered by the complete column
 * @method     ChildMoySkladTask[]|ObjectCollection findByStockId(string $stock_id) Return ChildMoySkladTask objects filtered by the stock_id column
 * @method     ChildMoySkladTask[]|ObjectCollection findByMark(int $mark) Return ChildMoySkladTask objects filtered by the mark column
 * @method     ChildMoySkladTask[]|ObjectCollection findByDateTimeStart(string $datetime_start) Return ChildMoySkladTask objects filtered by the datetime_start column
 * @method     ChildMoySkladTask[]|ObjectCollection findByDateTimeEnd(string $datetime_end) Return ChildMoySkladTask objects filtered by the datetime_end column
 * @method     ChildMoySkladTask[]|ObjectCollection findByPricelistSheetId(int $pricelist_sheet_id) Return ChildMoySkladTask objects filtered by the pricelist_sheet_id column
 * @method     ChildMoySkladTask[]|ObjectCollection findByTimeStart(string $time_start) Return ChildMoySkladTask objects filtered by the time_start column
 * @method     ChildMoySkladTask[]|ObjectCollection findByInterval(string $interval) Return ChildMoySkladTask objects filtered by the interval column
 * @method     ChildMoySkladTask[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class MoySkladTaskQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \MoySklad\Models\MoySkladTask\Base\MoySkladTaskQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\MoySklad\\Models\\MoySkladTask\\MoySkladTask', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildMoySkladTaskQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildMoySkladTaskQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildMoySkladTaskQuery) {
            return $criteria;
        }
        $query = new ChildMoySkladTaskQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildMoySkladTask|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(MoySkladTaskTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = MoySkladTaskTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildMoySkladTask A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `sale_price`, `brand_id`, `category_id`, `login`, `password`, `active`, `complete`, `stock_id`, `mark`, `datetime_start`, `datetime_end`, `pricelist_sheet_id`, `time_start`, `interval` FROM `moysklad_tasks` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildMoySkladTask $obj */
            $obj = new ChildMoySkladTask();
            $obj->hydrate($row);
            MoySkladTaskTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildMoySkladTask|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildMoySkladTaskQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(MoySkladTaskTableMap::COL_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildMoySkladTaskQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(MoySkladTaskTableMap::COL_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildMoySkladTaskQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(MoySkladTaskTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(MoySkladTaskTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MoySkladTaskTableMap::COL_ID, $id, $comparison);
    }

    /**
     * Filter the query on the sale_price column
     *
     * Example usage:
     * <code>
     * $query->filterBySalePrice('fooValue');   // WHERE sale_price = 'fooValue'
     * $query->filterBySalePrice('%fooValue%', Criteria::LIKE); // WHERE sale_price LIKE '%fooValue%'
     * </code>
     *
     * @param     string $salePrice The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildMoySkladTaskQuery The current query, for fluid interface
     */
    public function filterBySalePrice($salePrice = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($salePrice)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MoySkladTaskTableMap::COL_SALE_PRICE, $salePrice, $comparison);
    }

    /**
     * Filter the query on the brand_id column
     *
     * Example usage:
     * <code>
     * $query->filterByBrandId(1234); // WHERE brand_id = 1234
     * $query->filterByBrandId(array(12, 34)); // WHERE brand_id IN (12, 34)
     * $query->filterByBrandId(array('min' => 12)); // WHERE brand_id > 12
     * </code>
     *
     * @see       filterByShopBrand()
     *
     * @param     mixed $brandId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildMoySkladTaskQuery The current query, for fluid interface
     */
    public function filterByBrandId($brandId = null, $comparison = null)
    {
        if (is_array($brandId)) {
            $useMinMax = false;
            if (isset($brandId['min'])) {
                $this->addUsingAlias(MoySkladTaskTableMap::COL_BRAND_ID, $brandId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($brandId['max'])) {
                $this->addUsingAlias(MoySkladTaskTableMap::COL_BRAND_ID, $brandId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MoySkladTaskTableMap::COL_BRAND_ID, $brandId, $comparison);
    }

    /**
     * Filter the query on the category_id column
     *
     * Example usage:
     * <code>
     * $query->filterByCategoryId(1234); // WHERE category_id = 1234
     * $query->filterByCategoryId(array(12, 34)); // WHERE category_id IN (12, 34)
     * $query->filterByCategoryId(array('min' => 12)); // WHERE category_id > 12
     * </code>
     *
     * @see       filterByCategory()
     *
     * @param     mixed $categoryId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildMoySkladTaskQuery The current query, for fluid interface
     */
    public function filterByCategoryId($categoryId = null, $comparison = null)
    {
        if (is_array($categoryId)) {
            $useMinMax = false;
            if (isset($categoryId['min'])) {
                $this->addUsingAlias(MoySkladTaskTableMap::COL_CATEGORY_ID, $categoryId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($categoryId['max'])) {
                $this->addUsingAlias(MoySkladTaskTableMap::COL_CATEGORY_ID, $categoryId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MoySkladTaskTableMap::COL_CATEGORY_ID, $categoryId, $comparison);
    }

    /**
     * Filter the query on the login column
     *
     * Example usage:
     * <code>
     * $query->filterByLogin('fooValue');   // WHERE login = 'fooValue'
     * $query->filterByLogin('%fooValue%', Criteria::LIKE); // WHERE login LIKE '%fooValue%'
     * </code>
     *
     * @param     string $login The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildMoySkladTaskQuery The current query, for fluid interface
     */
    public function filterByLogin($login = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($login)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MoySkladTaskTableMap::COL_LOGIN, $login, $comparison);
    }

    /**
     * Filter the query on the password column
     *
     * Example usage:
     * <code>
     * $query->filterByPassword('fooValue');   // WHERE password = 'fooValue'
     * $query->filterByPassword('%fooValue%', Criteria::LIKE); // WHERE password LIKE '%fooValue%'
     * </code>
     *
     * @param     string $password The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildMoySkladTaskQuery The current query, for fluid interface
     */
    public function filterByPassword($password = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($password)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MoySkladTaskTableMap::COL_PASSWORD, $password, $comparison);
    }

    /**
     * Filter the query on the active column
     *
     * Example usage:
     * <code>
     * $query->filterByActive(1234); // WHERE active = 1234
     * $query->filterByActive(array(12, 34)); // WHERE active IN (12, 34)
     * $query->filterByActive(array('min' => 12)); // WHERE active > 12
     * </code>
     *
     * @param     mixed $active The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildMoySkladTaskQuery The current query, for fluid interface
     */
    public function filterByActive($active = null, $comparison = null)
    {
        if (is_array($active)) {
            $useMinMax = false;
            if (isset($active['min'])) {
                $this->addUsingAlias(MoySkladTaskTableMap::COL_ACTIVE, $active['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($active['max'])) {
                $this->addUsingAlias(MoySkladTaskTableMap::COL_ACTIVE, $active['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MoySkladTaskTableMap::COL_ACTIVE, $active, $comparison);
    }

    /**
     * Filter the query on the complete column
     *
     * Example usage:
     * <code>
     * $query->filterByComplete(1234); // WHERE complete = 1234
     * $query->filterByComplete(array(12, 34)); // WHERE complete IN (12, 34)
     * $query->filterByComplete(array('min' => 12)); // WHERE complete > 12
     * </code>
     *
     * @param     mixed $complete The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildMoySkladTaskQuery The current query, for fluid interface
     */
    public function filterByComplete($complete = null, $comparison = null)
    {
        if (is_array($complete)) {
            $useMinMax = false;
            if (isset($complete['min'])) {
                $this->addUsingAlias(MoySkladTaskTableMap::COL_COMPLETE, $complete['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($complete['max'])) {
                $this->addUsingAlias(MoySkladTaskTableMap::COL_COMPLETE, $complete['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MoySkladTaskTableMap::COL_COMPLETE, $complete, $comparison);
    }

    /**
     * Filter the query on the stock_id column
     *
     * Example usage:
     * <code>
     * $query->filterByStockId('fooValue');   // WHERE stock_id = 'fooValue'
     * $query->filterByStockId('%fooValue%', Criteria::LIKE); // WHERE stock_id LIKE '%fooValue%'
     * </code>
     *
     * @param     string $stockId The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildMoySkladTaskQuery The current query, for fluid interface
     */
    public function filterByStockId($stockId = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($stockId)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MoySkladTaskTableMap::COL_STOCK_ID, $stockId, $comparison);
    }

    /**
     * Filter the query on the mark column
     *
     * Example usage:
     * <code>
     * $query->filterByMark(1234); // WHERE mark = 1234
     * $query->filterByMark(array(12, 34)); // WHERE mark IN (12, 34)
     * $query->filterByMark(array('min' => 12)); // WHERE mark > 12
     * </code>
     *
     * @param     mixed $mark The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildMoySkladTaskQuery The current query, for fluid interface
     */
    public function filterByMark($mark = null, $comparison = null)
    {
        if (is_array($mark)) {
            $useMinMax = false;
            if (isset($mark['min'])) {
                $this->addUsingAlias(MoySkladTaskTableMap::COL_MARK, $mark['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($mark['max'])) {
                $this->addUsingAlias(MoySkladTaskTableMap::COL_MARK, $mark['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MoySkladTaskTableMap::COL_MARK, $mark, $comparison);
    }

    /**
     * Filter the query on the datetime_start column
     *
     * Example usage:
     * <code>
     * $query->filterByDateTimeStart('2011-03-14'); // WHERE datetime_start = '2011-03-14'
     * $query->filterByDateTimeStart('now'); // WHERE datetime_start = '2011-03-14'
     * $query->filterByDateTimeStart(array('max' => 'yesterday')); // WHERE datetime_start > '2011-03-13'
     * </code>
     *
     * @param     mixed $dateTimeStart The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildMoySkladTaskQuery The current query, for fluid interface
     */
    public function filterByDateTimeStart($dateTimeStart = null, $comparison = null)
    {
        if (is_array($dateTimeStart)) {
            $useMinMax = false;
            if (isset($dateTimeStart['min'])) {
                $this->addUsingAlias(MoySkladTaskTableMap::COL_DATETIME_START, $dateTimeStart['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($dateTimeStart['max'])) {
                $this->addUsingAlias(MoySkladTaskTableMap::COL_DATETIME_START, $dateTimeStart['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MoySkladTaskTableMap::COL_DATETIME_START, $dateTimeStart, $comparison);
    }

    /**
     * Filter the query on the datetime_end column
     *
     * Example usage:
     * <code>
     * $query->filterByDateTimeEnd('2011-03-14'); // WHERE datetime_end = '2011-03-14'
     * $query->filterByDateTimeEnd('now'); // WHERE datetime_end = '2011-03-14'
     * $query->filterByDateTimeEnd(array('max' => 'yesterday')); // WHERE datetime_end > '2011-03-13'
     * </code>
     *
     * @param     mixed $dateTimeEnd The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildMoySkladTaskQuery The current query, for fluid interface
     */
    public function filterByDateTimeEnd($dateTimeEnd = null, $comparison = null)
    {
        if (is_array($dateTimeEnd)) {
            $useMinMax = false;
            if (isset($dateTimeEnd['min'])) {
                $this->addUsingAlias(MoySkladTaskTableMap::COL_DATETIME_END, $dateTimeEnd['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($dateTimeEnd['max'])) {
                $this->addUsingAlias(MoySkladTaskTableMap::COL_DATETIME_END, $dateTimeEnd['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MoySkladTaskTableMap::COL_DATETIME_END, $dateTimeEnd, $comparison);
    }

    /**
     * Filter the query on the pricelist_sheet_id column
     *
     * Example usage:
     * <code>
     * $query->filterByPricelistSheetId(1234); // WHERE pricelist_sheet_id = 1234
     * $query->filterByPricelistSheetId(array(12, 34)); // WHERE pricelist_sheet_id IN (12, 34)
     * $query->filterByPricelistSheetId(array('min' => 12)); // WHERE pricelist_sheet_id > 12
     * </code>
     *
     * @see       filterByPricelistSheet()
     *
     * @param     mixed $pricelistSheetId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildMoySkladTaskQuery The current query, for fluid interface
     */
    public function filterByPricelistSheetId($pricelistSheetId = null, $comparison = null)
    {
        if (is_array($pricelistSheetId)) {
            $useMinMax = false;
            if (isset($pricelistSheetId['min'])) {
                $this->addUsingAlias(MoySkladTaskTableMap::COL_PRICELIST_SHEET_ID, $pricelistSheetId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($pricelistSheetId['max'])) {
                $this->addUsingAlias(MoySkladTaskTableMap::COL_PRICELIST_SHEET_ID, $pricelistSheetId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MoySkladTaskTableMap::COL_PRICELIST_SHEET_ID, $pricelistSheetId, $comparison);
    }

    /**
     * Filter the query on the time_start column
     *
     * Example usage:
     * <code>
     * $query->filterByTimeStart('fooValue');   // WHERE time_start = 'fooValue'
     * $query->filterByTimeStart('%fooValue%', Criteria::LIKE); // WHERE time_start LIKE '%fooValue%'
     * </code>
     *
     * @param     string $timeStart The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildMoySkladTaskQuery The current query, for fluid interface
     */
    public function filterByTimeStart($timeStart = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($timeStart)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MoySkladTaskTableMap::COL_TIME_START, $timeStart, $comparison);
    }

    /**
     * Filter the query on the interval column
     *
     * Example usage:
     * <code>
     * $query->filterByInterval('fooValue');   // WHERE interval = 'fooValue'
     * $query->filterByInterval('%fooValue%', Criteria::LIKE); // WHERE interval LIKE '%fooValue%'
     * </code>
     *
     * @param     string $interval The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildMoySkladTaskQuery The current query, for fluid interface
     */
    public function filterByInterval($interval = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($interval)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MoySkladTaskTableMap::COL_INTERVAL, $interval, $comparison);
    }

    /**
     * Filter the query by a related \Shop\Models\Brand\Brand object
     *
     * @param \Shop\Models\Brand\Brand|ObjectCollection $brand The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildMoySkladTaskQuery The current query, for fluid interface
     */
    public function filterByShopBrand($brand, $comparison = null)
    {
        if ($brand instanceof \Shop\Models\Brand\Brand) {
            return $this
                ->addUsingAlias(MoySkladTaskTableMap::COL_BRAND_ID, $brand->getId(), $comparison);
        } elseif ($brand instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(MoySkladTaskTableMap::COL_BRAND_ID, $brand->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByShopBrand() only accepts arguments of type \Shop\Models\Brand\Brand or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ShopBrand relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildMoySkladTaskQuery The current query, for fluid interface
     */
    public function joinShopBrand($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ShopBrand');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ShopBrand');
        }

        return $this;
    }

    /**
     * Use the ShopBrand relation Brand object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\Brand\BrandQuery A secondary query class using the current class as primary query
     */
    public function useShopBrandQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinShopBrand($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ShopBrand', '\Shop\Models\Brand\BrandQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\Category\Category object
     *
     * @param \Shop\Models\Category\Category|ObjectCollection $category The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildMoySkladTaskQuery The current query, for fluid interface
     */
    public function filterByCategory($category, $comparison = null)
    {
        if ($category instanceof \Shop\Models\Category\Category) {
            return $this
                ->addUsingAlias(MoySkladTaskTableMap::COL_CATEGORY_ID, $category->getId(), $comparison);
        } elseif ($category instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(MoySkladTaskTableMap::COL_CATEGORY_ID, $category->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByCategory() only accepts arguments of type \Shop\Models\Category\Category or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Category relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildMoySkladTaskQuery The current query, for fluid interface
     */
    public function joinCategory($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Category');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Category');
        }

        return $this;
    }

    /**
     * Use the Category relation Category object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\Category\CategoryQuery A secondary query class using the current class as primary query
     */
    public function useCategoryQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinCategory($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Category', '\Shop\Models\Category\CategoryQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\PricelistSheet\PricelistSheet object
     *
     * @param \Shop\Models\PricelistSheet\PricelistSheet|ObjectCollection $pricelistSheet The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildMoySkladTaskQuery The current query, for fluid interface
     */
    public function filterByPricelistSheet($pricelistSheet, $comparison = null)
    {
        if ($pricelistSheet instanceof \Shop\Models\PricelistSheet\PricelistSheet) {
            return $this
                ->addUsingAlias(MoySkladTaskTableMap::COL_PRICELIST_SHEET_ID, $pricelistSheet->getId(), $comparison);
        } elseif ($pricelistSheet instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(MoySkladTaskTableMap::COL_PRICELIST_SHEET_ID, $pricelistSheet->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByPricelistSheet() only accepts arguments of type \Shop\Models\PricelistSheet\PricelistSheet or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the PricelistSheet relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildMoySkladTaskQuery The current query, for fluid interface
     */
    public function joinPricelistSheet($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('PricelistSheet');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'PricelistSheet');
        }

        return $this;
    }

    /**
     * Use the PricelistSheet relation PricelistSheet object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\PricelistSheet\PricelistSheetQuery A secondary query class using the current class as primary query
     */
    public function usePricelistSheetQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinPricelistSheet($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'PricelistSheet', '\Shop\Models\PricelistSheet\PricelistSheetQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ChildMoySkladTask $moySkladTask Object to remove from the list of results
     *
     * @return $this|ChildMoySkladTaskQuery The current query, for fluid interface
     */
    public function prune($moySkladTask = null)
    {
        if ($moySkladTask) {
            $this->addUsingAlias(MoySkladTaskTableMap::COL_ID, $moySkladTask->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the moysklad_tasks table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(MoySkladTaskTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            MoySkladTaskTableMap::clearInstancePool();
            MoySkladTaskTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(MoySkladTaskTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(MoySkladTaskTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            MoySkladTaskTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            MoySkladTaskTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

} // MoySkladTaskQuery
