<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 20.05.2020
 * Time: 23:00
 */

namespace MoySklad\Domain\Stock;

use Core\Repository\DropDownInterface;
use Repo\Concrete\AbstractCollection;

class StockCollection extends AbstractCollection implements DropDownInterface
{
    protected function getEntityClass(): string
    {
        return StockEntity::class;
    }

    /**
     * @return array
     */
    public function getDropdownList():array
    {
        $list = [];
        foreach ($this->_entities as $ob){
            $list[$ob->getName().'['.$ob->getId().']'] = $ob->getName();
        }
        return $list;
    }
}