<?php

namespace MoySklad\Application;

use League\Container\ServiceProvider\BootableServiceProviderInterface;
use Local\Config\Main;
use MoySklad\Application\Commands\CreateOrder\CreateOrderCommand;
use MoySklad\Application\Commands\CreateOrder\CreateOrderHandler;
use MoySklad\Application\Commands\UpdatePriceListFromRemains\UpdatePriceListsByTaskCommand;
use MoySklad\Application\Commands\UpdatePriceListFromRemains\UpdatePriceListsByTaskHandler;
use MoySklad\Application\Contracts\MoySkladLoggerInterface;
use MoySklad\Application\Controllers\Mysklad;
use Core\Contracts\ServiceProviderInterface;
use League\Container\ServiceProvider\AbstractServiceProvider;
use spaceonfire\CommandBus\CommandBus;
use spaceonfire\CommandBus\Mapping\MapByStaticList;
use Twig\Cache\FilesystemCache;

class ServiceProvider extends AbstractServiceProvider
    implements ServiceProviderInterface, BootableServiceProviderInterface
{

    protected $provides = [
        MoySkladService::class
    ];




    public static function getCommandBusMap(): array
    {
       return [
           UpdatePriceListsByTaskCommand::class => [UpdatePriceListsByTaskHandler::class, 'handle'],
           CreateOrderCommand::class => [CreateOrderHandler::class, 'handle']
       ];
    }


    public static function getPackageName(): string
    {
        return 'moysklad';
    }

    /**
     * @return string
     */
    public static function getViewsPath(): string
    {
        return __DIR__ . '/../Presentation/Views';
    }

    /**
     * @return array
     */
    public static function getRoutes(): array
    {
        /**
         * Конфигурирование роутинга для проекта
         */
        return [

            [['POST'], '/_service/mysklad/test', [Mysklad::class, 'test']],

            //склады для формы
            [['GET'], '/_service/mysklad/stocks', [Mysklad::class, 'getStocksDropDown']],
            //подключение к скалду и загрузка остатков
            [['GET'], '/_service/mysklad/remains', [Mysklad::class, 'getRemains']],

            //[['POST'], '/_service/mysklad/remains', [Mysklad::class, 'storeRemains']],
            [['POST'], '/_service/mysklad/remains/commit', [Mysklad::class, 'commitRemains']],
            [['POST'], '/_service/mysklad/remains/part/{part}', [Mysklad::class, 'getRemainsPart']],
            [['GET'], '/_service/mysklad/remains/status', [Mysklad::class, 'getRemainStatus']],

            [['POST'], '/_service/mysklad/remain/{id}', [Mysklad::class, 'updateRemain']],
        ];
    }

    public function register()
    {

//        $this->getContainer()->share(MoySkladLoggerInterface::class,function (){
//            /**
//             * @var Main $config
//             */
//            $config = $this->getContainer()->get(Main::class);
//            $login = $config->getMoyskladLogin();
//            $password = $config->getMoyskladPassword();
//
//            $logger = (new \Monolog\Logger('syncLogger'));
//            $stream = new StreamHandler(
//                self::createLoggerPath($task, $login, $mark)
//            );
//
//            $format = "[%datetime%] [%level_name%] %message% [Context %context% Extra %extra%]\n";
//
//            $stream->setFormatter(new \Monolog\Formatter\LineFormatter($format, 'd/m/Y H:i:s'));
//
//            $logger->pushHandler($stream);
//
//            return $logger;
//        });
//
//        $this->getContainer()->share(
//            MoySkladService::class,function(){
//                /**
//                 * @var Main $config
//                 */
//                $config = $this->getContainer()->get(Main::class);
//                $login = $config->getMoyskladLogin();
//                $password = $config->getMoyskladPassword();
//
//                $sklad = new MoySkladRepository(
//                    $login,
//                    $password,
//                    new FilesystemCache(BASEPATH . '/app/cache/sync_cache')
//                );
//                $sklad->setLogger($logger);
//
//                $sklad2 = new MoySkladSupplyRepository($login, $password, new FilesystemCache(BASEPATH . '/app/cache/sync_cache'));
//                $sklad2->setLogger($logger);
//
//                $stock = new StockRepository($login, $password);
//                $stock->setLogger($logger);
//
//                exit('dnjdnbjnbdj');
//
//            }
//        );


    }

    public function boot()
    {


    }


}