<?php


namespace MoySklad\Application\Commands\UpdatePriceListFromRemains;


use Local\Config\Main;
use MoySklad\Application\MoySkladFactory;
use MoySklad\Application\MoySkladTaskService;
use MoySklad\Infrastructure\MoySkladTask\MoySkladTaskRepository;
use MoySklad\Models\MoySkladTask\MoySkladTask;

/**
 * Class UpdatePriceListsByTaskHandler
 * @package MoySklad\Application\Commands\UpdatePriceListFromRemains
 */
class UpdatePriceListsByTaskHandler
{
    protected $casheBrands = [];
    protected $moySkladTaskRepository;
    protected $mainConfig;
    protected $moySkladTaskService;

    public function __construct(MoySkladTaskRepository $moySkladTaskRepository,
                                MoySkladTaskService $moySkladTaskService,
                                Main $mainConfig)
    {
        $this->moySkladTaskRepository = $moySkladTaskRepository;
        $this->mainConfig = $mainConfig;
        $this->moySkladTaskService = $moySkladTaskService;
    }


    /**
     * @param UpdatePriceListsByTaskCommand $command
     * @throws \Exception
     */
    public function handle(UpdatePriceListsByTaskCommand $command): void
    {

        $taskId = $command->getTaskId();
        $ids = $command->getFilterIds();



        /**
         * @var MoySkladTask $taskEntity
         */
        if (!$taskEntity = $this->moySkladTaskRepository->findById($taskId)) {
            throw new \RuntimeException('taskEntity not found by Id ' . $taskId);
        }

        $login = $this->mainConfig->getMoyskladLogin();

        $priceId = $taskEntity->getPricelistSheetId();
        $categoryDef = $taskEntity->getCategoryId();
        $brandDef = $taskEntity->getBrandId();
        $mark = $taskEntity->getMark();

        if(is_array($ids) && count($ids)){
            array_walk($ids, function (&$value) {
                $value = (int)$value;
            });
        }

        $logger = MoySkladFactory::buildLogger($login, $mark, $taskId);


        //тут не нужен репо. поэтому пароль любой
        $moySkladService = MoySkladFactory::buildService($login, md5(time()), $logger);


        $data = $this->moySkladTaskService->getData($taskId, true, false );


        if(!isset($data['results']) || count($data['results'])===0){
            throw new UpdatePriceListsByTaskException('results not exists in task ' . $taskId);
        }

        if ($priceId) {
            $logger->debug('старт фиксации прайс-листа №' . $priceId);
        } else {
            $logger->debug('режим автопоиска прайс-листов');
        }

        $remains = $data['results'];

        $i = 0;
        $newRemains = [];
        foreach ($remains as $k => $item) {
            $i++;
            if (is_array($ids) && !in_array($i, $ids, true)) {

                continue;
            }

            if ($priceId > 0) {
                $priceListId = $priceId;
            } else {
                $priceListId = $moySkladService->getPriceListId(0, $item['provider']);
            }

            $newRemains[$k] = $item;
            $newRemains[$k]['priceListId'] = $priceListId;
        }

        unset($remains);

        $pricesData = $moySkladService->prepareArrayRemainsDataGroupPrices($newRemains);
        $count = 0;


        foreach ($pricesData as $priceId => $remains) {

            try {
                $price = $moySkladService->buildPrice($remains, $priceId, $categoryDef, $brandDef, $logger, false, $ids);
            } catch (\RuntimeException $ex) {
                $logger->error('прайс-лист не создан. № ' . $priceId);
                continue;
            }

            $count += $price->getPositions()->count();

            //жестко зачичаем данные
            $con = \Propel\Runtime\Propel::getConnection(\Shop\Models\Product\Map\ProductTableMap::DATABASE_NAME);
            $stmt2 = $con->prepare('DELETE FROM shop_positions WHERE pricelist_sheet_id = ' . $priceId);
            $stmt2->execute();

            $logger->debug(sprintf('Прайс-лист %s очищен', $price->getTitle()));
            $price->setDateUpdate(new \DateTime());
            $price->save();
            $logger->debug(sprintf('прайс-лист успешно сохранен, созданно %s записей', $count));
        }

        $command->setEffectedRows($count);
    }

}