<?php

namespace MoySklad\Application;


use Monolog\Handler\StreamHandler;
use MoySklad\Infrastructure\MoySkladRepository;
use MoySklad\Infrastructure\MoySkladSupplyRepository;
use MoySklad\Infrastructure\MoySkladSuuplyRepository;
use MoySklad\Infrastructure\StockRepository;
use Psr\Log\LoggerInterface;
use Psr\Log\NullLogger;
use Shop\Repositories\Brand\BrandRepository;
use Twig\Cache\FilesystemCache;

class MoySkladFactory
{

    /**
     * @param string $login
     * @param string $password
     * @param LoggerInterface|null $logger
     * @return MoySkladService
     */
    public static function buildService(string $login, string $password, ?LoggerInterface $logger = null): MoySkladService
    {
        $logger = $logger ?? new NullLogger();

        $sklad = new MoySkladRepository($login, $password, new FilesystemCache(BASEPATH . '/app/cache/sync_cache'));
        $sklad->setLogger($logger);

        $sklad2 = new MoySkladSupplyRepository($login, $password, new FilesystemCache(BASEPATH . '/app/cache/sync_cache'));
        $sklad2->setLogger($logger);

        $stock = new StockRepository($login, $password);
        $stock->setLogger($logger);

        return new MoySkladService(
            $sklad,
            new BrandRepository(),
            $stock,
            $sklad2
        );
    }


    public static function buildLogger(string $login, int $mark, int $task): LoggerInterface
    {
        $logger = (new \Monolog\Logger('syncLogger'));
        $stream = new StreamHandler(
            self::createLoggerPath($task, $login, $mark)
        );

        $format = "[%datetime%] [%level_name%] %message% [Context %context% Extra %extra%]\n";

        $stream->setFormatter(new \Monolog\Formatter\LineFormatter($format, 'd/m/Y H:i:s'));

        $logger->pushHandler($stream);

        return $logger;
    }

    /**
     * @param int $task
     * @param string $login
     * @param string $mark
     * @return string
     */
    public static function createLoggerPath(int $task, ?string $login, ?string $mark): string
    {
        return BASEPATH . '/app/cache/sync/' . $task . '/' . 'sync_' . $login . '_' . $mark . '.log';
    }

}